/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Concatenate;
import io.atlasmap.v2.Expression;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Split;
import io.atlasmap.v2.Uppercase;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class DefaultAtlasPreviewContextTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void testProcessPreviewConverter() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"404");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.INTEGER);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals(Integer.class, target.getValue().getClass());
        Assert.assertEquals((Object)404, (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSourceFieldAction() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"abc");
        ArrayList<Uppercase> actions = new ArrayList<Uppercase>();
        actions.add(new Uppercase());
        source.setActions(actions);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"ABC", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewTargetFieldAction() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"abc");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        ArrayList<Uppercase> actions = new ArrayList<Uppercase>();
        actions.add(new Uppercase());
        target.setActions(actions);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"ABC", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewCombine() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.COMBINE);
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setIndex(Integer.valueOf(0));
        source1.setValue((Object)"1");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setIndex(Integer.valueOf(1));
        source2.setValue((Object)"2");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source1);
        m.getInputField().add(source2);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"1 2", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSeparate() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.SEPARATE);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"1 2");
        SimpleField target1 = new SimpleField();
        target1.setFieldType(FieldType.STRING);
        target1.setIndex(Integer.valueOf(0));
        SimpleField target2 = new SimpleField();
        target2.setFieldType(FieldType.STRING);
        target2.setIndex(Integer.valueOf(1));
        m.getInputField().add(source);
        m.getOutputField().add(target1);
        m.getOutputField().add(target2);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"1", (Object)target1.getValue());
        Assert.assertEquals((Object)"2", (Object)target2.getValue());
    }

    @Test
    public void testProcessPreviewSourceFieldGroup() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setPath("/one");
        source1.setIndex(Integer.valueOf(0));
        source1.setValue((Object)"one");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/two");
        source2.setIndex(Integer.valueOf(1));
        source2.setValue((Object)"two");
        FieldGroup group = new FieldGroup();
        group.getField().add(source1);
        group.getField().add(source2);
        Expression action = new Expression();
        action.setExpression("${0} + ' and ' + ${1}");
        group.setActions(new ArrayList());
        group.getActions().add(action);
        m.setInputFieldGroup(group);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"one and two", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewConcatenate() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setPath("/one");
        source1.setIndex(Integer.valueOf(1));
        source1.setValue((Object)"one");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/two");
        source2.setIndex(Integer.valueOf(3));
        source2.setValue((Object)"two");
        SimpleField source3 = new SimpleField();
        source3.setFieldType(FieldType.STRING);
        source3.setPath("/six");
        source3.setIndex(Integer.valueOf(5));
        source3.setValue((Object)"six");
        FieldGroup group = new FieldGroup();
        group.getField().add(source1);
        group.getField().add(source2);
        group.getField().add(source3);
        Concatenate action = new Concatenate();
        action.setDelimiter("-");
        action.setDelimitingEmptyValues(Boolean.valueOf(true));
        group.setActions(new ArrayList());
        group.getActions().add(action);
        m.setInputFieldGroup(group);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        Assert.assertEquals((Object)"-one--two--six", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSplit() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"one two three four");
        source.setActions(new ArrayList());
        Split action = new Split();
        action.setDelimiter(" ");
        source.getActions().add(action);
        m.getInputField().add(source);
        SimpleField target1 = new SimpleField();
        target1.setIndex(Integer.valueOf(0));
        target1.setFieldType(FieldType.STRING);
        m.getOutputField().add(target1);
        SimpleField target2 = new SimpleField();
        target2.setIndex(Integer.valueOf(1));
        target2.setFieldType(FieldType.STRING);
        m.getOutputField().add(target2);
        SimpleField target3 = new SimpleField();
        target3.setIndex(Integer.valueOf(3));
        target3.setFieldType(FieldType.STRING);
        m.getOutputField().add(target3);
        Audits audits = this.previewContext.processPreview(m);
        Assert.assertEquals((String)this.printAudit(audits), (long)0L, (long)audits.getAudit().size());
        Assert.assertEquals((Object)"one", (Object)target1.getValue());
        Assert.assertEquals((Object)"two", (Object)target2.getValue());
        Assert.assertEquals((Object)"four", (Object)target3.getValue());
    }

    @Test
    public void testProcessPreviewSourceCollection() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setIndex(Integer.valueOf(0));
        source.setPath("/this<>/is/collection");
        source.setValue((Object)"one");
        source.setActions(new ArrayList());
        Concatenate action = new Concatenate();
        action.setDelimiter(" ");
        source.getActions().add(action);
        m.getInputField().add(source);
        SimpleField target = new SimpleField();
        target.setIndex(Integer.valueOf(0));
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assert.assertEquals((String)this.printAudit(audits), (long)0L, (long)audits.getAudit().size());
        Assert.assertEquals((Object)"one", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewExpression() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.DOUBLE);
        source.setPath("/sourceDouble");
        source.setValue((Object)99.0);
        m.getInputField().add(source);
        SimpleField source2 = new SimpleField();
        source2.setDocId("source2");
        source2.setFieldType(FieldType.DOUBLE);
        source2.setPath("/sourceDouble");
        source2.setValue((Object)1.0);
        m.setExpression("${source:/sourceDouble} + ${source2:/sourceDouble}");
        m.getInputField().add(source2);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assert.assertEquals((String)this.printAudit(audits), (long)0L, (long)audits.getAudit().size());
        Assert.assertEquals((Object)"100.0", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewExpressionNullValue() throws AtlasException {
        Mapping m = new Mapping();
        FieldGroup fg = new FieldGroup();
        m.setInputFieldGroup(fg);
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.DOUBLE);
        source.setPath("/sourceDouble");
        fg.getField().add(source);
        SimpleField source2 = new SimpleField();
        source2.setDocId("source2");
        source2.setFieldType(FieldType.DOUBLE);
        source2.setPath("/sourceDouble");
        source2.setValue((Object)1.0);
        fg.getField().add(source2);
        m.setExpression("IF(ISEMPTY(${source:/sourceDouble}), ${source2:/sourceDouble}, ${source:/sourceDouble})");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assert.assertEquals((String)this.printAudit(audits), (long)0L, (long)audits.getAudit().size());
        Assert.assertEquals((Object)"1.0", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewFieldTypes() throws AtlasException {
        Mapping m = new Mapping();
        Field source = new Field(){
            private static final long serialVersionUID = 1L;
        };
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"foo");
        Field target = new Field(){
            private static final long serialVersionUID = 1L;
        };
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assert.assertEquals((String)this.printAudit(audits), (long)0L, (long)audits.getAudit().size());
        Assert.assertEquals((Object)"foo", (Object)target.getValue());
    }
}

