/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasFunctionResolver;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.FunctionResolver;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasExpressionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasExpressionProcessor.class);

    public static void processExpression(DefaultAtlasSession session, String expression) {
        block8: {
            if (expression == null || expression.trim().isEmpty()) {
                return;
            }
            try {
                Expression parsedExpression;
                Field answer;
                HashMap<String, Field> sourceFieldMap = new HashMap<String, Field>();
                Field parent = session.head().getSourceField();
                if (parent != null && !AtlasUtil.isEmpty(parent.getDocId()) && !AtlasUtil.isEmpty(parent.getPath())) {
                    sourceFieldMap.put(parent.getDocId() + ":" + parent.getPath(), parent);
                }
                if (parent instanceof FieldGroup && AtlasUtil.isEmpty(parent.getPath())) {
                    FieldGroup parentGroup = (FieldGroup)FieldGroup.class.cast(parent);
                    for (Field child : parentGroup.getField()) {
                        if (AtlasUtil.isEmpty(child.getDocId()) && AtlasUtil.isEmpty(child.getPath())) continue;
                        sourceFieldMap.put(child.getDocId() + ":" + child.getPath(), child);
                    }
                }
                if ((answer = (parsedExpression = Expression.parse((String)expression, (FunctionResolver)DefaultAtlasFunctionResolver.getInstance())).evaluate(path -> {
                    if (path == null || path.isEmpty()) {
                        return null;
                    }
                    try {
                        AtlasModule sourceModule;
                        Field f = (Field)sourceFieldMap.get(path);
                        if (f == null) {
                            return null;
                        }
                        Map<String, AtlasModule> sourceModules = session.getAtlasContext().getSourceModules();
                        if (f instanceof ConstantField) {
                            sourceModule = sourceModules.get("io.atlasmap.core.DefaultAtlasContext.constants.docId");
                        } else if (f instanceof PropertyField) {
                            sourceModule = sourceModules.get("io.atlasmap.core.DefaultAtlasContext.properties.docId");
                        } else {
                            String[] splitted = path.split(":", 2);
                            sourceModule = sourceModules.get(splitted[0]);
                        }
                        if (sourceModule == null) {
                            throw new ExpressionException(String.format("Module for the path '%s' is not found", path));
                        }
                        session.head().setSourceField(f);
                        sourceModule.readSourceValue((AtlasInternalSession)session);
                        return session.head().getSourceField();
                    }
                    catch (Exception e) {
                        throw new ExpressionException((Throwable)e);
                    }
                })) instanceof Field) {
                    session.head().setSourceField(answer);
                } else {
                    Field from = session.head().getSourceField();
                    SimpleField to = new SimpleField();
                    AtlasModelFactory.copyField((Field)from, (Field)to, (boolean)false);
                    to.setValue((Object)answer);
                    session.head().setSourceField((Field)to);
                }
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, expression, String.format("Expression processing error [%s]: %s", expression, e.getMessage()), AuditStatus.ERROR, null);
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("", (Throwable)e);
            }
        }
    }
}

