/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.MockField;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ConstantModuleTest {
    private static ConstantModule module = new ConstantModule();

    @Test
    public void testDestroy() {
        module.destroy();
    }

    @Test
    public void testProcessPreValidation() throws AtlasException {
        module.processPreValidation(null);
    }

    @Test
    public void testProcessPreSourceExecution() throws AtlasException {
        module.processPreSourceExecution(null);
    }

    @Test
    public void testProcessSourceFieldMapping() throws AtlasException {
        ConstantField field = (ConstantField)Mockito.mock(ConstantField.class);
        Mockito.when((Object)field.getValue()).thenReturn((Object)"fieldValue");
        AtlasInternalSession.Head head = (AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class);
        Mockito.when((Object)head.getSourceField()).thenReturn((Object)field);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)head);
        DefaultAtlasConversionService atlasConversionService = (DefaultAtlasConversionService)Mockito.mock(DefaultAtlasConversionService.class);
        Mockito.when((Object)atlasConversionService.fieldTypeFromClass((String)ArgumentMatchers.any(String.class))).thenReturn((Object)FieldType.ANY);
        module.setConversionService((AtlasConversionService)atlasConversionService);
        module.readSourceValue(session);
    }

    @Test
    public void testProcessPostSourceExecution() throws AtlasException {
        module.processPostSourceExecution(null);
    }

    @Test
    public void testProcessPreTargetExecution() throws AtlasException {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> module.processPreTargetExecution(null));
    }

    @Test
    public void testProcessTargetFieldMapping() throws AtlasException {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> module.writeTargetValue(null));
    }

    @Test
    public void testProcessPostTargetExecution() throws AtlasException {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> module.processPostTargetExecution(null));
    }

    @Test
    public void testProcessPostValidation() throws AtlasException {
        module.processPostValidation(null);
    }

    @Test
    public void testGetMode() {
        Assertions.assertNotNull((Object)module.getMode());
    }

    @Test
    public void testGetConversionService() {
        Assertions.assertNotNull((Object)module.getConversionService());
    }

    @Test
    public void testListSupportedModes() {
        Assertions.assertNotNull((Object)module.listSupportedModes());
    }

    @Test
    public void testGetDocId() {
        Assertions.assertNull((Object)module.getDocId());
    }

    @Test
    public void testGetUri() {
        Assertions.assertNull((Object)module.getUri());
    }

    @Test
    public void testIsStatisticsSupported() {
        Assertions.assertFalse((boolean)module.isStatisticsSupported());
    }

    @Test
    public void testIsStatisticsEnabled() {
        Assertions.assertFalse((boolean)module.isStatisticsEnabled());
    }

    @Test
    public void testIsSupportedField() {
        Assertions.assertFalse((boolean)module.isSupportedField((Field)new MockField()));
    }

    @Test
    public void testCloneField() throws AtlasException {
        Assertions.assertNull((Object)module.cloneField((Field)new MockField()));
    }

    @Test
    public void testGetFieldActionService() {
        Assertions.assertNull((Object)module.getFieldActionService());
    }
}

