/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasCustomMappingProcessor;
import io.atlasmap.core.DefaultAtlasExpressionProcessor;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.mxbean.AtlasContextMXBean;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.spi.StringDelimiter;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.CopyTo;
import io.atlasmap.v2.CustomMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceKey;
import io.atlasmap.v2.DataSourceMetadata;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.Validations;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContext
implements AtlasContext,
AtlasContextMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasContext.class);
    private ObjectName jmxObjectName;
    private final UUID uuid;
    private DefaultAtlasContextFactory factory;
    private URI atlasMappingUri;
    private ADMArchiveHandler admHandler;
    private Map<String, AtlasModule> sourceModules = new HashMap<String, AtlasModule>();
    private Map<String, AtlasModule> targetModules = new HashMap<String, AtlasModule>();
    private Map<String, LookupTable> lookupTables = new HashMap<String, LookupTable>();
    private Map<DataSourceKey, DataSourceMetadata> dataSourceMetadataMap;
    private boolean initialized;

    public DefaultAtlasContext(URI atlasMappingUri) {
        this(DefaultAtlasContextFactory.getInstance(), atlasMappingUri);
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri) {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.atlasMappingUri = atlasMappingUri;
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, AtlasMapping mapping) {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.admHandler = new ADMArchiveHandler(factory.getClassLoader());
        this.admHandler.setIgnoreLibrary(true);
        this.admHandler.setMappingDefinition(mapping);
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, AtlasContextFactory.Format format, InputStream stream) throws AtlasException {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.admHandler = new ADMArchiveHandler(factory.getClassLoader());
        this.admHandler.setIgnoreLibrary(true);
        this.admHandler.load(format, stream);
        this.dataSourceMetadataMap = this.admHandler.getDataSourceMetadataMap();
    }

    protected synchronized void init() throws AtlasException {
        if (this.initialized) {
            return;
        }
        this.registerJmx(this);
        if (this.atlasMappingUri != null) {
            this.admHandler = new ADMArchiveHandler(this.factory.getClassLoader());
            this.admHandler.setIgnoreLibrary(true);
            this.admHandler.load(Paths.get(this.atlasMappingUri));
            this.dataSourceMetadataMap = this.admHandler.getDataSourceMetadataMap();
        }
        if (this.admHandler == null || this.admHandler.getMappingDefinition() == null) {
            LOG.warn("AtlasMap context cannot initialize without mapping definition, ignoring: Mapping URI={}", (Object)this.atlasMappingUri);
            return;
        }
        this.sourceModules.clear();
        ConstantModule constant = new ConstantModule();
        constant.setConversionService(this.factory.getConversionService());
        constant.setFieldActionService(this.factory.getFieldActionService());
        this.sourceModules.put("ATLAS_CONSTANTS_DOC", constant);
        PropertyModule property = new PropertyModule(this.factory.getPropertyStrategy());
        property.setConversionService(this.factory.getConversionService());
        property.setFieldActionService(this.factory.getFieldActionService());
        property.setMode(AtlasModuleMode.SOURCE);
        this.sourceModules.put("ATLAS_SOURCE_PROPERTIES_DOC", property);
        this.targetModules.clear();
        property = new PropertyModule(this.factory.getPropertyStrategy());
        property.setConversionService(this.factory.getConversionService());
        property.setFieldActionService(this.factory.getFieldActionService());
        property.setMode(AtlasModuleMode.TARGET);
        this.targetModules.put("ATLAS_TARGET_PROPERTIES_DOC", property);
        this.lookupTables.clear();
        if (this.admHandler.getMappingDefinition().getLookupTables() != null && this.admHandler.getMappingDefinition().getLookupTables().getLookupTable() != null) {
            for (LookupTable table : this.admHandler.getMappingDefinition().getLookupTables().getLookupTable()) {
                this.lookupTables.put(table.getName(), table);
            }
        }
        AtlasModuleInfoRegistry moduleInfoRegistry = this.factory.getModuleInfoRegistry();
        for (DataSource ds : this.admHandler.getMappingDefinition().getDataSource()) {
            AtlasModuleInfo moduleInfo = moduleInfoRegistry.lookupByUri(ds.getUri());
            if (moduleInfo == null) {
                LOG.error("Cannot find module info for the DataSource uri '{}'", (Object)ds.getUri());
                continue;
            }
            if (ds.getDataSourceType() != DataSourceType.SOURCE && ds.getDataSourceType() != DataSourceType.TARGET) {
                LOG.error("Unsupported DataSource type '{}'", (Object)ds.getDataSourceType());
                continue;
            }
            String docId = ds.getId();
            if (docId == null || docId.isEmpty()) {
                String string = docId = ds.getDataSourceType() == DataSourceType.SOURCE ? "ATLAS_DEFAULT_SOURCE_DOC" : "ATLAS_DEFAULT_TARGET_DOC";
            }
            if (ds.getDataSourceType() == DataSourceType.SOURCE && this.sourceModules.containsKey(docId)) {
                LOG.error("Duplicated {} DataSource ID '{}' was detected, ignoring...", (Object)ds.getDataSourceType(), (Object)ds.getId());
                continue;
            }
            if (ds.getDataSourceType() == DataSourceType.TARGET && this.targetModules.containsKey(docId)) {
                LOG.error("Duplicated {} DataSource ID '{}' was detected, ignoring...", (Object)ds.getDataSourceType(), (Object)docId);
                continue;
            }
            try {
                DataSourceKey dskey;
                DataSourceMetadata meta;
                AtlasModule module = (AtlasModule)moduleInfo.getModuleClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                module.setClassLoader((ClassLoader)this.factory.getClassLoader());
                module.setConversionService((AtlasConversionService)this.factory.getConversionService());
                module.setFieldActionService((AtlasFieldActionService)this.factory.getFieldActionService());
                module.setUri(ds.getUri());
                if (ds.getDataSourceType() == DataSourceType.SOURCE) {
                    module.setMode(AtlasModuleMode.SOURCE);
                    this.getSourceModules().put(docId, module);
                } else if (ds.getDataSourceType() == DataSourceType.TARGET) {
                    module.setMode(AtlasModuleMode.TARGET);
                    this.getTargetModules().put(docId, module);
                }
                module.setDocId(docId);
                module.setDocName(ds.getName());
                if (this.dataSourceMetadataMap != null && (meta = this.dataSourceMetadataMap.get(dskey = new DataSourceKey(ds.getDataSourceType() == DataSourceType.SOURCE, docId))) != null) {
                    module.setDataSourceMetadata(meta);
                }
                module.init();
            }
            catch (Exception t) {
                LOG.error("Unable to initialize {} module: {}", (Object)ds.getDataSourceType(), (Object)moduleInfo);
                LOG.error(t.getMessage(), (Throwable)t);
                throw new AtlasException(String.format("Unable to initialize %s module: %s", ds.getDataSourceType(), moduleInfo.toString()), (Throwable)t);
            }
        }
        this.initialized = true;
    }

    protected void registerJmx(DefaultAtlasContext context) {
        try {
            this.setJmxObjectName(new ObjectName(this.getContextFactory().getJmxObjectName() + ",context=Contexts,uuid=" + this.uuid.toString()));
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(this.getJmxObjectName())) {
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.getJmxObjectName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registered AtlasContext {} with JMX", (Object)context.getUuid());
                }
            }
        }
        catch (Exception t) {
            LOG.warn("Failed to register AtlasContext {} with JMX", (Object)context.getUuid());
            LOG.warn(t.getMessage(), (Throwable)t);
        }
    }

    @Deprecated
    public Audits processPreview(Mapping mapping) throws AtlasException {
        return this.factory.createPreviewContext().processPreview(mapping);
    }

    protected Field applyFieldActions(DefaultAtlasSession session, Field field) {
        if (field.getActions() == null) {
            return field;
        }
        try {
            return this.factory.getFieldActionService().processActions(session, field);
        }
        catch (AtlasException e) {
            AtlasUtil.addAudit((AtlasInternalSession)session, field, String.format("Failed to apply field action: %s", AtlasUtil.getChainedMessage(e)), AuditStatus.ERROR, null);
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return field;
        }
    }

    public void process(AtlasSession userSession) throws AtlasException {
        if (!(userSession instanceof DefaultAtlasSession)) {
            throw new AtlasException(String.format("Unsupported session class '%s'", userSession.getClass().getName()));
        }
        if (!this.equals(userSession.getAtlasContext())) {
            throw new AtlasException("Cannot execute AtlasSession created by the other AtlasContext");
        }
        DefaultAtlasSession session = (DefaultAtlasSession)userSession;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin process {}", (Object)(session == null ? null : session.toString()));
        }
        session.head().unset();
        session.getAudits().getAudit().clear();
        session.getValidations().getValidation().clear();
        this.processValidation((AtlasSession)session);
        for (Validation v : session.getValidations().getValidation()) {
            AtlasUtil.addAudit((AtlasSession)session, v);
        }
        Mappings mappings = session.getMapping().getMappings();
        if (mappings != null && mappings.getMapping().isEmpty()) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (String)null, String.format("Field mappings should not be empty", new Object[0]), AuditStatus.WARN, null);
        }
        session.getValidations().getValidation().clear();
        if (session.hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Aborting due to {} errors in pre-validation", (Object)session.errorCount());
            }
            return;
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPreSourceExecution((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPreTargetExecution((AtlasInternalSession)session);
        }
        if (session.hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Aborting due to {} errors in pre-execution", (Object)session.errorCount());
            }
            return;
        }
        for (BaseMapping baseMapping : session.getMapping().getMappings().getMapping()) {
            for (BaseMapping innerMapping : this.unwrapCollectionMappings(session, baseMapping)) {
                if (innerMapping instanceof CustomMapping) {
                    DefaultAtlasCustomMappingProcessor.getInstance().process(session, (CustomMapping)innerMapping);
                    continue;
                }
                Mapping mapping = (Mapping)innerMapping;
                session.head().setMapping(mapping).setLookupTable(this.lookupTables.get(mapping.getLookupTableName()));
                if (mapping.getOutputField() == null || mapping.getOutputField().isEmpty()) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, (String)null, String.format("Mapping does not contain at least one target field: alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()), AuditStatus.WARN, null);
                    continue;
                }
                this.processSourceFieldMapping(session);
                if (!session.head().hasError()) {
                    this.processTargetFieldMapping(session, mapping);
                }
                session.getAudits().getAudit().addAll(session.head().getAudits());
                session.head().unset();
            }
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPostValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPostValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPostSourceExecution((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPostTargetExecution((AtlasInternalSession)session);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End process {}", (Object)(session == null ? null : session.toString()));
        }
    }

    private List<BaseMapping> unwrapCollectionMappings(DefaultAtlasSession session, BaseMapping baseMapping) {
        if (baseMapping.getMappingType() == null || !baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Mapping is not a collection mapping, not cloning: {}", (Object)baseMapping);
            }
            return Arrays.asList(baseMapping);
        }
        LinkedList<BaseMapping> mappings = new LinkedList<BaseMapping>();
        for (BaseMapping m : ((Collection)baseMapping).getMappings().getMapping()) {
            mappings.add(m);
        }
        return mappings;
    }

    protected void processSourceFieldMapping(DefaultAtlasSession session) {
        block10: {
            try {
                Mapping mapping = session.head().getMapping();
                if (mapping.getInputFieldGroup() != null) {
                    if (mapping.getExpression() != null) {
                        session.head().setSourceField((Field)mapping.getInputFieldGroup());
                        DefaultAtlasExpressionProcessor.processExpression(session, mapping.getExpression());
                    } else {
                        this.processSourceFieldGroup(session, mapping.getInputFieldGroup());
                    }
                } else if (mapping.getInputField() != null && !mapping.getInputField().isEmpty()) {
                    if (mapping.getExpression() != null) {
                        FieldGroup sourceFieldGroup = new FieldGroup();
                        sourceFieldGroup.getField().addAll(mapping.getInputField());
                        session.head().setSourceField((Field)sourceFieldGroup);
                        DefaultAtlasExpressionProcessor.processExpression(session, mapping.getExpression());
                    } else {
                        List sourceFields = mapping.getInputField();
                        this.applyCopyToActions(sourceFields, mapping);
                        this.processSourceFields(session, sourceFields);
                    }
                } else {
                    session.head().addAudit(AuditStatus.WARN, null, String.format("Mapping does not contain expression or at least one source field: alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()));
                }
            }
            catch (Exception t) {
                Field sourceField = session.head().getSourceField();
                String docId = sourceField != null ? sourceField.getDocId() : null;
                String path = sourceField != null ? sourceField.getPath() : null;
                session.head().addAudit(AuditStatus.ERROR, sourceField, String.format("Unexpected exception is thrown while reading source field: %s", t.getMessage()));
                if (!LOG.isDebugEnabled()) break block10;
                LOG.error("", (Throwable)t);
            }
        }
    }

    private void processSourceFieldGroup(DefaultAtlasSession session, FieldGroup sourceFieldGroup) throws AtlasException {
        this.processSourceFields(session, sourceFieldGroup.getField());
        session.head().setSourceField((Field)sourceFieldGroup);
        Field processed = this.applyFieldActions(session, session.head().getSourceField());
        session.head().setSourceField(processed);
    }

    private void processSourceFields(DefaultAtlasSession session, List<Field> sourceFields) throws AtlasException {
        for (int i = 0; i < sourceFields.size(); ++i) {
            Field sourceField = sourceFields.get(i);
            session.head().setSourceField(sourceField);
            if (sourceField instanceof FieldGroup) {
                this.processSourceFields(session, ((FieldGroup)sourceField).getField());
                Field processed = this.applyFieldActions(session, sourceField);
                session.head().setSourceField(processed);
                continue;
            }
            AtlasModule module = this.resolveModule(FieldDirection.SOURCE, sourceField);
            if (module == null) {
                AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("Module not found for docId '%s'", sourceField.getDocId()), AuditStatus.ERROR, null);
                return;
            }
            if (!module.isSupportedField(sourceField).booleanValue()) {
                AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("Unsupported source field type '%s' for DataSource '%s'", sourceField.getClass().getName(), module.getUri()), AuditStatus.ERROR, null);
                return;
            }
            module.readSourceValue((AtlasInternalSession)session);
            Field processed = this.applyFieldActions(session, session.head().getSourceField());
            session.head().setSourceField(processed);
            sourceFields.set(i, processed);
        }
    }

    protected AtlasModule resolveModule(FieldDirection direction, Field field) {
        Map<String, AtlasModule> modules;
        String docId = field.getDocId();
        if (docId == null || docId.isEmpty()) {
            docId = direction == FieldDirection.SOURCE ? "ATLAS_DEFAULT_SOURCE_DOC" : "ATLAS_DEFAULT_TARGET_DOC";
        }
        Map<String, AtlasModule> map = modules = direction == FieldDirection.SOURCE ? this.sourceModules : this.targetModules;
        if (direction == FieldDirection.SOURCE && field instanceof ConstantField) {
            AtlasModule answer = this.sourceModules.get("ATLAS_CONSTANTS_DOC");
            if (!modules.containsKey(docId)) {
                modules.put(docId, answer);
            }
            return answer;
        }
        if (field instanceof PropertyField) {
            AtlasModule answer = modules.get(direction == FieldDirection.SOURCE ? "ATLAS_SOURCE_PROPERTIES_DOC" : "ATLAS_TARGET_PROPERTIES_DOC");
            if (!modules.containsKey(docId)) {
                modules.put(docId, answer);
            }
            return answer;
        }
        return modules.get(docId);
    }

    private void applyCopyToActions(List<Field> sourceFields, Mapping mapping) {
        for (Field sourceField : sourceFields) {
            if (sourceField instanceof FieldGroup) {
                this.applyCopyToActions(((FieldGroup)sourceField).getField(), mapping);
                continue;
            }
            if (sourceField.getActions() == null) continue;
            List copyTos = sourceField.getActions().stream().filter(a -> a instanceof CopyTo).map(a -> (CopyTo)a).collect(Collectors.toList());
            if (copyTos.size() == 0) {
                return;
            }
            if (copyTos.stream().flatMap(c -> c.getIndexes().stream().filter(i -> i < 0)).count() > 0L) {
                throw new IllegalArgumentException("Indexes must be >= 0");
            }
            for (CopyTo copyTo : copyTos) {
                for (Field field : mapping.getOutputField()) {
                    AtlasPath path = new AtlasPath(field.getPath());
                    List<AtlasPath.SegmentContext> segments = path.getCollectionSegments(true);
                    for (int i = 0; i < copyTo.getIndexes().size(); ++i) {
                        if (i >= segments.size()) continue;
                        path.setCollectionIndex(i + 1, (Integer)copyTo.getIndexes().get(i));
                    }
                    field.setPath(path.toString());
                }
                sourceField.getActions().remove(copyTo);
            }
        }
    }

    private void processTargetFieldMapping(DefaultAtlasSession session, Mapping mapping) {
        MappingType mappingType = mapping.getMappingType();
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        AtlasModule module = null;
        Field targetField = null;
        if (mappingType == null || mappingType == MappingType.LOOKUP || mappingType == MappingType.MAP) {
            Field sourceField = session.head().getSourceField();
            FieldGroup sourceFieldGroup = null;
            if (sourceField instanceof FieldGroup) {
                sourceFieldGroup = this.unwrapNestedGroup((FieldGroup)sourceField);
            }
            for (Field f : targetFields) {
                targetField = f;
                module = this.resolveModule(FieldDirection.TARGET, targetField);
                if (!this.auditTargetFieldType(session, module, targetField)) continue;
                session.head().setTargetField(targetField);
                if (sourceFieldGroup != null) {
                    Integer index = targetField.getIndex();
                    AtlasPath targetPath = new AtlasPath(targetField.getPath());
                    if (targetPath.hasCollection() && !targetPath.isIndexedCollection()) {
                        if (targetFields.size() > 1) {
                            AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "It's not yet supported to have a collection field as a part of multiple target fields in a same mapping", AuditStatus.ERROR, null);
                            return;
                        }
                        session.head().setSourceField((Field)sourceFieldGroup);
                    } else if (index == null) {
                        if (sourceFieldGroup.getField().size() > 0) {
                            session.head().setSourceField((Field)sourceFieldGroup.getField().get(sourceFieldGroup.getField().size() - 1));
                        }
                    } else if (sourceFieldGroup.getField().size() > index) {
                        session.head().setSourceField((Field)sourceFieldGroup.getField().get(index));
                    } else {
                        AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("The number of source fields '%s' is fewer than expected via target field index '%s'", sourceFieldGroup.getField().size(), targetField.getIndex()), AuditStatus.WARN, null);
                        continue;
                    }
                }
                try {
                    module.populateTargetField((AtlasInternalSession)session);
                }
                catch (Exception e) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to populate target field: " + e.getMessage(), AuditStatus.ERROR, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.error(String.format("populateTargetField() failed for %s:%s", targetField.getDocId(), targetField.getPath()), (Throwable)e);
                    }
                    return;
                }
                Field processed = this.applyFieldActions(session, session.head().getTargetField());
                session.head().setTargetField(processed);
                try {
                    module.writeTargetValue((AtlasInternalSession)session);
                }
                catch (Exception e) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to write field value into target document: " + e.getMessage(), AuditStatus.ERROR, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.error(String.format("writeTargetValue() failed for %s:%s", targetField.getDocId(), targetField.getPath()), (Throwable)e);
                    }
                    return;
                }
            }
            return;
        }
        if (mappingType == MappingType.COMBINE) {
            targetField = (Field)targetFields.get(0);
            module = this.resolveModule(FieldDirection.TARGET, targetField);
            if (!this.auditTargetFieldType(session, module, targetField)) {
                return;
            }
            Field sourceField = this.processCombineField(session, mapping, sourceFields, targetField);
            session.head().setSourceField(sourceField).setTargetField(targetField);
            try {
                module.populateTargetField((AtlasInternalSession)session);
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to populate target field: " + e.getMessage(), AuditStatus.ERROR, null);
                return;
            }
            this.applyFieldActions(session, session.head().getTargetField());
            try {
                module.writeTargetValue((AtlasInternalSession)session);
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to write field value into target document: " + e.getMessage(), AuditStatus.ERROR, null);
                return;
            }
            return;
        }
        if (mappingType == MappingType.SEPARATE) {
            List<Field> separatedFields = null;
            try {
                separatedFields = this.processSeparateField(session, mapping, (Field)sourceFields.get(0));
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to process separate mode: " + e.getMessage(), AuditStatus.ERROR, null);
                return;
            }
            if (separatedFields == null) {
                return;
            }
            for (Field f : targetFields) {
                targetField = f;
                module = this.resolveModule(FieldDirection.TARGET, targetField);
                if (!this.auditTargetFieldType(session, module, targetField)) continue;
                if (targetField.getIndex() == null || targetField.getIndex() < 0) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Separate requires zero or positive Index value to be set on targetField targetField.path=%s", targetField.getPath()), AuditStatus.WARN, null);
                    continue;
                }
                if (separatedFields.size() <= targetField.getIndex()) {
                    String errorMessage = String.format("Separate returned fewer segments count=%s when targetField.path=%s requested index=%s", separatedFields.size(), targetField.getPath(), targetField.getIndex());
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, errorMessage, AuditStatus.WARN, null);
                    break;
                }
                session.head().setSourceField(separatedFields.get(targetField.getIndex())).setTargetField(targetField);
                try {
                    module.populateTargetField((AtlasInternalSession)session);
                }
                catch (Exception e) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to populate target field: " + e.getMessage(), AuditStatus.ERROR, null);
                    return;
                }
                Field processed = this.applyFieldActions(session, session.head().getTargetField());
                session.head().setTargetField(processed);
                try {
                    module.writeTargetValue((AtlasInternalSession)session);
                }
                catch (Exception e) {
                    AtlasUtil.addAudit((AtlasInternalSession)session, targetField, "Failed to write field value into target document: " + e.getMessage(), AuditStatus.ERROR, null);
                    return;
                }
            }
            return;
        }
        AtlasUtil.addAudit((AtlasInternalSession)session, (String)null, String.format("Unsupported mappingType=%s detected", mapping.getMappingType()), AuditStatus.ERROR, null);
    }

    private FieldGroup unwrapNestedGroup(FieldGroup parent) {
        if (parent.getPath() == null && parent.getField().size() == 1 && parent.getField().get(0) instanceof FieldGroup) {
            return (FieldGroup)parent.getField().get(0);
        }
        return parent;
    }

    private boolean auditTargetFieldType(DefaultAtlasSession session, AtlasModule module, Field field) {
        if (module == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, field, String.format("Module not found for field type='%s', path='%s'", field.getFieldType(), field.getPath()), AuditStatus.ERROR, null);
            return false;
        }
        if (!module.isSupportedField(field).booleanValue()) {
            AtlasUtil.addAudit((AtlasInternalSession)session, field, String.format("Unsupported target field type '%s' for DataSource '%s'", field.getClass().getName(), module.getUri()), AuditStatus.ERROR, null);
            return false;
        }
        return true;
    }

    protected Field processCombineField(DefaultAtlasSession session, Mapping mapping, List<Field> sourceFields, Field targetField) {
        HashMap<Integer, String> combineValues = null;
        for (Field sourceField : sourceFields) {
            String sourceValue;
            if (sourceField.getIndex() == null || sourceField.getIndex() < 0) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Combine requires zero or positive Index value to be set on all sourceFields sourceField.path=%s", sourceField.getPath()), AuditStatus.WARN, null);
                continue;
            }
            if (combineValues == null) {
                combineValues = new HashMap<Integer, String>();
            }
            if (sourceField.getValue() == null) continue;
            try {
                sourceValue = (String)this.factory.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), FieldType.STRING, null);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, targetField, String.format("Suitable converter for sourceField.path=%s hasn't been found", sourceField.getPath()), AuditStatus.WARN, null);
                sourceValue = sourceField.getValue() != null ? sourceField.getValue().toString() : null;
            }
            combineValues.put(sourceField.getIndex(), sourceValue);
        }
        String combinedValue = null;
        StringDelimiter delimiter = StringDelimiter.fromName((String)mapping.getDelimiter());
        combinedValue = delimiter != null ? this.factory.getCombineStrategy().combineValues(combineValues, delimiter) : (mapping.getDelimiterString() != null && !mapping.getDelimiterString().isEmpty() ? this.factory.getCombineStrategy().combineValues(combineValues, mapping.getDelimiterString()) : this.factory.getCombineStrategy().combineValues(combineValues));
        SimpleField answer = AtlasModelFactory.cloneFieldToSimpleField((Field)sourceFields.get(0));
        if (combinedValue == null || combinedValue.trim().isEmpty()) {
            LOG.debug("Empty combined string for Combine mapping targetField.path={}", (Object)targetField.getPath());
        } else {
            answer.setValue((Object)combinedValue);
        }
        return answer;
    }

    protected List<Field> processSeparateField(DefaultAtlasSession session, Mapping mapping, Field sourceField) throws AtlasException {
        String sourceValue;
        if (sourceField.getValue() == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("null value can't be separated for sourceField.path=%s", sourceField.getPath()), AuditStatus.WARN, null);
            return null;
        }
        if (!sourceField.getValue().getClass().isAssignableFrom(String.class)) {
            Object converted = this.factory.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), FieldType.STRING, null);
            sourceField.setValue(converted);
        }
        ArrayList<Field> answer = new ArrayList<Field>();
        try {
            sourceValue = (String)this.factory.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), FieldType.STRING, null);
        }
        catch (AtlasConversionException e) {
            AtlasUtil.addAudit((AtlasInternalSession)session, sourceField, String.format("Suitable converter for sourceField.path=%s hasn't been found", sourceField.getPath()), AuditStatus.WARN, null);
            sourceValue = sourceField.getValue().toString();
        }
        List separatedValues = null;
        StringDelimiter delimiter = StringDelimiter.fromName((String)mapping.getDelimiter());
        separatedValues = delimiter != null ? this.factory.getSeparateStrategy().separateValue(sourceValue, delimiter) : this.factory.getSeparateStrategy().separateValue(sourceValue);
        if (separatedValues == null || separatedValues.isEmpty()) {
            LOG.debug("Empty string for Separate mapping sourceField.path={}", (Object)sourceField.getPath());
        } else {
            for (String separatedValue : separatedValues) {
                SimpleField simpleField = AtlasModelFactory.cloneFieldToSimpleField((Field)sourceField);
                simpleField.setValue((Object)separatedValue);
                simpleField.setFieldType(FieldType.STRING);
                answer.add((Field)simpleField);
            }
        }
        return answer;
    }

    public void processValidation(AtlasSession userSession) throws AtlasException {
        List validations;
        if (!(userSession instanceof DefaultAtlasSession)) {
            throw new AtlasException(String.format("Unsupported session class '%s'", userSession.getClass().getName()));
        }
        if (!this.equals(userSession.getAtlasContext())) {
            throw new AtlasException("Cannot execute AtlasSession created by the other AtlasContext");
        }
        DefaultAtlasSession session = (DefaultAtlasSession)userSession;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin processValidation {}", (Object)session);
        }
        if ((validations = this.getContextFactory().getValidationService().validateMapping(session.getMapping())) != null && !validations.isEmpty()) {
            session.getValidations().getValidation().addAll(validations);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected {} core validation notices", (Object)(validations == null ? 0 : validations.size()));
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPreValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPreValidation((AtlasInternalSession)session);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End processValidation {}", (Object)session);
        }
    }

    public DefaultAtlasContextFactory getContextFactory() {
        return this.factory;
    }

    public AtlasMapping getMapping() {
        return this.admHandler != null ? this.admHandler.getMappingDefinition() : null;
    }

    public AtlasSession createSession() throws AtlasException {
        this.init();
        return this.doCreateSession();
    }

    public AtlasSession createSession(AtlasMapping mappingDefinition) throws AtlasException {
        this.atlasMappingUri = null;
        this.admHandler = new ADMArchiveHandler(this.factory.getClassLoader());
        this.admHandler.setIgnoreLibrary(true);
        this.admHandler.setMappingDefinition(mappingDefinition);
        this.initialized = false;
        this.init();
        return this.doCreateSession();
    }

    private AtlasSession doCreateSession() throws AtlasException {
        DefaultAtlasSession session = new DefaultAtlasSession(this);
        session.setAtlasContext(this);
        session.setAudits(new Audits());
        session.setValidations(new Validations());
        this.setDefaultSessionProperties((AtlasSession)session);
        return session;
    }

    protected void setDefaultSessionProperties(AtlasSession session) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getDefault());
        session.getProperties().put("Atlas.CreatedDateTimeTZ", df.format(date));
    }

    public Map<String, AtlasModule> getSourceModules() {
        return this.sourceModules;
    }

    public void setSourceModules(Map<String, AtlasModule> sourceModules) {
        this.sourceModules = sourceModules;
    }

    public Map<String, AtlasModule> getTargetModules() {
        return this.targetModules;
    }

    public void setTargetModules(Map<String, AtlasModule> targetModules) {
        this.targetModules = targetModules;
    }

    public Map<String, LookupTable> getLookupTables() {
        return this.lookupTables;
    }

    public void setLookupTables(Map<String, LookupTable> lookupTables) {
        this.lookupTables = lookupTables;
    }

    protected void setJmxObjectName(ObjectName jmxObjectName) {
        this.jmxObjectName = jmxObjectName;
    }

    public ObjectName getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getUuid() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getMappingName() {
        return this.admHandler.getMappingDefinition() != null ? this.admHandler.getMappingDefinition().getName() : null;
    }

    protected void setMappingUri(URI atlasMappingUri) {
        this.atlasMappingUri = atlasMappingUri;
    }

    public String getMappingUri() {
        return this.atlasMappingUri != null ? this.atlasMappingUri.toString() : null;
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    public String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        return "DefaultAtlasContext [jmxObjectName=" + this.jmxObjectName + ", uuid=" + this.uuid + ", factory=" + this.factory + ", mappingName=" + this.getMappingName() + ", mappingUri=" + this.getMappingUri() + ", sourceModules=" + this.sourceModules + ", targetModules=" + this.targetModules + "]";
    }

    public ADMArchiveHandler getADMArchiveHandler() {
        return this.admHandler;
    }
}

