/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasPath
implements Cloneable {
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PATH_SEPARATOR_ESCAPED = "/";
    public static final String PATH_ARRAY_START = "[";
    public static final String PATH_ARRAY_END = "]";
    public static final String PATH_ARRAY_SUFFIX = "[]";
    public static final String PATH_LIST_START = "<";
    public static final String PATH_LIST_END = ">";
    public static final String PATH_LIST_SUFFIX = "<>";
    public static final String PATH_MAP_START = "{";
    public static final String PATH_MAP_END = "}";
    public static final String PATH_MAP_SUFFIX = "{}";
    public static final String PATH_ATTRIBUTE_PREFIX = "@";
    public static final String PATH_NAMESPACE_SEPARATOR = ":";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPath.class);
    protected List<SegmentContext> segmentContexts;
    private String originalPath = null;

    public AtlasPath(String p) {
        String path;
        this.originalPath = path = p;
        this.segmentContexts = this.parse(path);
    }

    protected AtlasPath(List<SegmentContext> segments) {
        this.segmentContexts = segments;
        this.originalPath = this.getSegmentPath(segments.get(segments.size() - 1));
    }

    private AtlasPath() {
        this.segmentContexts = new ArrayList<SegmentContext>();
    }

    public static Field extractChildren(Field f, String path) {
        if (f == null || path == null || path.isEmpty()) {
            return null;
        }
        if (path.equals("/")) {
            return f;
        }
        if (!(f instanceof FieldGroup)) {
            return null;
        }
        ArrayList<FieldGroup> extracted = new ArrayList<FieldGroup>();
        FieldGroup entryField = (FieldGroup)f;
        extracted.add(entryField);
        List<SegmentContext> entrySegments = new AtlasPath(entryField.getPath()).getSegments(true);
        SegmentContext entrySegment = entrySegments.get(entrySegments.size() - 1);
        ArrayList<SegmentContext> extractedSegments = new ArrayList<SegmentContext>(entrySegments);
        List<SegmentContext> relativeSegments = new AtlasPath(path).getSegments(true);
        SegmentContext relativeRootSegment = relativeSegments.get(0);
        ArrayList<Object> selected = new ArrayList<Object>();
        if (relativeRootSegment.getCollectionType() == null || relativeRootSegment.getCollectionType() == CollectionType.NONE) {
            if (entrySegment.getCollectionType() != null && entrySegment.getCollectionType() != CollectionType.NONE && entrySegment.getCollectionIndex() == null) {
                selected.addAll(entryField.getField());
            } else {
                selected.add(entryField);
            }
        } else if (relativeRootSegment.getCollectionIndex() != null) {
            if (entrySegment.getCollectionIndex() != null) {
                if (entrySegment.getCollectionIndex() == relativeRootSegment.getCollectionIndex()) {
                    selected.add(entryField);
                }
            } else {
                selected.add((Field)entryField.getField().get(relativeRootSegment.getCollectionIndex()));
                entrySegment.collectionIndex = relativeRootSegment.getCollectionIndex();
                extractedSegments.set(entrySegments.size() - 1, entrySegment.rebuild());
            }
        } else {
            selected.addAll(entryField.getField());
        }
        extracted = selected;
        for (int i = 1; i < relativeSegments.size(); ++i) {
            SegmentContext segment = relativeSegments.get(i);
            extractedSegments.add(segment);
            selected = new ArrayList();
            block1: for (Field field : extracted) {
                FieldGroup f1Group = (FieldGroup)field;
                for (Field f2 : f1Group.getField()) {
                    AtlasPath f2Path = new AtlasPath(f2.getPath());
                    if (!segment.getName().equals(f2Path.getLastSegment().getName())) continue;
                    if (segment.getCollectionType() == CollectionType.NONE) {
                        selected.add(f2);
                        continue block1;
                    }
                    FieldGroup f2Group = (FieldGroup)f2;
                    if (segment.getCollectionIndex() != null) {
                        selected.add((Field)f2Group.getField().get(segment.getCollectionIndex()));
                        continue block1;
                    }
                    selected.addAll(f2Group.getField());
                    continue block1;
                }
            }
            extracted = selected;
        }
        if (extracted.size() == 1) {
            return (Field)extracted.get(0);
        }
        FieldGroup answer = AtlasModelFactory.createFieldGroupFrom((Field)f, (boolean)true);
        answer.setPath(new AtlasPath(extractedSegments).toString());
        answer.getField().addAll(extracted);
        return answer;
    }

    public static void setCollectionIndexRecursively(FieldGroup group, int segmentIndex, int index) {
        AtlasPath path = new AtlasPath(group.getPath());
        path.setCollectionIndex(segmentIndex, index);
        group.setPath(path.toString());
        for (Field f : group.getField()) {
            if (f instanceof FieldGroup) {
                AtlasPath.setCollectionIndexRecursively((FieldGroup)f, segmentIndex, index);
                continue;
            }
            AtlasPath fpath = new AtlasPath(f.getPath());
            fpath.setCollectionIndex(segmentIndex, index);
            f.setPath(fpath.toString());
        }
    }

    public AtlasPath appendField(String fieldExpression) {
        this.segmentContexts.add(this.createSegmentContext(fieldExpression));
        return this;
    }

    public AtlasPath clone() {
        return new AtlasPath(this.toString());
    }

    public List<SegmentContext> getSegments(boolean includeRoot) {
        if (includeRoot) {
            return Collections.unmodifiableList(this.segmentContexts);
        }
        if (this.segmentContexts.size() > 1) {
            return Collections.unmodifiableList(this.segmentContexts.subList(1, this.segmentContexts.size()));
        }
        return Collections.emptyList();
    }

    public Boolean isRoot() {
        return this.segmentContexts.size() == 1 && this.segmentContexts.get(0).isRoot();
    }

    public SegmentContext getRootSegment() {
        return this.segmentContexts.get(0);
    }

    public Boolean isCollectionRoot() {
        return this.segmentContexts.size() == 1 && this.segmentContexts.get(0).getCollectionType() != CollectionType.NONE;
    }

    public Boolean hasCollectionRoot() {
        return this.segmentContexts.get(0).getCollectionType() != CollectionType.NONE;
    }

    public SegmentContext getLastSegment() {
        return this.segmentContexts.get(this.segmentContexts.size() - 1);
    }

    public SegmentContext getLastCollectionSegment() {
        List<SegmentContext> collectionSegments = this.getCollectionSegments(true);
        return collectionSegments.get(collectionSegments.size() - 1);
    }

    public SegmentContext getLastSegmentParent() {
        if (this.segmentContexts.isEmpty() || this.segmentContexts.size() == 1) {
            return null;
        }
        return this.segmentContexts.get(this.segmentContexts.size() - 2);
    }

    public AtlasPath getLastSegmentParentPath() {
        if (this.segmentContexts.isEmpty() || this.segmentContexts.size() == 1) {
            return null;
        }
        AtlasPath parentPath = new AtlasPath();
        for (int i = 0; i < this.segmentContexts.size() - 1; ++i) {
            parentPath.appendField(this.segmentContexts.get(i).getExpression());
        }
        return parentPath;
    }

    public SegmentContext getParentSegmentOf(SegmentContext sc) {
        for (int i = 0; i < this.segmentContexts.size(); ++i) {
            if (this.segmentContexts.get(i) != sc) continue;
            if (sc.isRoot()) {
                return null;
            }
            return this.segmentContexts.get(i - 1);
        }
        return null;
    }

    public boolean hasCollection() {
        for (SegmentContext sc : this.segmentContexts) {
            if (sc.getCollectionType() == CollectionType.NONE) continue;
            return true;
        }
        return false;
    }

    public boolean isIndexedCollection() {
        boolean hasIndexedCollection = false;
        for (SegmentContext sc : this.segmentContexts) {
            if (sc.getCollectionType() == CollectionType.NONE || sc.getCollectionIndex() == null) continue;
            hasIndexedCollection = true;
        }
        return hasIndexedCollection;
    }

    public SegmentContext setCollectionIndex(int segmentIndex, Integer collectionIndex) {
        if (collectionIndex != null && collectionIndex < 0) {
            throw new IllegalArgumentException(String.format("Cannnot set negative collection index %s for the path %s", collectionIndex, this.toString()));
        }
        SegmentContext sc = this.segmentContexts.get(segmentIndex);
        sc.collectionIndex = collectionIndex;
        return this.segmentContexts.set(segmentIndex, sc.rebuild());
    }

    public List<SegmentContext> getCollectionSegments(boolean includeRoot) {
        List<SegmentContext> segments = this.getSegments(includeRoot);
        ArrayList<SegmentContext> collectionSegments = new ArrayList<SegmentContext>();
        for (SegmentContext segment : segments) {
            if (segment.getCollectionType() == CollectionType.NONE) continue;
            collectionSegments.add(segment);
        }
        return collectionSegments;
    }

    public SegmentContext setVacantCollectionIndex(Integer collectionIndex) {
        for (int i = 0; i < this.segmentContexts.size(); ++i) {
            SegmentContext sc = this.segmentContexts.get(i);
            if (sc.getCollectionType() == CollectionType.NONE || sc.getCollectionIndex() != null) continue;
            return this.setCollectionIndex(i, collectionIndex);
        }
        throw new IllegalArgumentException("No Vacant index on collection segments in the path " + this.toString());
    }

    public String getSegmentPath(SegmentContext sc) {
        int toIndex = this.segmentContexts.indexOf(sc);
        if (toIndex == -1) {
            return null;
        }
        StringBuilder builder = new StringBuilder().append('/');
        if (!this.segmentContexts.get(0).getExpression().isEmpty()) {
            builder.append(this.segmentContexts.get(0).getExpression());
        }
        for (int i = 1; i <= toIndex; ++i) {
            if (builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(this.segmentContexts.get(i).getExpression());
        }
        return builder.toString();
    }

    public String toString() {
        return this.getSegmentPath(this.getLastSegment());
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public int getCollectionSegmentCount() {
        int answer = 0;
        for (SegmentContext sc : this.getSegments(true)) {
            if (sc.collectionType == null || sc.collectionType == CollectionType.NONE) continue;
            ++answer;
        }
        return answer;
    }

    protected List<SegmentContext> parse(String path) {
        path = this.sanitize(path);
        ArrayList<SegmentContext> segmentContexts = new ArrayList<SegmentContext>();
        if (path != null && !"".equals(path)) {
            if (path.startsWith("/")) {
                path = path.replaceFirst("/", "");
            }
            if (path.contains("/")) {
                String[] parts;
                for (String part : parts = path.split("/", 512)) {
                    segmentContexts.add(this.createSegmentContext(part));
                }
            } else {
                segmentContexts.add(this.createSegmentContext(path));
            }
        }
        if (segmentContexts.isEmpty() || !((SegmentContext)segmentContexts.get(0)).isRoot()) {
            segmentContexts.add(0, this.createSegmentContext(""));
        }
        return segmentContexts;
    }

    protected String sanitize(String path) {
        String answer = path;
        if (answer == null || answer.isEmpty()) {
            return answer;
        }
        if (answer.indexOf("//") != -1) {
            LOG.warn("Sanitizing double slash (//) in the path '{}'", (Object)answer);
            answer = answer.replaceAll("//", "/");
        }
        if (answer.endsWith("/")) {
            LOG.warn("Sanitizing trailing slash (/) in the path '{}'", (Object)answer);
            answer = answer.substring(0, answer.length() - 1);
        }
        return answer;
    }

    protected SegmentContext createSegmentContext(String expression) {
        return new SegmentContext(expression);
    }

    public static class SegmentContext {
        private String name;
        private String expression;
        private CollectionType collectionType;
        private Integer collectionIndex;
        private String mapKey;
        private boolean isAttribute;
        private boolean isRoot;

        public SegmentContext(String expression) {
            this.expression = expression;
            if (this.expression.startsWith("/")) {
                this.expression = this.expression.replaceFirst("/", "");
            }
            this.name = this.cleanPathSegment(expression);
            this.collectionType = expression.contains(AtlasPath.PATH_MAP_START) ? CollectionType.MAP : (expression.contains(AtlasPath.PATH_ARRAY_START) ? CollectionType.ARRAY : (expression.contains(AtlasPath.PATH_LIST_START) ? CollectionType.LIST : CollectionType.NONE));
            if (this.collectionType == CollectionType.MAP) {
                this.mapKey = this.getMapKey(expression);
            } else {
                this.collectionIndex = this.getCollectionIndex(expression);
            }
            this.isAttribute = expression.startsWith(AtlasPath.PATH_ATTRIBUTE_PREFIX);
            this.isRoot = this.name.isEmpty();
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        public CollectionType getCollectionType() {
            return this.collectionType;
        }

        public Integer getCollectionIndex() {
            return this.collectionIndex;
        }

        public String getMapKey() {
            return this.mapKey;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        protected SegmentContext rebuild() {
            String index;
            StringBuilder buf = new StringBuilder();
            if (this.isAttribute) {
                buf.append(AtlasPath.PATH_ATTRIBUTE_PREFIX);
            }
            buf.append(this.name);
            String string = index = this.collectionIndex != null ? this.collectionIndex.toString() : "";
            if (this.collectionType == CollectionType.ARRAY) {
                buf.append(AtlasPath.PATH_ARRAY_START).append(index).append(AtlasPath.PATH_ARRAY_END);
            } else if (this.collectionType == CollectionType.LIST) {
                buf.append(AtlasPath.PATH_LIST_START).append(index).append(AtlasPath.PATH_LIST_END);
            } else if (this.collectionType == CollectionType.MAP) {
                buf.append(AtlasPath.PATH_LIST_START).append(this.mapKey).append(AtlasPath.PATH_LIST_END);
            }
            return new SegmentContext(buf.toString());
        }

        public String toString() {
            return this.collectionType == CollectionType.MAP ? String.format("SegmentContext [name=%s, expression=%s, collectionType=%s, mapKey=%s]", this.name, this.expression, this.collectionType, this.mapKey) : String.format("SegmentContext [name=%s, expression=%s, collectionType=%s, collectionIndex=%s]", this.name, this.expression, this.collectionType, this.collectionIndex);
        }

        protected String cleanPathSegment(String expression) {
            String answer = expression;
            if (answer == null) {
                return null;
            }
            if (answer.contains(AtlasPath.PATH_NAMESPACE_SEPARATOR)) {
                answer = answer.substring(answer.indexOf(AtlasPath.PATH_NAMESPACE_SEPARATOR) + 1);
            }
            if (answer.contains(AtlasPath.PATH_ARRAY_START) && answer.endsWith(AtlasPath.PATH_ARRAY_END)) {
                return answer.substring(0, answer.indexOf(AtlasPath.PATH_ARRAY_START, 0));
            }
            if (answer.contains(AtlasPath.PATH_LIST_START) && answer.endsWith(AtlasPath.PATH_LIST_END)) {
                return answer.substring(0, answer.indexOf(AtlasPath.PATH_LIST_START, 0));
            }
            if (answer.contains(AtlasPath.PATH_MAP_START) && answer.endsWith(AtlasPath.PATH_MAP_END)) {
                return answer.substring(0, answer.indexOf(AtlasPath.PATH_MAP_START, 0));
            }
            return answer;
        }

        private Integer getCollectionIndex(String expression) {
            if (expression == null) {
                return null;
            }
            if (expression.contains(AtlasPath.PATH_ARRAY_START) && expression.endsWith(AtlasPath.PATH_ARRAY_END)) {
                int start = expression.indexOf(AtlasPath.PATH_ARRAY_START, 0) + 1;
                String index = expression.substring(start, expression.indexOf(AtlasPath.PATH_ARRAY_END, start));
                if (index != null && index.length() > 0) {
                    return Integer.valueOf(index);
                }
                return null;
            }
            if (expression.contains(AtlasPath.PATH_LIST_START) && expression.endsWith(AtlasPath.PATH_LIST_END)) {
                int start = expression.indexOf(AtlasPath.PATH_LIST_START, 0) + 1;
                String index = expression.substring(start, expression.indexOf(AtlasPath.PATH_LIST_END, start));
                if (index != null && index.length() > 0) {
                    return Integer.valueOf(index);
                }
                return null;
            }
            return null;
        }

        private String getMapKey(String expression) {
            int start = expression.indexOf(AtlasPath.PATH_MAP_START, 0) + 1;
            String key = expression.substring(start, expression.indexOf(AtlasPath.PATH_MAP_END, start));
            if (key != null && key.length() > 0) {
                return key;
            }
            return null;
        }
    }
}

