/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.CompoundClassLoader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAtlasCompoundClassLoader
extends CompoundClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundClassLoader.class);
    private Set<ClassLoader> delegates = new LinkedHashSet<ClassLoader>();

    DefaultAtlasCompoundClassLoader() {
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.classLoaders()) {
            try {
                return cl.loadClass(name);
            }
            catch (Throwable t) {
                LOG.debug("Class '{}' was not found with ClassLoader '{}': {}", (Object)name, (Object)cl);
                LOG.debug(t.getMessage(), t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Set<ClassLoader> classLoaders() {
        LinkedHashSet<ClassLoader> answer = new LinkedHashSet<ClassLoader>(this.delegates);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null && !tccl.equals(this)) {
            answer.add(tccl);
        }
        return answer;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader cl : this.classLoaders()) {
            URL url = cl.getResource(name);
            if (url != null) {
                return url;
            }
            LOG.debug("Resource '{}' was not found with ClassLoader '{}': {}", (Object)name, (Object)cl);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        LinkedHashSet<URL> answer = new LinkedHashSet<URL>();
        for (ClassLoader cl : this.classLoaders()) {
            try {
                Enumeration<URL> urls = cl.getResources(name);
                while (urls != null && urls.hasMoreElements()) {
                    answer.add(urls.nextElement());
                }
            }
            catch (Exception e) {
                LOG.debug("I/O error while looking for a resource '{}' with ClassLoader '{}': {}", (Object)name, (Object)cl);
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.enumeration(answer);
    }

    @Override
    public synchronized void addAlternativeLoader(ClassLoader cl) {
        if (cl != null && !this.equals(cl)) {
            this.delegates.add(cl);
        }
    }
}

