/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.ActionProcessor;
import io.atlasmap.spi.AtlasActionProcessor;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.ActionParameters;
import io.atlasmap.v2.ActionResolver;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.CustomAction;
import io.atlasmap.v2.Expression;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Multiplicity;
import io.atlasmap.v2.SimpleField;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasFieldActionService
implements AtlasFieldActionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasFieldActionService.class);
    private static DefaultAtlasFieldActionService instance;
    private static Set<String> listClasses;
    private static Set<String> mapClasses;
    private List<ActionProcessor> actionProcessors = new ArrayList<ActionProcessor>();
    private ReadWriteLock actionProcessorsLock = new ReentrantReadWriteLock();
    private AtlasConversionService conversionService = null;
    private ActionResolver actionResolver = null;

    private DefaultAtlasFieldActionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultAtlasFieldActionService getInstance() {
        if (instance != null) return instance;
        Class<DefaultAtlasFieldActionService> clazz = DefaultAtlasFieldActionService.class;
        synchronized (DefaultAtlasFieldActionService.class) {
            if (instance != null) return instance;
            instance = new DefaultAtlasFieldActionService(DefaultAtlasConversionService.getInstance());
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        this.init(this.getClass().getClassLoader());
    }

    private JavaType javaType(Type type) {
        return TypeFactory.defaultInstance().constructType(type);
    }

    public void init(ClassLoader classLoader) {
        Lock writeLock = this.actionProcessorsLock.writeLock();
        try {
            writeLock.lock();
            this.actionProcessors.clear();
            this.actionResolver = ActionResolver.getInstance().init(classLoader);
            this.actionProcessors.addAll(this.loadFieldActions(classLoader));
        }
        finally {
            writeLock.unlock();
        }
    }

    public List<ActionProcessor> loadFieldActions() {
        return this.loadFieldActions(this.getClass().getClassLoader());
    }

    public List<ActionProcessor> loadFieldActions(ClassLoader classLoader) {
        ServiceLoader<io.atlasmap.spi.AtlasFieldAction> fieldActionServiceLoader = ServiceLoader.load(io.atlasmap.spi.AtlasFieldAction.class, classLoader);
        ServiceLoader<AtlasFieldAction> compat = ServiceLoader.load(AtlasFieldAction.class, classLoader);
        ArrayList<ActionProcessor> answer = new ArrayList<ActionProcessor>();
        fieldActionServiceLoader.forEach(atlasFieldAction -> this.createActionProcessor((io.atlasmap.spi.AtlasFieldAction)atlasFieldAction, (List<ActionProcessor>)answer));
        compat.forEach(atlasFieldAction -> this.createActionProcessor((io.atlasmap.spi.AtlasFieldAction)atlasFieldAction, answer));
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Loaded %s Field Actions", answer.size()));
        }
        return answer;
    }

    private void createActionProcessor(io.atlasmap.spi.AtlasFieldAction atlasFieldAction, List<ActionProcessor> answer) {
        Method[] methods;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading FieldAction class: " + atlasFieldAction.getClass().getCanonicalName());
        }
        Class<?> clazz = atlasFieldAction.getClass();
        for (Method method : methods = clazz.getMethods()) {
            ActionProcessor det = this.createDetailFromFieldActionInfo(clazz, method);
            if (det != null) {
                answer.add(det);
            }
            if ((det = this.createDetailFromProcessor(clazz, method)) == null) continue;
            answer.add(det);
        }
    }

    private ActionProcessor createDetailFromFieldActionInfo(final Class<?> clazz, final Method method) {
        Class<?> actionClazz;
        AtlasFieldActionInfo annotation = method.getAnnotation(AtlasFieldActionInfo.class);
        if (annotation == null) {
            return null;
        }
        final ActionDetail det = new ActionDetail();
        det.setClassName(clazz.getName());
        det.setMethod(method.getName());
        det.setName(annotation.name());
        det.setSourceType(annotation.sourceType());
        det.setTargetType(annotation.targetType());
        CollectionType sourceCollection = annotation.sourceCollectionType();
        CollectionType targetCollection = annotation.sourceCollectionType();
        if (sourceCollection != null && sourceCollection != CollectionType.NONE) {
            det.setMultiplicity(Multiplicity.MANY_TO_ONE);
        } else if (targetCollection != null && targetCollection != CollectionType.NONE) {
            det.setMultiplicity(Multiplicity.ONE_TO_MANY);
        } else {
            det.setMultiplicity(Multiplicity.ONE_TO_ONE);
        }
        try {
            actionClazz = Class.forName("io.atlasmap.v2." + annotation.name());
        }
        catch (Exception e) {
            actionClazz = null;
            det.setCustom(Boolean.valueOf(true));
        }
        try {
            det.setActionSchema(actionClazz);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not get json schema for action=%s msg=%s", annotation.name(), e.getMessage()), (Throwable)e);
        }
        try {
            if (det.isCustom() == null || !det.isCustom().booleanValue()) {
                det.setParameters(this.detectFieldActionParameters(actionClazz));
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(String.format("Error detecting parameters for field action=%s msg=%s", annotation.name(), e.getMessage()), (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loaded FieldAction: " + det.getName());
        }
        final Class<?> finalActionClazz = actionClazz;
        return new ActionProcessor(){

            public ActionDetail getActionDetail() {
                return det;
            }

            public Class<? extends Action> getActionClass() {
                return finalActionClazz;
            }

            public Object process(Action action, Object sourceObject) throws AtlasException {
                Object targetObject = null;
                try {
                    Object convertedSourceObject = this.convertSourceObject(sourceObject);
                    if (Modifier.isStatic(method.getModifiers())) {
                        targetObject = det.isCustom() != null && det.isCustom().booleanValue() ? (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(null, new Object[0]) : method.invoke(null, convertedSourceObject)) : (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(null, action) : method.invoke(null, action, convertedSourceObject));
                    } else {
                        Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        targetObject = det.isCustom() != null && det.isCustom().booleanValue() ? (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(object, new Object[0]) : method.invoke(object, convertedSourceObject)) : (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE ? method.invoke(object, action) : method.invoke(object, action, convertedSourceObject));
                    }
                }
                catch (Throwable e) {
                    throw new AtlasException(String.format("Error processing action %s", det.getName()), e);
                }
                return targetObject;
            }

            private Object convertSourceObject(Object sourceObject) throws AtlasConversionException {
                int paramCount = method.getParameterCount();
                if (paramCount < 2) {
                    return null;
                }
                Class<?> paramType = method.getParameterTypes()[1];
                if (paramType.isInstance(sourceObject)) {
                    return sourceObject;
                }
                return DefaultAtlasFieldActionService.this.conversionService.convertType(sourceObject, null, paramType, null);
            }
        };
    }

    private ActionProcessor createDetailFromProcessor(Class<?> clazz, final Method method) {
        Type[] genericParameterTypes;
        AtlasActionProcessor annotation = method.getAnnotation(AtlasActionProcessor.class);
        if (annotation == null) {
            return null;
        }
        if (method.getParameterCount() < 1) {
            LOG.debug("Invalid @AtlasActionProcessor method.  Expected at least 1 parameter: " + method);
        }
        Class<?> actionClazz = null;
        if (Action.class.isAssignableFrom(method.getParameterTypes()[0])) {
            actionClazz = method.getParameterTypes()[0];
        } else {
            LOG.debug("Invalid @AtlasActionProcessor method.  1st parameter does not subclass " + Action.class.getName() + ": " + method);
        }
        Class<?> targetClass = method.getReturnType();
        String name = this.actionResolver.toId(actionClazz);
        final ActionDetail det = new ActionDetail();
        det.setClassName(clazz.getName());
        det.setMethod(method.getName());
        det.setName(name);
        det.setTargetType(this.toFieldType(targetClass, method.getGenericReturnType()));
        if (!clazz.getPackage().getName().equals("io.atlasmap.actions")) {
            det.setCustom(Boolean.valueOf(true));
        }
        if ((genericParameterTypes = method.getGenericParameterTypes()).length >= 2) {
            Class<?> sourceClass = method.getParameterTypes()[1];
            if (annotation.sourceType() != FieldType.NONE) {
                det.setSourceType(annotation.sourceType());
            } else {
                det.setSourceType(this.toFieldType(sourceClass, method.getGenericParameterTypes()[1]));
            }
            CollectionType sourceCollection = this.toFieldCollectionType(sourceClass);
            CollectionType targetCollection = this.toFieldCollectionType(targetClass);
            if (sourceCollection != CollectionType.NONE) {
                if (targetCollection != CollectionType.NONE) {
                    det.setMultiplicity(Multiplicity.MANY_TO_MANY);
                } else {
                    det.setMultiplicity(Multiplicity.MANY_TO_ONE);
                }
            } else if (targetCollection != CollectionType.NONE) {
                det.setMultiplicity(Multiplicity.ONE_TO_MANY);
            } else {
                det.setMultiplicity(Multiplicity.ONE_TO_ONE);
            }
        } else if (genericParameterTypes.length == 1) {
            det.setMultiplicity(Multiplicity.ZERO_TO_ONE);
        }
        try {
            det.setActionSchema(actionClazz);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not get json schema for action=%s msg=%s", clazz.getName(), e.getMessage()), (Throwable)e);
        }
        try {
            det.setParameters(this.detectFieldActionParameters(actionClazz));
        }
        catch (ClassNotFoundException e) {
            LOG.error(String.format("Error detecting parameters for field action=%s msg=%s", det.getName(), e.getMessage()), (Throwable)e);
        }
        Object o = null;
        try {
            o = Modifier.isStatic(method.getModifiers()) ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
        }
        catch (Throwable e) {
            LOG.error(String.format("Error creating object instance for action=%s msg=%s", det.getName(), e.getMessage()), e);
        }
        final Object object = o;
        final Class<?> finalActionClazz = actionClazz;
        return new ActionProcessor(){

            public ActionDetail getActionDetail() {
                return det;
            }

            public Class<? extends Action> getActionClass() {
                return finalActionClazz;
            }

            public Object process(Action action, Object sourceObject) throws AtlasException {
                try {
                    if (det.getMultiplicity() == Multiplicity.ZERO_TO_ONE) {
                        return method.invoke(object, action);
                    }
                    sourceObject = this.convertSourceObject(sourceObject);
                    return method.invoke(object, action, sourceObject);
                }
                catch (Throwable e) {
                    throw new AtlasException(String.format("Error processing action %s", det.getName()), e);
                }
            }

            private Object convertSourceObject(Object sourceObject) throws AtlasConversionException {
                if (sourceObject == null) {
                    return null;
                }
                Class<?> paramType = method.getParameterTypes()[1];
                CollectionType paramCollectionType = DefaultAtlasFieldActionService.this.toFieldCollectionType(paramType);
                CollectionType sourceCollectionType = DefaultAtlasFieldActionService.this.toFieldCollectionType(sourceObject.getClass());
                if (paramCollectionType != CollectionType.NONE) {
                    Class itemClass;
                    Type itemType = method.getGenericParameterTypes()[1];
                    Class clazz = itemClass = paramType.isArray() ? paramType.getComponentType() : (Class)((ParameterizedType)itemType).getActualTypeArguments()[0];
                    List<Object> sourceList = sourceCollectionType != CollectionType.NONE ? (sourceCollectionType == CollectionType.ARRAY ? Arrays.asList(sourceObject) : (sourceCollectionType == CollectionType.LIST ? (List<Object>)sourceObject : (sourceCollectionType == CollectionType.MAP ? new ArrayList(((Map)sourceObject).values()) : new ArrayList<Object>((Collection)sourceObject)))) : Arrays.asList(sourceObject);
                    DefaultAtlasFieldActionService.this.convertItems(sourceList, itemClass);
                    if (paramType.isArray()) {
                        return sourceList.toArray();
                    }
                    return sourceList;
                }
                if (paramType.isInstance(sourceObject)) {
                    return sourceObject;
                }
                return DefaultAtlasFieldActionService.this.conversionService.convertType(sourceObject, null, paramType, null);
            }
        };
    }

    private void convertItems(List<Object> sourceList, Class<?> itemClass) throws AtlasConversionException {
        for (int i = 0; i < sourceList.size(); ++i) {
            Object item = sourceList.get(i);
            if (item != null) {
                item = this.conversionService.convertType(item, null, itemClass, null);
            }
            sourceList.set(i, item);
        }
    }

    private CollectionType toFieldCollectionType(Class<?> clazz) {
        if (clazz.isArray()) {
            return CollectionType.ARRAY;
        }
        if (clazz == Collection.class) {
            return CollectionType.ALL;
        }
        if (listClasses.contains(clazz.getName())) {
            return CollectionType.LIST;
        }
        if (mapClasses.contains(clazz.getName())) {
            return CollectionType.MAP;
        }
        return CollectionType.NONE;
    }

    private FieldType toFieldType(Class<?> clazz, Type parameterType) {
        switch (this.toFieldCollectionType(clazz)) {
            case ARRAY: {
                return this.toFieldType(clazz.getComponentType(), parameterType);
            }
            case ALL: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
            case LIST: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
            case MAP: {
                Type t = ((ParameterizedType)parameterType).getActualTypeArguments()[1];
                return DefaultAtlasConversionService.getInstance().fieldTypeFromClass((Class)t);
            }
        }
        return DefaultAtlasConversionService.getInstance().fieldTypeFromClass(clazz);
    }

    private ActionParameters detectFieldActionParameters(Class<?> actionClazz) throws ClassNotFoundException {
        ActionParameters params = null;
        Method[] methods = actionClazz.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method method1, Method method2) {
                return method1.getName().compareToIgnoreCase(method2.getName());
            }
        });
        for (Method method : methods) {
            if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
            if (params == null) {
                params = new ActionParameters();
            }
            ActionParameter actionParam = null;
            for (Parameter methodParam : method.getParameters()) {
                actionParam = new ActionParameter();
                actionParam.setName(this.camelize(method.getName().substring("set".length())));
                actionParam.setFieldType(this.getConversionService().fieldTypeFromClass(methodParam.getType()));
                if (methodParam.getType().isEnum()) {
                    actionParam.setFieldType(FieldType.STRING);
                    try {
                        for (Object e : methodParam.getType().getEnumConstants()) {
                            Method m = e.getClass().getDeclaredMethod("value", new Class[0]);
                            actionParam.getValues().add(m.invoke(e, new Object[0]).toString());
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Failed to populate possible enum parameter values, ignoring...", (Throwable)e);
                    }
                }
                params.getParameter().add(actionParam);
            }
        }
        return params;
    }

    public List<ActionDetail> listActionDetails() {
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            List<ActionDetail> list = this.actionProcessors.stream().map(x -> x.getActionDetail()).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Deprecated
    protected ActionDetail getActionDetailByActionName(String actionName) {
        for (ActionDetail actionDetail : this.listActionDetails()) {
            if (!actionDetail.getName().equals(actionName)) continue;
            return actionDetail;
        }
        return null;
    }

    public ActionDetail findActionDetail(Action action, FieldType sourceType) throws AtlasException {
        ActionProcessor processor = this.findActionProcessor(action, sourceType);
        if (processor == null) {
            return null;
        }
        return processor.getActionDetail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionProcessor findActionProcessor(Action action, FieldType sourceType) throws AtlasException {
        CustomAction customAction = null;
        if (action instanceof CustomAction && ((customAction = (CustomAction)action).getClassName() == null || customAction.getMethodName() == null)) {
            throw new AtlasException("The class name and method name must be specified for custom FieldAction: " + customAction.getName());
        }
        ArrayList<ActionProcessor> matches = new ArrayList<ActionProcessor>();
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            for (ActionProcessor processor : this.actionProcessors) {
                if (customAction != null) {
                    ActionDetail detail = processor.getActionDetail();
                    if (!customAction.getClassName().equals(detail.getClassName()) || !customAction.getMethodName().equals(detail.getMethod())) continue;
                    matches.add(processor);
                    break;
                }
                if (processor.getActionClass() != action.getClass()) continue;
                matches.add(processor);
            }
        }
        finally {
            readLock.unlock();
        }
        return this.findBestActionProcessor(matches, sourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionProcessor findActionProcessor(String name, Object value) {
        FieldType valueType = value != null ? this.getConversionService().fieldTypeFromClass(value.getClass()) : FieldType.NONE;
        String uppercaseName = name.toUpperCase();
        ArrayList<ActionProcessor> processors = new ArrayList<ActionProcessor>();
        Lock readLock = this.actionProcessorsLock.readLock();
        try {
            readLock.lock();
            for (ActionProcessor processor : this.actionProcessors) {
                if (!processor.getActionDetail().getName().toUpperCase().equals(uppercaseName)) continue;
                processors.add(processor);
            }
        }
        finally {
            readLock.unlock();
        }
        return this.findBestActionProcessor(processors, valueType);
    }

    private ActionProcessor findBestActionProcessor(List<ActionProcessor> processors, FieldType valueType) {
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1) {
            return processors.get(0);
        }
        if (valueType != null && !Arrays.asList(FieldType.ANY, FieldType.NONE).contains(valueType)) {
            for (ActionProcessor processor : processors) {
                if (!valueType.equals((Object)processor.getActionDetail().getSourceType())) continue;
                return processor;
            }
        }
        return processors.get(0);
    }

    public Field buildAndProcessAction(ActionProcessor actionProcessor, Map<String, Object> actionParameters, Field field) {
        FieldType valueType = this.determineFieldType(field);
        try {
            Action action = (Action)actionProcessor.getActionClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Map.Entry<String, Object> property : actionParameters.entrySet()) {
                String setter = "set" + property.getKey().substring(0, 1).toUpperCase() + property.getKey().substring(1);
                action.getClass().getMethod(setter, property.getValue().getClass()).invoke((Object)action, property.getValue());
            }
            return this.processAction(action, actionProcessor, valueType, field);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The action '%s' cannot be processed", actionProcessor.getActionDetail().getName()), e);
        }
    }

    public Field processActions(AtlasInternalSession session, Field field) throws AtlasException {
        ArrayList actions = field.getActions();
        if (actions == null || actions.isEmpty()) {
            return field;
        }
        Field tmpSourceField = field;
        FieldType currentType = this.determineFieldType(field);
        for (Action action : actions) {
            ActionProcessor processor = this.findActionProcessor(action, currentType);
            if (processor == null) {
                AtlasUtil.addAudit(session, field, String.format("Couldn't find metadata for a FieldAction '%s', please make sure it's in the classpath, and also have a service declaration under META-INF/services. Ignoring...", action.getDisplayName()), AuditStatus.WARN, null);
                continue;
            }
            ActionDetail detail = processor.getActionDetail();
            if (detail == null) {
                AtlasUtil.addAudit(session, field, String.format("Couldn't find metadata for a FieldAction '%s', ignoring...", action.getDisplayName()), AuditStatus.WARN, null);
                continue;
            }
            tmpSourceField = this.processAction(action, processor, currentType, tmpSourceField);
            currentType = this.determineFieldType(tmpSourceField);
        }
        return tmpSourceField;
    }

    private FieldType determineFieldType(Field field) {
        if (field == null) {
            return null;
        }
        if (field instanceof FieldGroup) {
            for (Field f : ((FieldGroup)FieldGroup.class.cast(field)).getField()) {
                FieldType type = this.determineFieldType(f);
                if (type == null) continue;
                return type;
            }
            return FieldType.NONE;
        }
        if (field.getFieldType() != null) {
            return field.getFieldType();
        }
        if (field.getValue() != null) {
            return this.getConversionService().fieldTypeFromClass(field.getValue().getClass());
        }
        return FieldType.NONE;
    }

    private Field processAction(Action action, ActionProcessor processor, FieldType sourceType, Field field) throws AtlasException {
        Multiplicity multiplicity;
        ActionDetail detail = processor.getActionDetail();
        Multiplicity multiplicity2 = multiplicity = detail.getMultiplicity() != null ? detail.getMultiplicity() : Multiplicity.ONE_TO_ONE;
        if (multiplicity == Multiplicity.MANY_TO_ONE) {
            return this.processManyToOne(action, processor, sourceType, field);
        }
        if (multiplicity == Multiplicity.ONE_TO_MANY) {
            if (field instanceof FieldGroup) {
                while (field instanceof FieldGroup) {
                    field = (Field)((FieldGroup)field).getField().get(0);
                }
            }
            return this.processOneToMany(action, processor, sourceType, field);
        }
        if (field instanceof FieldGroup) {
            return this.processActionForEachCollectionItem(action, processor, sourceType, (FieldGroup)field);
        }
        Object value = field.getValue();
        if (value != null && !this.isAssignableFieldType(detail.getSourceType(), sourceType)) {
            value = this.getConversionService().convertType(value, sourceType, detail.getSourceType());
        }
        value = processor.process(action, value);
        field.setFieldType(processor.getActionDetail().getTargetType());
        field.setValue(value);
        return field;
    }

    private Field processManyToOne(Action action, ActionProcessor processor, FieldType sourceType, Field field) throws AtlasException {
        ActionDetail detail = processor.getActionDetail();
        LinkedList<Object> values = new LinkedList<Object>();
        if (action instanceof Expression) {
            this.extractNestedListValuesForExpressionAction(field, values);
            this.convertCollectionValues(values, detail.getSourceType());
            Object out = processor.process(action, values);
            return this.packExpressionActionOutcomeIntoField(out, field);
        }
        if (field instanceof FieldGroup) {
            this.extractFlatListValuesFromFieldGroup((FieldGroup)field, values);
        } else {
            Object value = field.getValue();
            if (value != null && this.getConversionService().isAssignableFieldType(detail.getSourceType(), sourceType).booleanValue()) {
                value = this.getConversionService().convertType(value, sourceType, detail.getSourceType());
            }
            values.add(value);
        }
        this.convertCollectionValues(values, detail.getSourceType());
        Object out = processor.process(action, values);
        field = AtlasModelFactory.cloneFieldToSimpleField((Field)field);
        if (out != null) {
            field.setFieldType(this.getConversionService().fieldTypeFromClass(out.getClass()));
            field.setValue(out);
        }
        return field;
    }

    private void extractNestedListValuesForExpressionAction(Field field, List<Object> fieldValues) {
        if (!(field instanceof FieldGroup)) {
            fieldValues.add(field.getValue());
            return;
        }
        FieldGroup fieldGroup = (FieldGroup)field;
        if (fieldGroup == null || fieldGroup.getField() == null || fieldGroup.getField().isEmpty()) {
            return;
        }
        LinkedList<Field> fields = null;
        while (fieldGroup.getPath() == null || fieldGroup.getPath().isEmpty()) {
            if (fieldGroup.getField().size() == 1 && fieldGroup.getField().get(0) instanceof FieldGroup) {
                fieldGroup = (FieldGroup)fieldGroup.getField().get(0);
                continue;
            }
            fields = fieldGroup.getField();
            break;
        }
        if (fields == null) {
            fields = new LinkedList<Field>();
            fields.add((Field)fieldGroup);
        }
        this.doExtractValuesForExpressionAction(fields, fieldValues);
    }

    private void doExtractValuesForExpressionAction(List<Field> fields, List<Object> values) {
        for (Field subField : fields) {
            ArrayList<Object> subValue = null;
            if (subField instanceof FieldGroup) {
                ArrayList<Object> subValues = new ArrayList<Object>();
                this.doExtractValuesForExpressionAction(((FieldGroup)subField).getField(), subValues);
                subValue = subValues;
            } else {
                subValue = subField.getValue();
            }
            Integer index = subField.getIndex();
            if (index != null) {
                while (index >= values.size()) {
                    values.add(null);
                }
                values.set(index, subValue);
                continue;
            }
            values.add(subValue);
        }
    }

    private Field packExpressionActionOutcomeIntoField(Object values, Field field) {
        if (values instanceof List) {
            FieldGroup fieldGroup = new FieldGroup();
            AtlasPath groupPath = new AtlasPath("$ATLASMAP");
            fieldGroup.setCollectionType(CollectionType.LIST);
            groupPath = new AtlasPath(groupPath.toString() + "<>");
            fieldGroup.setPath(groupPath.toString());
            List tmpSourceList = (List)values;
            while (tmpSourceList.size() == 1 && tmpSourceList.get(0) instanceof List) {
                tmpSourceList = (List)tmpSourceList.get(0);
            }
            FieldType type = null;
            for (int i = 0; i < tmpSourceList.size(); ++i) {
                Object subValue = tmpSourceList.get(i);
                if (type == null && subValue != null) {
                    type = this.getConversionService().fieldTypeFromClass(subValue.getClass());
                }
                SimpleField subField = new SimpleField();
                AtlasPath subPath = groupPath.clone();
                subPath.setVacantCollectionIndex(i);
                AtlasModelFactory.copyField((Field)fieldGroup, (Field)subField, (boolean)false);
                subField.setPath(subPath.toString());
                subField.setIndex(null);
                subField.setValue(subValue);
                subField.setFieldType(type);
                subField.setCollectionType(CollectionType.NONE);
                fieldGroup.getField().add(subField);
            }
            return fieldGroup;
        }
        if (values != null) {
            field = new SimpleField();
            field.setPath("$ATLASMAP");
            field.setValue(values);
            field.setFieldType(this.getConversionService().fieldTypeFromClass(values.getClass()));
        }
        return field;
    }

    private void extractFlatListValuesFromFieldGroup(FieldGroup fieldGroup, List<Object> values) {
        if (fieldGroup == null || fieldGroup.getField() == null || fieldGroup.getField().isEmpty()) {
            return;
        }
        while ((fieldGroup.getPath() == null || fieldGroup.getPath().isEmpty()) && fieldGroup.getField().size() == 1 && fieldGroup.getField().get(0) instanceof FieldGroup) {
            fieldGroup = (FieldGroup)fieldGroup.getField().get(0);
        }
        LinkedList<Object> tmpValues = new LinkedList<Object>();
        for (int i = 0; i < fieldGroup.getField().size(); ++i) {
            Field subField = (Field)fieldGroup.getField().get(i);
            LinkedList<Object> value = null;
            if (subField instanceof FieldGroup) {
                LinkedList<Object> subValues = new LinkedList<Object>();
                this.extractFlatListValuesFromFieldGroup((FieldGroup)subField, subValues);
                value = subValues;
            } else {
                value = subField.getValue();
            }
            Integer index = subField.getIndex();
            if (index != null) {
                while (index >= tmpValues.size()) {
                    tmpValues.add(null);
                }
                tmpValues.set(index, value);
                continue;
            }
            tmpValues.add(value);
        }
        values.addAll(this.flatten(tmpValues));
    }

    private List<Object> flatten(List<Object> values) {
        LinkedList<Object> answer = new LinkedList<Object>();
        for (Object o : values) {
            if (o instanceof List) {
                answer.addAll(this.flatten((List)o));
                continue;
            }
            answer.add(o);
        }
        return answer;
    }

    private Field processOneToMany(Action action, ActionProcessor processor, FieldType sourceType, Field field) throws AtlasException {
        List<Object> values;
        Object value = field.getValue();
        if (value != null && this.isAssignableFieldType(processor.getActionDetail().getSourceType(), sourceType)) {
            value = this.getConversionService().convertType(value, sourceType, processor.getActionDetail().getSourceType());
        }
        value = processor.process(action, value);
        FieldGroup answer = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)false);
        AtlasPath path = new AtlasPath(answer.getPath() + "<>");
        answer.setPath(path.toString());
        answer.setCollectionType(CollectionType.LIST);
        answer.setFieldType(processor.getActionDetail().getTargetType());
        if (value != null && value.getClass().isArray()) {
            values = Arrays.asList((Object[])value);
        } else if (value instanceof Collection && !(value instanceof List)) {
            values = Arrays.asList(((Collection)value).toArray());
        } else {
            values = new LinkedList();
            if (value != null) {
                values.add(value);
            }
        }
        for (int i = 0; i < values.size(); ++i) {
            SimpleField subField = AtlasModelFactory.cloneFieldToSimpleField((Field)answer);
            AtlasPath subPath = new AtlasPath(answer.getPath());
            subPath.setVacantCollectionIndex(i);
            subField.setPath(subPath.toString());
            subField.setCollectionType(CollectionType.NONE);
            subField.setIndex(null);
            subField.setValue(values.get(i));
            answer.getField().add(subField);
        }
        return answer;
    }

    private FieldGroup processActionForEachCollectionItem(Action action, ActionProcessor processor, FieldType sourceType, FieldGroup fieldGroup) throws AtlasException {
        for (Field subField : fieldGroup.getField()) {
            if (subField instanceof FieldGroup) {
                this.processActionForEachCollectionItem(action, processor, sourceType, (FieldGroup)subField);
                continue;
            }
            Object value = subField.getValue();
            if (value != null && this.isAssignableFieldType(processor.getActionDetail().getSourceType(), sourceType)) {
                value = this.getConversionService().convertType(value, sourceType, processor.getActionDetail().getSourceType());
            }
            value = processor.process(action, value);
            subField.setValue(value);
        }
        return fieldGroup;
    }

    private void convertCollectionValues(List<Object> sourceList, FieldType type) throws AtlasConversionException {
        for (int i = 0; i < sourceList.size(); ++i) {
            FieldType subType;
            Object subValue = sourceList.get(i);
            if (subValue instanceof List) {
                this.convertCollectionValues((List)subValue, type);
                continue;
            }
            FieldType fieldType = subType = subValue != null ? this.getConversionService().fieldTypeFromClass(subValue.getClass()) : FieldType.NONE;
            if (subValue == null || this.isAssignableFieldType(type, subType)) continue;
            subValue = this.getConversionService().convertType(subValue, subType, type);
            sourceList.set(i, subValue);
        }
    }

    private boolean isAssignableFieldType(FieldType expected, FieldType actual) {
        if (FieldType.ANY.equals((Object)expected)) {
            return true;
        }
        if (FieldType.ANY_DATE.equals((Object)expected)) {
            return FieldType.DATE.equals((Object)actual) || FieldType.TIME.equals((Object)actual) || FieldType.DATE_TIME.equals((Object)actual) || FieldType.DATE_TIME_TZ.equals((Object)actual) || FieldType.DATE_TZ.equals((Object)actual) || FieldType.TIME_TZ.equals((Object)actual);
        }
        return expected.equals((Object)actual);
    }

    public AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    private String camelize(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            return parameter;
        }
        char[] c = parameter.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static {
        listClasses = new HashSet<String>(Arrays.asList("java.util.List", "java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.AbstractList", "java.util.AbstractSequentialList"));
        mapClasses = new HashSet<String>(Arrays.asList("java.util.Map", "java.util.HashMap", "java.util.TreeMap", "java.util.Hashtable", "java.util.IdentityHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap", "java.util.SortedMap", "java.util.WeakHashMap", "java.util.Properties", "java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap"));
    }
}

