/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core.validate;

import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.core.DefaultAtlasCollectionHelper;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.validate.MappingFieldPairValidator;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CustomMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseModuleValidationService<T extends Field>
implements AtlasValidationService {
    private AtlasConversionService conversionService;
    private AtlasFieldActionService fieldActionService;
    private DefaultAtlasCollectionHelper collectionHelper;
    private AtlasModuleMode mode;
    private String docId;
    private MappingFieldPairValidator mappingFieldPairValidator;

    public BaseModuleValidationService() {
        this.conversionService = DefaultAtlasConversionService.getInstance();
        this.fieldActionService = DefaultAtlasFieldActionService.getInstance();
        this.collectionHelper = new DefaultAtlasCollectionHelper(this.fieldActionService);
        this.init();
    }

    public BaseModuleValidationService(AtlasConversionService conversionService, AtlasFieldActionService fieldActionService) {
        this.conversionService = conversionService;
        this.fieldActionService = fieldActionService;
        this.collectionHelper = new DefaultAtlasCollectionHelper(fieldActionService);
        this.init();
    }

    private void init() {
        this.mappingFieldPairValidator = new MappingFieldPairValidator(this);
    }

    public void setMode(AtlasModuleMode mode) {
        this.mode = mode;
    }

    public AtlasModuleMode getMode() {
        return this.mode;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    protected abstract AtlasModuleDetail getModuleDetail();

    public List<Validation> validateMapping(AtlasMapping mapping) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        if (this.getMode() == AtlasModuleMode.UNSET) {
            Validation validation = new Validation();
            validation.setMessage(String.format("No mode specified for %s/%s, skipping module validations", this.getModuleDetail().name(), this.getClass().getSimpleName()));
        }
        if (mapping != null && mapping.getMappings() != null && mapping.getMappings().getMapping() != null && !mapping.getMappings().getMapping().isEmpty()) {
            this.validateMappingEntries(mapping.getMappings().getMapping(), validations);
        }
        boolean found = false;
        for (DataSource ds : mapping.getDataSource()) {
            if (ds.getUri() == null || !ds.getUri().startsWith(this.getModuleDetail().uri())) continue;
            found = true;
            break;
        }
        if (!found) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.DATA_SOURCE);
            validation.setMessage(String.format("No DataSource with '%s' uri specified", this.getModuleDetail().uri()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
        return validations;
    }

    protected void validateMappingEntries(List<BaseMapping> mappings, List<Validation> validations) {
        for (BaseMapping fieldMapping : mappings) {
            if (fieldMapping.getClass().isAssignableFrom(CustomMapping.class)) {
                this.validateCustomMapping((CustomMapping)fieldMapping, validations);
                continue;
            }
            if (fieldMapping.getClass().isAssignableFrom(Mapping.class) && MappingType.SEPARATE.equals((Object)((Mapping)fieldMapping).getMappingType())) {
                this.validateSeparateMapping((Mapping)fieldMapping, validations);
                continue;
            }
            if (fieldMapping.getClass().isAssignableFrom(Mapping.class) && MappingType.COMBINE.equals((Object)((Mapping)fieldMapping).getMappingType())) {
                this.validateCombineMapping((Mapping)fieldMapping, validations);
                continue;
            }
            if (fieldMapping instanceof Collection) {
                fieldMapping = (BaseMapping)((Collection)fieldMapping).getMappings().getMapping().get(0);
            }
            this.validateMapMapping((Mapping)fieldMapping, validations);
        }
    }

    protected void validateMapMapping(Mapping mapping, List<Validation> validations) {
        if (mapping == null || mapping.getInputField() == null || mapping.getInputFieldGroup() == null && mapping.getInputField().size() <= 0 || mapping.getOutputField() == null || mapping.getOutputField().size() <= 0) {
            return;
        }
        String mappingId = mapping.getId();
        if (this.getMode() == AtlasModuleMode.SOURCE) {
            FieldGroup sourceFieldGroup = mapping.getInputFieldGroup();
            if (sourceFieldGroup != null) {
                this.validateFieldGroup(mappingId, sourceFieldGroup, FieldDirection.SOURCE, validations);
            } else {
                List sourceFields = mapping.getInputField();
                sourceFields.forEach(sourceField -> this.validateField(mappingId, null, (Field)sourceField, FieldDirection.SOURCE, validations));
            }
        } else if (this.getMode() == AtlasModuleMode.TARGET) {
            List targetFields = mapping.getOutputField();
            if (targetFields.size() == 1 && Integer.valueOf(0).equals(((Field)targetFields.get(0)).getIndex())) {
                ((Field)targetFields.get(0)).setIndex(null);
            }
            int i = 0;
            List sourceFields = mapping.getInputField();
            for (Field targetField : targetFields) {
                if (sourceFields.size() > i) {
                    this.validateField(mappingId, (Field)sourceFields.get(i), targetField, FieldDirection.TARGET, validations);
                } else {
                    this.validateField(mappingId, null, targetField, FieldDirection.TARGET, validations);
                }
                ++i;
            }
        }
        if (this.getMode() == AtlasModuleMode.SOURCE) {
            this.validateFieldCombinations(mapping, validations);
        }
    }

    protected void validateCustomMapping(CustomMapping mapping, List<Validation> validations) {
        if (mapping.getClassName() == null || mapping.getClassName().isEmpty()) {
            Validation v = new Validation();
            v.setScope(ValidationScope.MAPPING);
            v.setMessage("Class name must be specified for custom mapping");
            v.setStatus(ValidationStatus.ERROR);
            validations.add(v);
        }
    }

    protected void validateFieldGroup(String mappingId, FieldGroup fieldGroup, FieldDirection direction, List<Validation> validations) {
        fieldGroup.getField().forEach(f -> this.validateField(mappingId, null, (Field)f, direction, validations));
    }

    protected void validateFieldCombinations(Mapping mapping, List<Validation> validations) {
        String mappingId = mapping.getId();
        FieldGroup sourceFieldGroup = mapping.getInputFieldGroup();
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        if (sourceFieldGroup != null || sourceFields != null && sourceFields.size() > 1) {
            if (targetFields.size() > 1) {
                Validation validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage("Multiple fields can not be selected on both of Source and Target");
                validation.setStatus(ValidationStatus.ERROR);
                validations.add(validation);
            }
            if (sourceFieldGroup != null) {
                this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, sourceFieldGroup, (Field)targetFields.get(0));
            } else {
                this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, sourceFields, (Field)targetFields.get(0));
            }
        } else if (targetFields != null && targetFields.size() > 1) {
            this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, (Field)sourceFields.get(0), targetFields);
        } else {
            this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, (Field)sourceFields.get(0), (Field)targetFields.get(0));
        }
    }

    protected void validateField(String mappingId, Field sourceField, Field targetField, FieldDirection direction, List<Validation> validations) {
        if (targetField == null) {
            return;
        }
        if (direction == FieldDirection.TARGET) {
            Integer sourceCollectionCount = null;
            if (sourceField != null) {
                sourceCollectionCount = this.collectionHelper.determineSourceCollectionCount(null, sourceField);
            }
            Integer targetCollectionCount = this.collectionHelper.determineTargetCollectionCount(targetField);
            if (sourceCollectionCount != null) {
                if (sourceCollectionCount > targetCollectionCount) {
                    Validation validation = new Validation();
                    validation.setScope(ValidationScope.MAPPING);
                    validation.setId(mappingId);
                    String message = String.format("Target [%s] has %s collection(s) on the path, whereas source has %s. Values from the %s rightmost source collections on the path will be added in depth-first order to the rightmost target collection(s) unless transformed explicitly.", targetField.getPath(), targetCollectionCount, sourceCollectionCount, sourceCollectionCount - targetCollectionCount + 1);
                    validation.setMessage(message);
                    validation.setStatus(ValidationStatus.WARN);
                    validations.add(validation);
                } else if (sourceCollectionCount < targetCollectionCount) {
                    Validation validation = new Validation();
                    validation.setScope(ValidationScope.MAPPING);
                    validation.setId(mappingId);
                    validation.setMessage(String.format("The 0 index will be used for any extra parent collections in target [%s], since target has %s collections on the path, whereas source has %s.", targetField.getPath(), targetCollectionCount, sourceCollectionCount));
                    validation.setStatus(ValidationStatus.WARN);
                    validations.add(validation);
                }
            }
        }
        if (this.getFieldType().isAssignableFrom(targetField.getClass()) && this.matchDocIdOrNull(targetField.getDocId())) {
            this.validateModuleField(mappingId, targetField, direction, validations);
        }
    }

    protected abstract Class<T> getFieldType();

    protected abstract void validateModuleField(String var1, T var2, FieldDirection var3, List<Validation> var4);

    protected boolean matchDocIdOrNull(String docId) {
        return docId == null || this.getDocId().equals(docId);
    }

    protected String getFieldName(Field field) {
        if (field == null) {
            return "null";
        }
        if (field.getClass().isAssignableFrom(this.getFieldType())) {
            return this.getModuleFieldName(field);
        }
        if (field.getFieldType() != null) {
            return field.getFieldType().name();
        }
        return field.getClass().getName();
    }

    protected abstract String getModuleFieldName(T var1);

    protected AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    protected AtlasFieldActionService getFieldActionService() {
        return this.fieldActionService;
    }

    protected MappingFieldPairValidator getMappingFieldPairValidator() {
        return this.mappingFieldPairValidator;
    }

    protected void setMappingFieldPairValidator(MappingFieldPairValidator mfpv) {
        this.mappingFieldPairValidator = mfpv;
    }

    protected void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Deprecated
    protected void validateCombineMapping(Mapping mapping, List<Validation> validations) {
        Field targetField;
        if (mapping == null) {
            return;
        }
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        Field field = targetField = targetFields != null && !targetFields.isEmpty() ? (Field)targetFields.get(0) : null;
        if (targetField == null) {
            return;
        }
        String mappingId = mapping.getId();
        if (this.getMode() == AtlasModuleMode.TARGET && this.matchDocIdOrNull(targetField.getDocId())) {
            if (sourceFields != null) {
                for (Field sourceField : sourceFields) {
                    this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, sourceField, targetField);
                }
            }
            if (targetField.getFieldType() != null && targetField.getFieldType() != FieldType.STRING) {
                Validation validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(String.format("Target field '%s' must be of type '%s' for a Combine Mapping", this.getFieldName(targetField), FieldType.STRING));
                validation.setStatus(ValidationStatus.ERROR);
                validations.add(validation);
            }
            this.validateField(mappingId, null, targetField, FieldDirection.TARGET, validations);
        } else if (sourceFields != null) {
            for (Field sourceField : sourceFields) {
                if (!this.matchDocIdOrNull(sourceField.getDocId())) continue;
                this.validateField(mappingId, null, sourceField, FieldDirection.SOURCE, validations);
            }
        }
    }

    @Deprecated
    protected void validateSeparateMapping(Mapping mapping, List<Validation> validations) {
        block7: {
            String mappingId;
            List targetFields;
            block6: {
                Field sourceField;
                if (mapping == null) {
                    return;
                }
                List sourceFields = mapping.getInputField();
                Field field = sourceField = sourceFields != null && !sourceFields.isEmpty() ? (Field)sourceFields.get(0) : null;
                if (sourceField == null) {
                    return;
                }
                targetFields = mapping.getOutputField();
                mappingId = mapping.getId();
                if (this.getMode() != AtlasModuleMode.SOURCE || !this.matchDocIdOrNull(sourceField.getDocId())) break block6;
                if (sourceField.getFieldType() != null && sourceField.getFieldType() != FieldType.STRING) {
                    Validation validation = new Validation();
                    validation.setScope(ValidationScope.MAPPING);
                    validation.setId(mapping.getId());
                    validation.setMessage(String.format("Source field '%s' must be of type '%s' for a Separate Mapping", this.getFieldName(sourceField), FieldType.STRING));
                    validation.setStatus(ValidationStatus.ERROR);
                    validations.add(validation);
                }
                this.validateField(mappingId, null, sourceField, FieldDirection.SOURCE, validations);
                if (targetFields == null) break block7;
                for (Field targetField : targetFields) {
                    this.mappingFieldPairValidator.validateFieldTypes(validations, mappingId, sourceField, targetField);
                }
                break block7;
            }
            if (targetFields != null) {
                for (Field targetField : targetFields) {
                    if (!this.matchDocIdOrNull(targetField.getDocId())) continue;
                    this.validateField(mappingId, null, targetField, FieldDirection.TARGET, validations);
                }
            }
        }
    }
}

