/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.DateFieldActions;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.AddSeconds;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateFieldActionsTest {
    @Test
    public void testAddDays() {
        AddDays action = new AddDays();
        action.setDays(Integer.valueOf(2));
        Assertions.assertNull((Object)DateFieldActions.addDays((AddDays)action, null));
        ZonedDateTime origDate = ZonedDateTime.now();
        ZonedDateTime laterDate = origDate.plusDays(2L);
        Assertions.assertEquals((Object)laterDate, (Object)DateFieldActions.addDays((AddDays)action, (ZonedDateTime)origDate));
    }

    @Test
    public void testAddDaysWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateFieldActions.addDays(null, (ZonedDateTime)ZonedDateTime.now()));
    }

    @Test
    public void testAddSeconds() {
        AddSeconds action = new AddSeconds();
        action.setSeconds(Integer.valueOf(2));
        Assertions.assertNull((Object)DateFieldActions.addSeconds((AddSeconds)action, null));
        ZonedDateTime origDate = ZonedDateTime.now();
        ZonedDateTime laterDate = origDate.plusSeconds(2L);
        Assertions.assertEquals((Object)laterDate, (Object)DateFieldActions.addSeconds((AddSeconds)action, (ZonedDateTime)origDate));
    }

    @Test
    public void testAddSecondsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateFieldActions.addSeconds(null, (ZonedDateTime)ZonedDateTime.now()));
    }

    @Test
    public void testCurrentDate() {
        Assertions.assertNotNull((Object)DateFieldActions.currentDate(null));
    }

    @Test
    public void testCurrentDateTime() {
        Assertions.assertNotNull((Object)DateFieldActions.currentDateTime(null));
    }

    @Test
    public void testCurrentTime() {
        Assertions.assertNotNull((Object)DateFieldActions.currentTime(null));
    }

    @Test
    public void testDayOfMonth() {
        Assertions.assertNull((Object)DateFieldActions.dayOfMonth(null, null));
        ZonedDateTime origDate = LocalDate.of(2018, 10, 3).atStartOfDay(ZoneId.systemDefault());
        Assertions.assertEquals((Integer)3, (Integer)DateFieldActions.dayOfMonth(null, (ZonedDateTime)origDate));
    }

    @Test
    public void testDayOfWeek() {
        Assertions.assertNull((Object)DateFieldActions.dayOfWeek(null, null));
        ZonedDateTime origDate = LocalDate.of(2017, 12, 14).atStartOfDay(ZoneId.systemDefault());
        Assertions.assertEquals((Integer)4, (Integer)DateFieldActions.dayOfWeek(null, (ZonedDateTime)origDate));
    }

    @Test
    public void testDayOfYear() {
        Assertions.assertNull((Object)DateFieldActions.dayOfYear(null, null));
        ZonedDateTime origDate = LocalDate.of(2017, 12, 31).atStartOfDay(ZoneId.systemDefault());
        Assertions.assertEquals((Integer)365, (Integer)DateFieldActions.dayOfYear(null, (ZonedDateTime)origDate));
    }
}

