/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.TemplateCombineStrategy;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.StringDelimiter;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Validations;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DefaultAtlasContextTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void testMappingsVersion() throws AtlasException {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        this.recreateSession();
        this.mapping.setVersion("1.2.3-SNAPSHOT");
        String v = this.mapping.getVersion();
        Assertions.assertEquals((Object)v, (Object)"1.2.3-SNAPSHOT");
        this.mapping.getMappings().getMapping().add(m);
        this.populateSourceField(m, FieldType.STRING, "foo");
        this.prepareTargetField(m, "/target");
        this.context.processValidation((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasWarns(), (String)this.printAudit((AtlasSession)this.session));
        this.recreateSession();
        this.mapping.setVersion("99.2.3-SNAPSHOT");
        this.populateSourceField(m, FieldType.STRING, "foo");
        this.prepareTargetField(m, "/target");
        this.context.processValidation((AtlasSession)this.session);
        Assertions.assertTrue((boolean)this.session.hasWarns(), (String)this.printAudit((AtlasSession)this.session));
    }

    @Test
    public void testMap() throws AtlasException {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        this.mapping.getMappings().getMapping().add(m);
        this.recreateSession();
        this.populateSourceField(m, FieldType.STRING, "foo");
        this.prepareTargetField(m, "/target");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"foo", (Object)this.writer.targets.get("/target"));
    }

    @Test
    public void testMapNotExistingDocId() throws AtlasException {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        this.mapping.getMappings().getMapping().add(m);
        this.populateSourceField(m, "docId.not.existing", FieldType.STRING, (Object)"foo");
        this.prepareTargetField(m, "/target");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertTrue((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((long)1L, (long)this.session.getAudits().getAudit().stream().filter(a -> a.getStatus() == AuditStatus.ERROR).count());
    }

    @Test
    public void testProcessWithoutMappings() throws AtlasException {
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertTrue((boolean)this.session.hasWarns(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((int)1, (int)this.session.getAudits().getAudit().size());
        Assertions.assertEquals((Object)"Field mappings should not be empty", (Object)((Audit)this.session.getAudits().getAudit().get(0)).getMessage());
    }

    @Test
    public void testProcessValidationWithoutMappings() throws AtlasException {
        this.recreateSession();
        this.context.processValidation((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertFalse((boolean)this.session.hasWarns(), (String)this.printAudit((AtlasSession)this.session));
    }

    @Test
    public void testCombineNonStringFields() throws AtlasException {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        this.mapping.getMappings().getMapping().add(m);
        m.setDelimiter(StringDelimiter.SEMICOLON.getName());
        this.populateSourceField(m, FieldType.DATE_TIME, new Date(0L), 0);
        this.populateSourceField(m, FieldType.INTEGER, 1, 1);
        this.populateSourceField(m, FieldType.DOUBLE, 2.0, 2);
        this.populateSourceField(m, FieldType.FLOAT, Float.valueOf(3.0f), 3);
        this.populateSourceField(m, FieldType.BOOLEAN, true, 4);
        this.populateSourceField(m, FieldType.NUMBER, 5, 5);
        this.populateSourceField(m, FieldType.SHORT, (short)6, 6);
        this.populateSourceField(m, FieldType.STRING, (Object)"string", 7);
        this.populateSourceField(m, FieldType.BYTE, Byte.parseByte("8"), 8);
        this.populateSourceField(m, FieldType.CHAR, Character.valueOf('9'), 9);
        this.populateSourceField(m, FieldType.UNSIGNED_INTEGER, 10, 10);
        this.prepareTargetField(m, "/target");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)(new Date(0L).toInstant().toString() + ";1;2.0;3.0;true;5;6;string;8;9;10"), (Object)this.writer.targets.get("/target"));
    }

    @Test
    public void testTemplateCombine() throws AtlasException {
        DefaultAtlasContextFactory.getInstance().setCombineStrategy((AtlasCombineStrategy)new TemplateCombineStrategy());
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        this.mapping.getMappings().getMapping().add(mapping);
        this.populateSourceField(mapping, FieldType.STRING, (Object)"string", 0);
        this.populateSourceField(mapping, FieldType.INTEGER, 1, 1);
        this.populateSourceField(mapping, FieldType.DOUBLE, 2.0, 2);
        this.prepareTargetField(mapping, "/target");
        mapping.setDelimiterString("String: {1}, Integer: {2}, Double: {3}, String again: {1}");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"String: string, Integer: 1, Double: 2.0, String again: string", (Object)this.writer.targets.get("/target"));
    }

    @Test
    public void testCombineNonSupportedObjects() throws AtlasException {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        this.mapping.getMappings().getMapping().add(m);
        m.setDelimiter(StringDelimiter.SEMICOLON.getName());
        this.populateUnsupportedSourceField(m, "foo", 0);
        this.populateUnsupportedSourceField(m, "bar", 1);
        this.prepareTargetField(m, "/target");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"foo;bar", (Object)this.writer.targets.get("/target"));
    }

    @Test
    public void testSeparate() throws Exception {
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        this.mapping.getMappings().getMapping().add(m);
        m.setDelimiter(StringDelimiter.SEMICOLON.getName());
        this.populateSourceField(m, FieldType.STRING, new Date(0L).toString() + ";1;2.0;3.0;true;5;6;string;8;9;10");
        this.prepareTargetField(m, "/target1", 1);
        this.prepareTargetField(m, "/target0", 0);
        this.prepareTargetField(m, "/target10", 10);
        this.prepareTargetField(m, "/target9", 9);
        this.prepareTargetField(m, "/target8", 8);
        this.prepareTargetField(m, "/target7", 7);
        this.prepareTargetField(m, "/target6", 6);
        this.prepareTargetField(m, "/target5", 5);
        this.prepareTargetField(m, "/target4", 4);
        this.prepareTargetField(m, "/target3", 3);
        this.prepareTargetField(m, "/target2", 2);
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)new Date(0L).toString(), (Object)this.writer.targets.get("/target0"));
        Assertions.assertEquals((Object)"1", (Object)this.writer.targets.get("/target1"));
        Assertions.assertEquals((Object)"2.0", (Object)this.writer.targets.get("/target2"));
        Assertions.assertEquals((Object)"3.0", (Object)this.writer.targets.get("/target3"));
        Assertions.assertEquals((Object)"true", (Object)this.writer.targets.get("/target4"));
        Assertions.assertEquals((Object)"5", (Object)this.writer.targets.get("/target5"));
        Assertions.assertEquals((Object)"6", (Object)this.writer.targets.get("/target6"));
        Assertions.assertEquals((Object)"string", (Object)this.writer.targets.get("/target7"));
        Assertions.assertEquals((Object)"8", (Object)this.writer.targets.get("/target8"));
        Assertions.assertEquals((Object)"9", (Object)this.writer.targets.get("/target9"));
        Assertions.assertEquals((Object)"10", (Object)this.writer.targets.get("/target10"));
    }

    @Test
    public void testLookupTable() throws Exception {
        LookupTable table = new LookupTable();
        table.setName("table");
        LookupEntry e = new LookupEntry();
        e.setSourceValue("foo");
        e.setTargetValue("bar");
        table.getLookupEntry().add(e);
        this.context.getLookupTables().put(table.getName(), table);
        Mapping m = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.LOOKUP);
        this.mapping.getMappings().getMapping().add(m);
        m.setLookupTableName("table");
        this.populateSourceField(m, FieldType.STRING, "foo");
        this.prepareTargetField(m, "/target");
        this.recreateSession();
        this.context.process((AtlasSession)this.session);
        Assertions.assertFalse((boolean)this.session.hasErrors(), (String)this.printAudit((AtlasSession)this.session));
        Assertions.assertEquals((Object)"bar", (Object)this.writer.targets.get("/target"));
    }

    @Test
    public void testDefaultAtlasContext() throws AtlasException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        DefaultAtlasContextFactory factory = DefaultAtlasContextFactory.getInstance();
        factory.init();
        DefaultAtlasContext context = new DefaultAtlasContext(factory, file.toURI());
        context.init();
        Assertions.assertNotNull((Object)context);
        Assertions.assertNotNull((Object)context.getClassName());
        Assertions.assertNotNull((Object)context.getMapping());
        Assertions.assertNotNull((Object)context.getMappingName());
        Assertions.assertNotNull((Object)context.getMappingUri());
        Assertions.assertNotNull((Object)context.getThreadName());
        Assertions.assertNull((Object)context.getVersion());
        Assertions.assertNotNull((Object)context.toString());
        context.setLookupTables(null);
        context.setSourceModules(null);
        context.setTargetModules(null);
        context.setMappingUri(file.toURI());
        Assertions.assertNotNull((Object)new DefaultAtlasContext(file.toURI()));
    }

    @Test
    public void testProcessValidationAtlasException() throws AtlasException {
        Assertions.assertThrows(AtlasException.class, () -> {
            File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
            DefaultAtlasContextFactory factory = DefaultAtlasContextFactory.getInstance();
            factory.init();
            DefaultAtlasContext context = new DefaultAtlasContext(factory, file.toURI());
            context.init();
            AtlasSession mockAtlasSession = (AtlasSession)Mockito.mock(AtlasSession.class);
            context.processValidation(mockAtlasSession);
        });
    }

    @Test
    public void testProcessValidationAtlasExceptionOtherContext() throws AtlasException {
        Assertions.assertThrows(AtlasException.class, () -> {
            File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
            DefaultAtlasContextFactory factory = DefaultAtlasContextFactory.getInstance();
            factory.init();
            DefaultAtlasContext context = new DefaultAtlasContext(factory, file.toURI());
            context.init();
            context.processValidation((AtlasSession)new DefaultAtlasSession(new DefaultAtlasContext(factory, file.toURI())));
        });
    }

    @Test
    public void testCreateSession() throws Exception {
        Assertions.assertNotNull((Object)this.context.createSession(this.mapping));
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        DefaultAtlasContext ctx = new DefaultAtlasContext(file.toURI());
        Assertions.assertNotNull((Object)ctx.createSession());
    }

    @Test
    public void testInit() throws AtlasException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        DefaultAtlasContext ctx = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), file.toURI());
        ctx.init();
        DataSource dataSource = new DataSource();
        dataSource.setUri("URI");
        this.mapping.getDataSource().add(dataSource);
        dataSource = new DataSource();
        dataSource.setUri(null);
        this.mapping.getDataSource().add(dataSource);
        dataSource = new DataSource();
        dataSource.setUri("java:source");
        dataSource.setDataSourceType(DataSourceType.SOURCE);
        dataSource.setId("io.atlasmap.core.DefaultAtlasContext.constants.docId");
        this.mapping.getDataSource().add(dataSource);
        dataSource = new DataSource();
        dataSource.setUri("java:target");
        dataSource.setDataSourceType(DataSourceType.TARGET);
        dataSource.setId("io.atlasmap.core.DefaultAtlasContext.constants.docId");
        this.mapping.getDataSource().add(dataSource);
        dataSource = new DataSource();
        dataSource.setUri("java:target");
        dataSource.setDataSourceType(DataSourceType.TARGET);
        dataSource.setId("io.atlasmap.core.DefaultAtlasContext.constants.docId");
        this.mapping.getDataSource().add(dataSource);
        ctx = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping);
        ctx.getTargetModules().put("io.atlasmap.core.DefaultAtlasContext.constants.docId", new ConstantModule());
        ctx.init();
        Map targetModules = (Map)Mockito.spy(Map.class);
        Mockito.when((Object)targetModules.put((String)ArgumentMatchers.any(String.class), (AtlasModule)ArgumentMatchers.any(AtlasModule.class))).thenThrow(new Throwable[]{new RuntimeException("mockException")});
        ctx.setTargetModules(targetModules);
        ctx.init();
    }

    @Test
    public void testProcessAtlasExceptionUnspported() throws AtlasException {
        Assertions.assertThrows(AtlasException.class, () -> {
            AtlasSession session = (AtlasSession)Mockito.spy(AtlasSession.class);
            this.context.process(session);
        });
    }

    @Test
    public void testProcessAtlasExceptionOtherContext() throws AtlasException {
        Assertions.assertThrows(AtlasException.class, () -> {
            DefaultAtlasContext context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping);
            DefaultAtlasSession session = new DefaultAtlasSession(context);
            new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping).process((AtlasSession)session);
        });
    }

    @Test
    public void testProcess() throws AtlasException {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        Mockito.when((Object)session.getAtlasContext()).thenReturn((Object)this.context);
        AtlasInternalSession.Head head = (AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class);
        Mockito.when((Object)session.head()).thenReturn((Object)head);
        Mockito.when((Object)head.setMapping((Mapping)ArgumentMatchers.any(Mapping.class))).thenReturn((Object)head);
        Mockito.when((Object)head.setLookupTable((LookupTable)ArgumentMatchers.any(LookupTable.class))).thenReturn((Object)head);
        Field headField = (Field)Mockito.mock(ConstantField.class);
        Mockito.when((Object)head.getSourceField()).thenReturn((Object)headField);
        Audits audits = (Audits)Mockito.mock(Audits.class);
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        Validations validations = (Validations)Mockito.mock(Validations.class);
        Mockito.when((Object)session.getValidations()).thenReturn((Object)validations);
        AtlasMapping mapping = (AtlasMapping)Mockito.mock(AtlasMapping.class);
        Mockito.when((Object)session.getMapping()).thenReturn((Object)mapping);
        Mockito.when((Object)session.hasErrors()).thenReturn((Object)true);
        this.context.process((AtlasSession)session);
        Mockito.when((Object)session.hasErrors()).thenReturn((Object)false);
        Mappings mappings = (Mappings)Mockito.mock(Mappings.class);
        Mockito.when((Object)mapping.getMappings()).thenReturn((Object)mappings);
        ArrayList<Collection> baseMappings = new ArrayList<Collection>();
        Collection baseMapping = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)baseMapping.getMappingType()).thenReturn((Object)MappingType.COLLECTION);
        baseMappings.add(baseMapping);
        Mockito.when((Object)mappings.getMapping()).thenReturn(baseMappings);
        Mappings subMappings = (Mappings)Mockito.mock(Mappings.class);
        Mockito.when((Object)baseMapping.getMappings()).thenReturn((Object)subMappings);
        ArrayList<Mapping> baseMappingList = new ArrayList<Mapping>();
        Mapping mappingElement1 = (Mapping)Mockito.mock(Mapping.class);
        ArrayList<ConstantField> sourceFieldList = new ArrayList<ConstantField>();
        ConstantField sourceField = (ConstantField)Mockito.mock(ConstantField.class);
        sourceFieldList.add(sourceField);
        Mockito.when((Object)sourceField.getPath()).thenReturn((Object)"contact.firstName");
        Mockito.when((Object)mappingElement1.getInputField()).thenReturn(sourceFieldList);
        ArrayList<Field> outputFieldList = new ArrayList<Field>();
        Field outputField = (Field)Mockito.mock(Field.class);
        outputFieldList.add(outputField);
        Mockito.when((Object)outputField.getPath()).thenReturn((Object)"contact.firstName");
        Mockito.when((Object)mappingElement1.getOutputField()).thenReturn(outputFieldList);
        Mockito.when((Object)mappingElement1.getMappingType()).thenReturn((Object)MappingType.ALL);
        baseMappingList.add(mappingElement1);
        Mockito.when((Object)subMappings.getMapping()).thenReturn(baseMappingList);
        Mapping mappingElement2 = (Mapping)Mockito.mock(Mapping.class);
        Mockito.when((Object)mappingElement2.getMappingType()).thenReturn((Object)MappingType.ALL);
        baseMappingList.add(mappingElement2);
        ArrayList<ConstantField> sourceFieldList2 = new ArrayList<ConstantField>();
        ConstantField sourceField2 = (ConstantField)Mockito.mock(ConstantField.class);
        sourceFieldList2.add(sourceField2);
        Mockito.when((Object)sourceField2.getPath()).thenReturn((Object)"contact[1]");
        Mockito.when((Object)mappingElement2.getInputField()).thenReturn(sourceFieldList2);
        ConstantModule mockConstantModule = (ConstantModule)Mockito.mock(ConstantModule.class);
        ConstantField clonedField = (ConstantField)Mockito.mock(ConstantField.class);
        Mockito.when((Object)clonedField.getPath()).thenReturn((Object)"cloned[1]");
        Mockito.when((Object)mockConstantModule.cloneField((Field)ArgumentMatchers.any(Field.class))).thenReturn((Object)clonedField);
        ArrayList<ConstantField> mockSourceFieldList = new ArrayList<ConstantField>();
        ConstantField mockSourceField = (ConstantField)Mockito.mock(ConstantField.class);
        mockSourceFieldList.add(mockSourceField);
        Mockito.when((Object)mockSourceField.getPath()).thenReturn((Object)"source[1]");
        Mockito.when((Object)mappingElement2.getInputField()).thenReturn(mockSourceFieldList);
        ArrayList<ConstantField> mockOutputFieldList = new ArrayList<ConstantField>();
        ConstantField mockOutputField = (ConstantField)Mockito.mock(ConstantField.class);
        mockOutputFieldList.add(mockOutputField);
        Mockito.when((Object)mockOutputField.getPath()).thenReturn((Object)"output[1]");
        Mockito.when((Object)mappingElement2.getOutputField()).thenReturn(mockOutputFieldList);
        this.context.getSourceModules().put("ATLAS_CONSTANTS_DOC", mockConstantModule);
        this.context.getTargetModules().put("ATLAS_DEFAULT_TARGET_DOC", mockConstantModule);
        this.context.process((AtlasSession)session);
    }
}

