/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.ActionProcessor;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.Add;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Expression;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.IndexOf;
import io.atlasmap.v2.Prepend;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.Uppercase;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class DefaultAtlasFieldActionsServiceTest {
    private DefaultAtlasFieldActionService fieldActionsService = null;

    @BeforeEach
    public void setUp() {
        this.fieldActionsService = DefaultAtlasFieldActionService.getInstance();
        this.fieldActionsService.init();
    }

    @AfterEach
    public void tearDown() {
        this.fieldActionsService = null;
    }

    @Test
    public void testInit() {
        Assertions.assertNotNull((Object)this.fieldActionsService);
        Assertions.assertNotNull((Object)this.fieldActionsService.listActionDetails());
        Assertions.assertTrue((this.fieldActionsService.listActionDetails().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListActionDetails() {
        Assertions.assertNotNull((Object)this.fieldActionsService);
        List actionDetails = this.fieldActionsService.listActionDetails();
        for (ActionDetail d : actionDetails) {
            if (d.getParameters() == null) continue;
            System.out.println("Action: " + d.getName());
            for (ActionParameter param : d.getParameters().getParameter()) {
                System.out.println("\t param: " + param.getName());
                System.out.println("\t type: " + param.getFieldType().value());
            }
        }
    }

    @Test
    public void testFindActionDetail() throws Exception {
        ActionDetail actionDetail = this.fieldActionsService.findActionDetail((Action)new Prepend(), FieldType.STRING);
        Assertions.assertNotNull((Object)actionDetail);
        System.out.println(new ObjectMapper().writeValueAsString((Object)actionDetail.getActionSchema()));
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.STRING);
        Assertions.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail(new Action(){}, FieldType.STRING);
        Assertions.assertNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), null);
        Assertions.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.STRING);
        Assertions.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.ANY);
        Assertions.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.NONE);
        Assertions.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.BOOLEAN);
        Assertions.assertNotNull((Object)actionDetail);
    }

    @Test
    public void testProcessActionsActionsFieldAtlasConversionException() throws AtlasException {
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        ArrayList<Add> actions = new ArrayList<Add>();
        actions.add(new Add());
        field.setActions(actions);
        Assertions.assertThrows(AtlasConversionException.class, () -> this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field));
    }

    @Test
    public void testProcessActionsActionsField() throws AtlasException {
        SimpleField field = new SimpleField();
        field.setFieldType(FieldType.COMPLEX);
        field.setActions(null);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue(null);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue((Object)0);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setActions(new ArrayList());
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setActions(new ArrayList());
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.getActions().add(new Trim());
        field.setValue((Object)"testString");
        field.setFieldType(FieldType.STRING);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue((Object)8);
        field.setFieldType(FieldType.NUMBER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
    }

    @Test
    public void testprocessActionsActionsObjectFieldTypeAtlasConversionException() throws AtlasException {
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        ArrayList<Add> actions = new ArrayList<Add>();
        actions.add(new Add());
        field.setActions(actions);
        Assertions.assertThrows(AtlasConversionException.class, () -> this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field));
    }

    @Test
    public void testProcessActionWithActionActionDetailObject() throws AtlasException {
        ActionProcessor processor = null;
        String sourceObject = "String";
        Trim action = new Trim();
        processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.STRING);
        Assertions.assertEquals((Object)sourceObject, (Object)processor.process((Action)action, (Object)sourceObject));
        action = new GenerateUUID();
        processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.NONE);
        Assertions.assertNotNull((Object)processor.process((Action)action, (Object)sourceObject));
    }

    @Test
    public void testProcessActionWithActionActionDetailObjectAssignableType() throws AtlasException {
        AbsoluteValue action = new AbsoluteValue();
        Integer sourceObject = Integer.valueOf("1");
        ActionProcessor processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.STRING);
        Assertions.assertEquals((Object)1L, (Object)processor.process((Action)action, (Object)sourceObject));
    }

    @Test
    public void testGetActionDetailByActionName() {
        Assertions.assertNotNull((Object)this.fieldActionsService.getActionDetailByActionName("Add"));
        Assertions.assertNull((Object)this.fieldActionsService.getActionDetailByActionName("AtlasAdd"));
    }

    @Test
    public void testProcessActionAddDays() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        SimpleField field = new SimpleField();
        field.setFieldType(FieldType.DATE_TIME);
        field.setPath("/date");
        ZonedDateTime now = ZonedDateTime.now();
        field.setValue((Object)now);
        field.setActions(new ArrayList());
        AddDays action = new AddDays();
        action.setDays(Integer.valueOf(32));
        field.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)field);
        ZonedDateTime expected = now.plusDays(32L);
        Assertions.assertEquals(ZonedDateTime.class, answer.getValue().getClass());
        ZonedDateTime actual = (ZonedDateTime)answer.getValue();
        Assertions.assertEquals((int)expected.getYear(), (int)actual.getYear());
        Assertions.assertEquals((Object)expected.getMonth(), (Object)actual.getMonth());
        Assertions.assertEquals((int)expected.getDayOfMonth(), (int)actual.getDayOfMonth());
    }

    @Test
    public void testProcessActionForEachCollectionItem() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        FieldGroup fieldGroup = new FieldGroup();
        SimpleField field1 = new SimpleField();
        field1.setPath("/fields<0>");
        field1.setValue((Object)"one");
        fieldGroup.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setPath("/fields<1>");
        field2.setValue((Object)"two");
        fieldGroup.getField().add(field2);
        SimpleField field4 = new SimpleField();
        field4.setPath("/fields<3>");
        field4.setValue((Object)"four");
        fieldGroup.getField().add(field4);
        Uppercase action = new Uppercase();
        fieldGroup.setActions(new ArrayList());
        fieldGroup.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)fieldGroup);
        Assertions.assertEquals(FieldGroup.class, answer.getClass());
        FieldGroup answerGroup = (FieldGroup)answer;
        Assertions.assertEquals((int)3, (int)answerGroup.getField().size());
        Field f = (Field)answerGroup.getField().get(0);
        Assertions.assertEquals((Object)"/fields<0>", (Object)f.getPath());
        Assertions.assertEquals((Object)"ONE", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(1);
        Assertions.assertEquals((Object)"/fields<1>", (Object)f.getPath());
        Assertions.assertEquals((Object)"TWO", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(2);
        Assertions.assertEquals((Object)"/fields<3>", (Object)f.getPath());
        Assertions.assertEquals((Object)"FOUR", (Object)f.getValue());
    }

    @Test
    public void testProcessOldExpressionActionWithRoot() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        FieldGroup root = new FieldGroup();
        FieldGroup fieldGroup = new FieldGroup();
        root.getField().add(fieldGroup);
        fieldGroup.setPath("/fields<>");
        fieldGroup.setCollectionType(CollectionType.LIST);
        SimpleField field1 = new SimpleField();
        field1.setPath("/fields<0>");
        field1.setValue((Object)"one");
        fieldGroup.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setPath("/fields<1>");
        field2.setValue((Object)"two");
        fieldGroup.getField().add(field2);
        SimpleField field3 = new SimpleField();
        field3.setPath("/fields<3>");
        field3.setValue((Object)"four");
        fieldGroup.getField().add(field3);
        Expression action = new Expression();
        action.setExpression("capitalize(${0})");
        root.setActions(new ArrayList());
        root.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)root);
        Assertions.assertEquals(FieldGroup.class, answer.getClass());
        FieldGroup answerGroup = (FieldGroup)answer;
        Assertions.assertEquals((int)3, (int)answerGroup.getField().size());
        Field f = (Field)answerGroup.getField().get(0);
        Assertions.assertEquals((Object)"/$ATLASMAP<0>", (Object)f.getPath());
        Assertions.assertEquals((Object)"One", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(1);
        Assertions.assertEquals((Object)"/$ATLASMAP<1>", (Object)f.getPath());
        Assertions.assertEquals((Object)"Two", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(2);
        Assertions.assertEquals((Object)"/$ATLASMAP<2>", (Object)f.getPath());
        Assertions.assertEquals((Object)"Four", (Object)f.getValue());
    }

    @Test
    public void testProcessOldExpressionActionWithoutRoot() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.setPath("/fields<>");
        fieldGroup.setCollectionType(CollectionType.LIST);
        SimpleField field1 = new SimpleField();
        field1.setPath("/fields<0>");
        field1.setValue((Object)"one");
        fieldGroup.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setPath("/fields<1>");
        field2.setValue((Object)"two");
        fieldGroup.getField().add(field2);
        SimpleField field3 = new SimpleField();
        field3.setPath("/fields<3>");
        field3.setValue((Object)"four");
        fieldGroup.getField().add(field3);
        Expression action = new Expression();
        action.setExpression("capitalize(${0})");
        fieldGroup.setActions(new ArrayList());
        fieldGroup.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)fieldGroup);
        Assertions.assertEquals(FieldGroup.class, answer.getClass());
        FieldGroup answerGroup = (FieldGroup)answer;
        Assertions.assertEquals((int)3, (int)answerGroup.getField().size());
        Field f = (Field)answerGroup.getField().get(0);
        Assertions.assertEquals((Object)"/$ATLASMAP<0>", (Object)f.getPath());
        Assertions.assertEquals((Object)"One", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(1);
        Assertions.assertEquals((Object)"/$ATLASMAP<1>", (Object)f.getPath());
        Assertions.assertEquals((Object)"Two", (Object)f.getValue());
        f = (Field)answerGroup.getField().get(2);
        Assertions.assertEquals((Object)"/$ATLASMAP<2>", (Object)f.getPath());
        Assertions.assertEquals((Object)"Four", (Object)f.getValue());
    }

    @Test
    public void testProcessOldExpressionActionConcatenateCollection() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        SimpleField delimiter = new SimpleField();
        delimiter.setPath("/delim");
        delimiter.setValue((Object)"-");
        FieldGroup list = new FieldGroup();
        list.setPath("/fields<>");
        list.setCollectionType(CollectionType.LIST);
        SimpleField field1 = new SimpleField();
        field1.setPath("/fields<0>");
        field1.setValue((Object)"one");
        list.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setPath("/fields<1>");
        field2.setValue((Object)"two");
        list.getField().add(field2);
        SimpleField field3 = new SimpleField();
        field3.setPath("/fields<2>");
        field3.setValue((Object)"three");
        list.getField().add(field3);
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.getField().add(delimiter);
        fieldGroup.getField().add(list);
        Expression action = new Expression();
        action.setExpression("concatenate(${0}, true, capitalize(${1}))");
        fieldGroup.setActions(new ArrayList());
        fieldGroup.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)fieldGroup);
        Assertions.assertEquals((Object)"$ATLASMAP", (Object)answer.getPath());
        Assertions.assertEquals((Object)"One-Two-Three", (Object)answer.getValue());
    }

    @Test
    public void testProcessOldExpressionActionConcatenateTwoCollections() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        SimpleField delimiter = new SimpleField();
        delimiter.setPath("/delim");
        delimiter.setValue((Object)"-");
        FieldGroup list = new FieldGroup();
        list.setPath("/fields<>");
        list.setCollectionType(CollectionType.LIST);
        SimpleField field1 = new SimpleField();
        field1.setPath("/fields<0>");
        field1.setValue((Object)"one");
        list.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setPath("/fields<1>");
        field2.setValue((Object)"two");
        list.getField().add(field2);
        SimpleField field3 = new SimpleField();
        field3.setPath("/fields<2>");
        field3.setValue((Object)"three");
        list.getField().add(field3);
        FieldGroup list2 = new FieldGroup();
        list2.setPath("/fields2<>");
        list2.setCollectionType(CollectionType.LIST);
        SimpleField field21 = new SimpleField();
        field21.setPath("/fields2<0>");
        field21.setValue((Object)"one");
        list2.getField().add(field21);
        SimpleField field22 = new SimpleField();
        field22.setPath("/fields2<1>");
        field22.setValue((Object)"two");
        list2.getField().add(field22);
        SimpleField field23 = new SimpleField();
        field23.setPath("/fields2<2>");
        field23.setValue((Object)"three");
        list2.getField().add(field23);
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.getField().add(delimiter);
        fieldGroup.getField().add(list);
        fieldGroup.getField().add(list2);
        Expression action = new Expression();
        action.setExpression("concatenate(${0}, true, ${1}, ${2})");
        fieldGroup.setActions(new ArrayList());
        fieldGroup.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)fieldGroup);
        Assertions.assertEquals((Object)"$ATLASMAP", (Object)answer.getPath());
        Assertions.assertEquals((Object)"one-two-three-one-two-three", (Object)answer.getValue());
    }
}

