/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.BaseDefaultAtlasContextTest;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Concatenate;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Expression;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Split;
import io.atlasmap.v2.Uppercase;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultAtlasPreviewContextTest
extends BaseDefaultAtlasContextTest {
    @Test
    public void testProcessPreviewConverter() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"404");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.INTEGER);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals(Integer.class, target.getValue().getClass());
        Assertions.assertEquals((Object)404, (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSourceFieldAction() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"abc");
        ArrayList<Uppercase> actions = new ArrayList<Uppercase>();
        actions.add(new Uppercase());
        source.setActions(actions);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"ABC", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewTargetFieldAction() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.MAP);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"abc");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        ArrayList<Uppercase> actions = new ArrayList<Uppercase>();
        actions.add(new Uppercase());
        target.setActions(actions);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"ABC", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewCombine() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.COMBINE);
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setIndex(Integer.valueOf(0));
        source1.setValue((Object)"1");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setIndex(Integer.valueOf(1));
        source2.setValue((Object)"2");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source1);
        m.getInputField().add(source2);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"1 2", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSeparate() throws AtlasException {
        Mapping m = new Mapping();
        m.setMappingType(MappingType.SEPARATE);
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"1 2");
        SimpleField target1 = new SimpleField();
        target1.setFieldType(FieldType.STRING);
        target1.setIndex(Integer.valueOf(0));
        SimpleField target2 = new SimpleField();
        target2.setFieldType(FieldType.STRING);
        target2.setIndex(Integer.valueOf(1));
        m.getInputField().add(source);
        m.getOutputField().add(target1);
        m.getOutputField().add(target2);
        this.previewContext.processPreview(m);
        target1 = (Field)m.getOutputField().get(0);
        target2 = (Field)m.getOutputField().get(1);
        Assertions.assertEquals((Object)"1", (Object)target1.getValue());
        Assertions.assertEquals((Object)"2", (Object)target2.getValue());
    }

    @Test
    public void testProcessPreviewSourceFieldGroup() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setPath("/one");
        source1.setIndex(Integer.valueOf(0));
        source1.setValue((Object)"one");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/two");
        source2.setIndex(Integer.valueOf(1));
        source2.setValue((Object)"two");
        FieldGroup group = new FieldGroup();
        group.getField().add(source1);
        group.getField().add(source2);
        Expression action = new Expression();
        action.setExpression("${0} + ' and ' + ${1}");
        group.setActions(new ArrayList());
        group.getActions().add(action);
        m.setInputFieldGroup(group);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"one and two", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewConcatenate() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setPath("/one");
        source1.setIndex(Integer.valueOf(1));
        source1.setValue((Object)"one");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/three");
        source2.setIndex(Integer.valueOf(3));
        source2.setValue((Object)"three");
        SimpleField source3 = new SimpleField();
        source3.setFieldType(FieldType.STRING);
        source3.setPath("/five");
        source3.setIndex(Integer.valueOf(5));
        source3.setValue((Object)"five");
        FieldGroup group = new FieldGroup();
        group.getField().add(source1);
        group.getField().add(source2);
        group.getField().add(source3);
        Concatenate action = new Concatenate();
        action.setDelimiter("-");
        action.setDelimitingEmptyValues(Boolean.valueOf(true));
        group.setActions(new ArrayList());
        group.getActions().add(action);
        m.setInputFieldGroup(group);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"-one--three--five", (Object)target.getValue());
    }

    @Test
    public void testProcessActionConcatenateCollectionAndNonCollection() throws Exception {
        Mapping m = new Mapping();
        SimpleField source1 = new SimpleField();
        source1.setFieldType(FieldType.STRING);
        source1.setPath("/list<1>");
        source1.setIndex(Integer.valueOf(1));
        source1.setValue((Object)"one");
        SimpleField source2 = new SimpleField();
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/list<3>");
        source2.setIndex(Integer.valueOf(3));
        source2.setValue((Object)"three");
        SimpleField source3 = new SimpleField();
        source3.setFieldType(FieldType.STRING);
        source3.setPath("/list<5>");
        source3.setIndex(Integer.valueOf(5));
        source3.setValue((Object)"five");
        FieldGroup list = new FieldGroup();
        list.setCollectionType(CollectionType.LIST);
        list.setIndex(Integer.valueOf(0));
        list.setPath("/list<>");
        list.getField().add(source1);
        list.getField().add(source2);
        list.getField().add(source3);
        Capitalize capitalize = new Capitalize();
        list.setActions(new ArrayList());
        list.getActions().add(capitalize);
        SimpleField f = new SimpleField();
        f.setFieldType(FieldType.STRING);
        f.setIndex(Integer.valueOf(1));
        f.setPath("/nc");
        f.setValue((Object)"nc");
        FieldGroup group = new FieldGroup();
        group.getField().add(list);
        group.getField().add(f);
        Concatenate action = new Concatenate();
        action.setDelimiter("-");
        action.setDelimitingEmptyValues(Boolean.valueOf(true));
        group.setActions(new ArrayList());
        group.getActions().add(action);
        m.setInputFieldGroup(group);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        this.previewContext.processPreview(m);
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"-One--Three--Five-nc", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewSplit() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setPath("/source");
        source.setValue((Object)"one two three four");
        source.setActions(new ArrayList());
        Split action = new Split();
        action.setDelimiter(" ");
        source.getActions().add(action);
        m.getInputField().add(source);
        SimpleField target1 = new SimpleField();
        target1.setPath("/target1");
        target1.setIndex(Integer.valueOf(0));
        target1.setFieldType(FieldType.STRING);
        m.getOutputField().add(target1);
        SimpleField target2 = new SimpleField();
        target2.setPath("/target2");
        target2.setIndex(Integer.valueOf(1));
        target2.setFieldType(FieldType.STRING);
        m.getOutputField().add(target2);
        SimpleField target3 = new SimpleField();
        target3.setPath("/target3");
        target3.setIndex(Integer.valueOf(3));
        target3.setFieldType(FieldType.STRING);
        m.getOutputField().add(target3);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target1 = (Field)m.getOutputField().get(0);
        target2 = (Field)m.getOutputField().get(1);
        target3 = (Field)m.getOutputField().get(2);
        Assertions.assertEquals((Object)"one", (Object)target1.getValue());
        Assertions.assertEquals((Object)"two", (Object)target2.getValue());
        Assertions.assertEquals((Object)"four", (Object)target3.getValue());
    }

    @Test
    public void testProcessPreviewSplitCollection() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setPath("/source");
        source.setValue((Object)"one two three four");
        source.setActions(new ArrayList());
        Split action = new Split();
        action.setDelimiter(" ");
        source.getActions().add(action);
        m.getInputField().add(source);
        SimpleField target = new SimpleField();
        target.setCollectionType(CollectionType.LIST);
        target.setFieldType(FieldType.STRING);
        target.setPath("/results<>");
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals(FieldGroup.class, target.getClass());
        FieldGroup targetGroup = (FieldGroup)target;
        Field one = (Field)targetGroup.getField().get(0);
        Field two = (Field)targetGroup.getField().get(1);
        Field three = (Field)targetGroup.getField().get(2);
        Field four = (Field)targetGroup.getField().get(3);
        Assertions.assertEquals((Object)"/results<0>", (Object)one.getPath());
        Assertions.assertEquals((Object)"one", (Object)one.getValue());
        Assertions.assertEquals((Object)"/results<1>", (Object)two.getPath());
        Assertions.assertEquals((Object)"two", (Object)two.getValue());
        Assertions.assertEquals((Object)"/results<2>", (Object)three.getPath());
        Assertions.assertEquals((Object)"three", (Object)three.getValue());
        Assertions.assertEquals((Object)"/results<3>", (Object)four.getPath());
        Assertions.assertEquals((Object)"four", (Object)four.getValue());
        target = new SimpleField();
        target.setCollectionType(CollectionType.NONE);
        target.setPath("/collection<>/result");
        target.setFieldType(FieldType.STRING);
        target.setIndex(Integer.valueOf(0));
        m.getOutputField().clear();
        m.getOutputField().add(target);
        audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals(FieldGroup.class, target.getClass());
        targetGroup = (FieldGroup)target;
        one = (Field)targetGroup.getField().get(0);
        two = (Field)targetGroup.getField().get(1);
        three = (Field)targetGroup.getField().get(2);
        four = (Field)targetGroup.getField().get(3);
        Assertions.assertEquals((Object)"/collection<0>/result", (Object)one.getPath());
        Assertions.assertEquals((Object)"one", (Object)one.getValue());
        Assertions.assertEquals((Object)"/collection<1>/result", (Object)two.getPath());
        Assertions.assertEquals((Object)"two", (Object)two.getValue());
        Assertions.assertEquals((Object)"/collection<2>/result", (Object)three.getPath());
        Assertions.assertEquals((Object)"three", (Object)three.getValue());
        Assertions.assertEquals((Object)"/collection<3>/result", (Object)four.getPath());
        Assertions.assertEquals((Object)"four", (Object)four.getValue());
    }

    @Test
    public void testProcessPreviewSourceCollection() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setIndex(Integer.valueOf(0));
        source.setPath("/this<>/is/collection");
        source.setValue((Object)"one");
        source.setActions(new ArrayList());
        Concatenate action = new Concatenate();
        action.setDelimiter(" ");
        source.getActions().add(action);
        m.getInputField().add(source);
        SimpleField target = new SimpleField();
        target.setIndex(Integer.valueOf(0));
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"one", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewExpression() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.DOUBLE);
        source.setPath("/sourceDouble");
        source.setValue((Object)99.0);
        m.getInputField().add(source);
        SimpleField source2 = new SimpleField();
        source2.setDocId("source2");
        source2.setFieldType(FieldType.DOUBLE);
        source2.setPath("/sourceDouble");
        source2.setValue((Object)1.0);
        m.setExpression("${source:/sourceDouble} + ${source2:/sourceDouble}");
        m.getInputField().add(source2);
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"100.0", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewExpressionNullValue() throws AtlasException {
        Mapping m = new Mapping();
        FieldGroup fg = new FieldGroup();
        m.setInputFieldGroup(fg);
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.DOUBLE);
        source.setPath("/sourceDouble");
        fg.getField().add(source);
        SimpleField source2 = new SimpleField();
        source2.setDocId("source2");
        source2.setFieldType(FieldType.DOUBLE);
        source2.setPath("/sourceDouble");
        source2.setValue((Object)1.0);
        fg.getField().add(source2);
        m.setExpression("IF(ISEMPTY(${source:/sourceDouble}), ${source2:/sourceDouble}, ${source:/sourceDouble})");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"1.0", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewFieldTypes() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setFieldType(FieldType.STRING);
        source.setValue((Object)"foo");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getInputField().add(source);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"foo", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewFilterSelect() throws Exception {
        Mapping m = new Mapping();
        FieldGroup fg = new FieldGroup();
        fg.setDocId("source");
        fg.setPath("/addressList<>");
        m.setInputFieldGroup(fg);
        FieldGroup fgc = new FieldGroup();
        fgc.setDocId("source");
        fgc.setPath("/addressList<0>");
        fg.getField().add(fgc);
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.STRING);
        source.setPath("/addressList<0>/city");
        source.setValue((Object)"Bolton");
        fgc.getField().add(source);
        SimpleField source2 = new SimpleField();
        source2.setDocId("source");
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/addressList<0>/state");
        source2.setValue((Object)"MA");
        fgc.getField().add(source2);
        m.setExpression("SELECT(FILTER(${source:/addressList<>}, ${/city} != 'Boston'), ${state})");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"MA", (Object)target.getValue());
    }

    @Test
    public void testProcessPreviewRepeatCount() throws Exception {
        Mapping m = new Mapping();
        FieldGroup fg = new FieldGroup();
        m.setInputFieldGroup(fg);
        FieldGroup fgc = new FieldGroup();
        fgc.setDocId("source");
        fgc.setFieldType(FieldType.STRING);
        fgc.setCollectionType(CollectionType.LIST);
        fgc.setName("city");
        fgc.setPath("/addressList<>/city");
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.STRING);
        source.setPath("/addressList<0>/city");
        source.setName("city");
        source.setValue((Object)"Bolton");
        fgc.getField().add(source);
        fg.getField().add(fgc);
        ConstantField source2 = new ConstantField();
        source2.setDocId("ATLAS_CONSTANTS_DOC");
        source2.setFieldType(FieldType.STRING);
        source2.setPath("/test");
        source2.setName("test");
        source2.setValue((Object)"testVal");
        fg.getField().add(source2);
        m.setExpression(String.format("REPEAT(COUNT(${source:/addressList<>/city}), ${%s:/test})", "ATLAS_CONSTANTS_DOC"));
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        target.setDocId("target");
        target.setPath("/addressList<>/city");
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        FieldGroup targetGroup = (FieldGroup)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"/addressList<>/city", (Object)targetGroup.getPath());
        Assertions.assertEquals((int)1, (int)targetGroup.getField().size());
        Assertions.assertEquals((Object)"testVal", (Object)((Field)targetGroup.getField().get(0)).getValue());
    }

    @Test
    public void testProcessPreviewExpressionBoolean() throws AtlasException {
        Mapping m = new Mapping();
        SimpleField source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.BOOLEAN);
        source.setPath("/sourceBoolean");
        source.setValue((Object)"true");
        m.getInputField().add(source);
        m.setExpression("IF(${source:/sourceBoolean}, 'YES', 'NO')");
        SimpleField target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        Audits audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"YES", (Object)target.getValue());
        m = new Mapping();
        source = new SimpleField();
        source.setDocId("source");
        source.setFieldType(FieldType.BOOLEAN);
        source.setPath("/sourceBoolean");
        source.setValue((Object)"true");
        m.getInputField().add(source);
        m.setExpression("IF (${source:/sourceBoolean} == true, 'YES', 'NO')");
        target = new SimpleField();
        target.setFieldType(FieldType.STRING);
        m.getOutputField().add(target);
        audits = this.previewContext.processPreview(m);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size(), (String)this.printAudit(audits));
        target = (Field)m.getOutputField().get(0);
        Assertions.assertEquals((Object)"YES", (Object)target.getValue());
    }
}

