/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.DoubleConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DoubleConverterTest {
    private DoubleConverter converter = new DoubleConverter();

    @Test
    public void convertToBoolean() {
        Double df = 0.0;
        Double dt = 1.0;
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertNotNull((Object)b);
        Assertions.assertTrue((boolean)b);
        b = this.converter.toBoolean(df);
        Assertions.assertNotNull((Object)b);
        Assertions.assertFalse((boolean)b);
    }

    @Test
    public void convertToBooleanNull() {
        Double df = null;
        Boolean b = this.converter.toBoolean(df);
        Assertions.assertNull((Object)b);
    }

    @Test
    public void convertToBooleanNegative() {
        Double dt = -1.0;
        Boolean b = this.converter.toBoolean(dt);
        Assertions.assertTrue((boolean)b);
    }

    @Test
    public void convertToByte() throws Exception {
        Double df = 0.0;
        Byte value = 0;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte(df));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toByte(Double.valueOf(Double.MAX_VALUE)));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() throws Exception {
        Double df = 0.0;
        Character c = this.converter.toCharacter(df);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)0, (int)c.charValue());
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Double df = null;
        Character c = this.converter.toCharacter(df);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToCharacterMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = 65556.0;
            this.converter.toCharacter(df);
        });
    }

    @Test
    public void convertToCharacterMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = -1.0;
            this.converter.toCharacter(df);
        });
    }

    @Test
    public void convertToDouble() {
        Double df = 0.0;
        Double d = this.converter.toDouble(df);
        Assertions.assertNotNull((Object)d);
        Assertions.assertNotSame((Object)df, (Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Double df = null;
        Double d = this.converter.toDouble(df);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() throws Exception {
        Double df = 0.0;
        Float f = this.converter.toFloat(df);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.0, (double)f.floatValue(), (double)0.0);
        df = 0.15;
        f = this.converter.toFloat(df);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)0.15, (double)f.floatValue(), (double)1.0);
    }

    @Test
    public void convertToFloatNull() throws Exception {
        Double df = null;
        Float f = this.converter.toFloat(df);
        Assertions.assertNull((Object)f);
    }

    @Test
    public void convertToFloatExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = Double.MAX_VALUE;
            this.converter.toFloat(df);
        });
    }

    @Test
    public void convertToFloatExceptionMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = Double.MIN_VALUE;
            this.converter.toFloat(df);
        });
    }

    @Test
    public void convertToInteger() throws Exception {
        Double df = 0.15;
        Integer i = this.converter.toInteger(df);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)0.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() throws Exception {
        Double df = null;
        Integer i = this.converter.toInteger(df);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToIntegerExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = Double.MAX_VALUE;
            this.converter.toInteger(df);
        });
    }

    @Test
    public void convertToLong() throws Exception {
        Double df = 0.0;
        Long l = this.converter.toLong(df);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)0.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() throws Exception {
        Double df = null;
        Long l = this.converter.toLong(df);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToLongExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = Double.MAX_VALUE;
            this.converter.toLong(df);
        });
    }

    @Test
    public void convertToShort() throws Exception {
        Double df = 0.0;
        Short s = this.converter.toShort(df);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((double)0.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Double df = null;
        Short s = this.converter.toShort(df);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToShortExceptionMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Double df = Double.MAX_VALUE;
            this.converter.toShort(df);
        });
    }

    @Test
    public void convertToString() {
        Double df = 0.0;
        String s = this.converter.toString(df);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"0.0".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Double df = null;
        String s = this.converter.toString(df);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<DoubleConverter> aClass = DoubleConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assertions.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.DOUBLE) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

