/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.NotEmptyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NotEmptyValidatorTest
extends BaseValidatorTest {
    private NotEmptyValidator validator;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.validator = new NotEmptyValidator(ValidationScope.MAPPING, "Collection should not be empty");
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.setUp();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assertions.assertTrue((boolean)this.validator.supports(Map.class));
        Assertions.assertTrue((boolean)this.validator.supports(List.class));
        Assertions.assertTrue((boolean)this.validator.supports(Set.class));
        Assertions.assertTrue((boolean)this.validator.supports(Collection.class));
    }

    @Test
    public void testUnsupported() {
        Assertions.assertFalse((boolean)this.validator.supports(HashMap.class));
    }

    @Test
    public void testValidate() {
        ArrayList<String> stuff = new ArrayList<String>();
        stuff.add("one");
        stuff.add("two");
        this.validator.validate(stuff, this.validations, "testValidate-1");
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        this.validator.validate(stuff, this.validations, "testValidate-2", ValidationStatus.WARN);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        ArrayList stuff = new ArrayList();
        this.validator.validate(stuff, this.validations, "testValidateInvalid");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Integer)new Integer(1), (Integer)new Integer(this.validationHelper.getCount()));
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)((Validation)this.validationHelper.getValidation().get(0)).getScope());
        Assertions.assertEquals((Object)"testValidateInvalid", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }
}

