/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvFieldWriter
implements AtlasFieldWriter {
    private final CsvConfig csvConfig;
    private Document document;

    public CsvFieldWriter(CsvConfig csvConfig) {
        this.csvConfig = csvConfig;
        this.document = new Document();
        this.document.setFields(new Fields());
    }

    public Document getDocument() {
        return this.document;
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        Field sourceField = session.head().getSourceField();
        if (sourceField instanceof FieldGroup) {
            FieldGroup targetFieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
            for (Field sourceSubField : ((FieldGroup)sourceField).getField()) {
                CsvField targetCsvField = (CsvField)targetField;
                CsvField targetCsvSubField = new CsvField();
                AtlasModelFactory.copyField((Field)targetField, (Field)targetCsvSubField, (boolean)false);
                targetCsvSubField.setColumn(targetCsvField.getColumn());
                targetCsvSubField.setValue(sourceSubField.getValue());
                targetFieldGroup.getField().add(targetCsvSubField);
            }
            targetField = targetFieldGroup;
            session.head().setTargetField((Field)targetFieldGroup);
        } else {
            targetField.setValue(sourceField.getValue());
        }
        this.document.getFields().getField().add(targetField);
    }

    public String toCsv() throws AtlasException {
        CSVFormat csvFormat = this.csvConfig.newCsvFormat();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFormat);
            List fields = this.document.getFields().getField();
            if (this.csvConfig.isFirstRecordAsHeader()) {
                ArrayList<String> headers = new ArrayList<String>();
                for (Field field : fields) {
                    headers.add(field.getName());
                }
                printer.printRecord(headers);
            }
            int recordsCount = ((FieldGroup)fields.get(0)).getField().size();
            for (int i = 0; i < recordsCount; ++i) {
                ArrayList<String> values = new ArrayList<String>();
                for (Field field : fields) {
                    FieldGroup fieldGroup = (FieldGroup)field;
                    CsvField csvField = (CsvField)fieldGroup.getField().get(i);
                    if (csvField.getColumn() != null) {
                        values.set(csvField.getColumn(), csvField.getValue().toString());
                        continue;
                    }
                    values.add(csvField.getValue().toString());
                }
                printer.printRecord(values);
            }
            writer.flush();
            String csv = out.toString();
            return csv;
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

