/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.v2.CsvComplexType;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.csv.v2.CsvFields;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvFieldReader
implements AtlasFieldReader {
    private final CsvConfig csvConfig;
    private InputStream document;

    public CsvFieldReader(CsvConfig csvConfig) {
        this.csvConfig = csvConfig;
    }

    public void setDocument(InputStream inputStream) {
        this.document = inputStream != null && !inputStream.markSupported() ? new BufferedInputStream(inputStream) : inputStream;
    }

    public Field read(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (this.document == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)field.getDocId(), (String)String.format("Cannot read field '%s' of document '%s', document is null", field.getPath(), field.getDocId()), (String)field.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return field;
        }
        if (field == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        if (!(field instanceof CsvField) && !(field instanceof FieldGroup)) {
            throw new AtlasException(String.format("Unsupported field type '%s'", field.getClass()));
        }
        if (field instanceof FieldGroup) {
            FieldGroup fieldGroup = (FieldGroup)field;
            List fields = fieldGroup.getField();
            FieldGroup readFieldGroup = AtlasModelFactory.copyFieldGroup((FieldGroup)fieldGroup);
            for (Field subField : fields) {
                if (subField instanceof FieldGroup) {
                    subField = (Field)((FieldGroup)subField).getField().get(0);
                }
                if (!(subField instanceof CsvField)) continue;
                Field readSubField = this.readFields((CsvField)subField);
                readFieldGroup.getField().add(readSubField);
            }
            session.head().setSourceField((Field)readFieldGroup);
            return readFieldGroup;
        }
        Field readField = this.readFields((CsvField)field);
        session.head().setSourceField(readField);
        return readField;
    }

    private Field readFields(CsvField field) throws AtlasException {
        ArrayList<CsvField> fields = new ArrayList<CsvField>();
        CsvField csvField = field;
        CSVFormat csvFormat = this.csvConfig.newCsvFormat();
        try {
            this.document.mark(Integer.MAX_VALUE);
            CSVParser parser = csvFormat.parse((Reader)new InputStreamReader(this.document));
            AtlasPath atlasPath = new AtlasPath(csvField.getPath());
            int i = 0;
            Integer fieldIndex = atlasPath.getRootSegment().getCollectionIndex();
            if (fieldIndex != null) {
                for (CSVRecord record : parser) {
                    if (i == fieldIndex) {
                        CsvField newField = CsvField.cloneOf((CsvField)csvField);
                        newField.setIndex(null);
                        String value = csvField.getColumn() != null ? record.get(csvField.getColumn().intValue()) : record.get(csvField.getName());
                        newField.setValue((Object)value);
                        fields.add(newField);
                        break;
                    }
                    ++i;
                }
            } else {
                for (CSVRecord record : parser) {
                    CsvField collectionField = CsvField.cloneOf((CsvField)csvField);
                    collectionField.setIndex(null);
                    String value = csvField.getColumn() != null ? record.get(csvField.getColumn().intValue()) : record.get(csvField.getName());
                    collectionField.setValue((Object)value);
                    AtlasPath collectionFieldPath = new AtlasPath(collectionField.getPath());
                    collectionFieldPath.setCollectionIndex(0, Integer.valueOf(i));
                    collectionField.setPath(collectionFieldPath.toString());
                    fields.add(collectionField);
                    ++i;
                }
            }
            this.document.reset();
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        FieldGroup fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
        fieldGroup.getField().addAll(fields);
        return fieldGroup;
    }

    public Document readSchema() throws AtlasException {
        CsvField field;
        CSVParser parser;
        CSVFormat csvFormat = this.csvConfig.newCsvFormat();
        try {
            this.document.mark(Integer.MAX_VALUE);
            parser = csvFormat.parse((Reader)new InputStreamReader(this.document));
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        ArrayList<CsvField> fields = new ArrayList<CsvField>();
        if (this.csvConfig.isFirstRecordAsHeader()) {
            for (String headerName : parser.getHeaderNames()) {
                field = new CsvField();
                field.setName(headerName);
                field.setPath("/<>/" + headerName);
                field.setFieldType(FieldType.STRING);
                fields.add(field);
            }
        } else {
            CSVRecord record = (CSVRecord)parser.iterator().next();
            for (int i = 0; i < record.size(); ++i) {
                field = new CsvField();
                if (parser.getHeaderNames() != null && parser.getHeaderNames().size() > i) {
                    field.setName((String)parser.getHeaderNames().get(i));
                } else {
                    field.setColumn(Integer.valueOf(i));
                    field.setName(String.valueOf(i));
                }
                field.setPath("/<>/" + field.getName());
                field.setFieldType(FieldType.STRING);
                fields.add(field);
            }
        }
        try {
            this.document.reset();
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
        CsvFields csvFields = new CsvFields();
        csvFields.getCsvField().addAll(fields);
        CsvComplexType csvComplexType = new CsvComplexType();
        csvComplexType.setFieldType(FieldType.COMPLEX);
        csvComplexType.setCollectionType(CollectionType.LIST);
        csvComplexType.setPath("/<>");
        csvComplexType.setName("");
        csvComplexType.setCsvFields(csvFields);
        Fields documentFields = new Fields();
        documentFields.getField().add(csvComplexType);
        Document document = new Document();
        document.setFields(documentFields);
        return document;
    }
}

