/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.dfdl.module;

import io.atlasmap.api.AtlasException;
import io.atlasmap.dfdl.core.DfdlSchemaResolver;
import io.atlasmap.dfdl.module.DfdlValidationService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.xml.module.XmlModule;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Map;
import org.apache.daffodil.japi.Compiler;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.UnparseResult;
import org.apache.daffodil.japi.infoset.InfosetInputter;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@AtlasModuleDetail(name="DfdlModule", uri="atlas:dfdl", modes={"SOURCE", "TARGET"}, dataFormats={"dfdl"}, configPackages={"io.atlasmap.dfdl.v2"})
public class DfdlModule
extends XmlModule {
    private static final Logger LOG = LoggerFactory.getLogger(DfdlModule.class);
    private DfdlSchemaResolver schemaResolver;
    private DataProcessor daffodil;

    public void init() throws AtlasException {
        super.init();
        this.schemaResolver = new DfdlSchemaResolver(this.getClassLoader());
        String type = this.getUriDataType();
        HashMap options = new HashMap();
        for (Map.Entry e : this.getUriParameters().entrySet()) {
            if (!((String)e.getKey()).startsWith("atlas.dfdl")) continue;
            options.put(e.getKey(), e.getValue());
        }
        try {
            URI dfdl = this.schemaResolver.resolve(type, options);
            Compiler compiler = Daffodil.compiler();
            ProcessorFactory factory = compiler.compileSource(dfdl);
            if (factory.isError()) {
                StringBuffer buf = new StringBuffer("Faield ti initialize DFDL module: [");
                for (Diagnostic d : factory.getDiagnostics()) {
                    buf.append(d.getMessage()).append("; ");
                }
                buf.append("]");
                throw new AtlasException(buf.toString());
            }
            this.daffodil = factory.onPath("/");
        }
        catch (Exception e) {
            throw new AtlasException("Failed to initialize DFDL module:", (Throwable)e);
        }
    }

    protected DfdlValidationService createValidationService() {
        DfdlValidationService dfdlValidationService = new DfdlValidationService(this.getConversionService(), this.getFieldActionService());
        dfdlValidationService.setMode(this.getMode());
        dfdlValidationService.setDocId(this.getDocId());
        return dfdlValidationService;
    }

    protected Document convertToXmlDocument(String source, boolean namespaced) throws AtlasException {
        W3CDOMInfosetOutputter output = new W3CDOMInfosetOutputter();
        ParseResult result = this.daffodil.parse(new InputSourceDataInputStream(source.getBytes()), (InfosetOutputter)output);
        if (result.isError()) {
            StringBuffer buf = new StringBuffer("DFDL document read error");
            result.getDiagnostics().forEach(d -> buf.append("; ").append(d.getMessage()));
            throw new AtlasException(buf.toString());
        }
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace("DFDL: converted to XML >>> " + this.getXmlIOHelper().writeDocumentToString(false, (Node)output.getResult()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return output.getResult();
    }

    protected String convertFromXmlDocument(Document xml) throws AtlasException {
        ByteArrayOutputStream bos;
        W3CDOMInfosetInputter input;
        UnparseResult result;
        if (LOG.isTraceEnabled()) {
            try {
                LOG.trace("DFDL: converting from XML >>> " + this.getXmlIOHelper().writeDocumentToString(false, (Node)xml));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((result = this.daffodil.unparse((InfosetInputter)(input = new W3CDOMInfosetInputter(xml)), Channels.newChannel(bos = new ByteArrayOutputStream()))).isError()) {
            StringBuffer buf = new StringBuffer("DFDL document read error");
            result.getDiagnostics().forEach(d -> buf.append("; ").append(d.getMessage()));
            throw new AtlasException(buf.toString());
        }
        return new String(bos.toByteArray());
    }
}

