/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.expression.internal;

import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.internal.BinaryExpression;
import io.atlasmap.expression.internal.ComparisonExpression;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;

public abstract class ArithmeticExpression
extends BinaryExpression {
    protected static final int INTEGER = 1;
    protected static final int LONG = 2;
    protected static final int DOUBLE = 3;
    boolean convertStringExpressions = ComparisonExpression.CONVERT_STRING_EXPRESSIONS.get() != null;

    public ArithmeticExpression(Expression left, Expression right) {
        super(left, right);
    }

    public static Expression createPlus(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Field evaluate(Field lfield, Field rfield) {
                Object lvalue = lfield.getValue();
                Object rvalue = rfield.getValue();
                if (lvalue instanceof String) {
                    String text = (String)lvalue;
                    String answer = text + rvalue;
                    return AtlasModelFactory.wrapWithField((Object)answer);
                }
                return AtlasModelFactory.wrapWithField((Object)this.plus(this.asNumber(lvalue), this.asNumber(rvalue)));
            }

            @Override
            public String getExpressionSymbol() {
                return "+";
            }
        };
    }

    public static Expression createMinus(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Field evaluate(Field lfield, Field rfield) {
                Object lvalue = lfield.getValue();
                Object rvalue = rfield.getValue();
                return AtlasModelFactory.wrapWithField((Object)this.minus(this.asNumber(lvalue), this.asNumber(rvalue)));
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static Expression createMultiply(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Field evaluate(Field lfield, Field rfield) {
                Object lvalue = lfield.getValue();
                Object rvalue = rfield.getValue();
                return AtlasModelFactory.wrapWithField((Object)this.multiply(this.asNumber(lvalue), this.asNumber(rvalue)));
            }

            @Override
            public String getExpressionSymbol() {
                return "*";
            }
        };
    }

    public static Expression createDivide(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Field evaluate(Field lfield, Field rfield) {
                Object lvalue = lfield.getValue();
                Object rvalue = rfield.getValue();
                return AtlasModelFactory.wrapWithField((Object)this.divide(this.asNumber(lvalue), this.asNumber(rvalue)));
            }

            @Override
            public String getExpressionSymbol() {
                return "/";
            }
        };
    }

    public static Expression createMod(Expression left, Expression right) {
        return new ArithmeticExpression(left, right){

            @Override
            protected Field evaluate(Field lfield, Field rfield) {
                Object lvalue = lfield.getValue();
                Object rvalue = rfield.getValue();
                return AtlasModelFactory.wrapWithField((Object)this.mod(this.asNumber(lvalue), this.asNumber(rvalue)));
            }

            @Override
            public String getExpressionSymbol() {
                return "%";
            }
        };
    }

    protected Number plus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return new Integer(left.intValue() + right.intValue());
            }
            case 2: {
                return new Long(left.longValue() + right.longValue());
            }
        }
        return new Double(left.doubleValue() + right.doubleValue());
    }

    protected Number minus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return new Integer(left.intValue() - right.intValue());
            }
            case 2: {
                return new Long(left.longValue() - right.longValue());
            }
        }
        return new Double(left.doubleValue() - right.doubleValue());
    }

    protected Number multiply(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return new Integer(left.intValue() * right.intValue());
            }
            case 2: {
                return new Long(left.longValue() * right.longValue());
            }
        }
        return new Double(left.doubleValue() * right.doubleValue());
    }

    protected Number divide(Number left, Number right) {
        return new Double(left.doubleValue() / right.doubleValue());
    }

    protected Number mod(Number left, Number right) {
        return new Double(left.doubleValue() % right.doubleValue());
    }

    private int numberType(Number left, Number right) {
        if (this.isDouble(left) || this.isDouble(right)) {
            return 3;
        }
        if (left instanceof Long || right instanceof Long) {
            return 2;
        }
        return 1;
    }

    private boolean isDouble(Number n) {
        return n instanceof Float || n instanceof Double;
    }

    protected Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (this.convertStringExpressions && value instanceof String) {
            String v = (String)value;
            try {
                if (v.contains(".")) {
                    return new Double(v);
                }
                return new Long(v);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Cannot convert value: " + value + " into a number");
            }
        }
        throw new RuntimeException("Cannot convert value: " + value + " into a number");
    }

    @Override
    public Field evaluate(ExpressionContext message) throws ExpressionException {
        Field lfield = this.left.evaluate(message);
        if (lfield == null || lfield.getValue() == null) {
            return AtlasModelFactory.wrapWithField(null);
        }
        Field rfield = this.right.evaluate(message);
        if (rfield == null || rfield.getValue() == null) {
            return null;
        }
        return this.evaluate(lfield, rfield);
    }

    protected abstract Field evaluate(Field var1, Field var2);
}

