/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.java.inspect.ClassHelper;
import io.atlasmap.java.inspect.JdkPackages;
import io.atlasmap.java.inspect.StringUtil;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentJavaFieldReader
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentJavaFieldReader.class);
    private AtlasConversionService conversionService;
    private Object sourceDocument;

    public void read(AtlasInternalSession session) throws AtlasException {
        try {
            io.atlasmap.v2.Field sourceField = session.head().getSourceField();
            Method getter = null;
            if (sourceField.getFieldType() == null && (sourceField instanceof JavaField || sourceField instanceof JavaEnumField)) {
                getter = this.resolveGetMethod(this.sourceDocument, sourceField, false);
                if (getter == null) {
                    LOG.warn("Unable to auto-detect sourceField type p=" + sourceField.getPath() + " d=" + sourceField.getDocId());
                    return;
                }
                Class<?> returnType = getter.getReturnType();
                sourceField.setFieldType(this.conversionService.fieldTypeFromClass(returnType));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Auto-detected sourceField type p=" + sourceField.getPath() + " t=" + sourceField.getFieldType());
                }
            }
            this.populateSourceFieldValue(sourceField, this.sourceDocument, getter);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed input field sPath=" + sourceField.getPath() + " sV=" + sourceField.getValue() + " sT=" + sourceField.getFieldType() + " docId: " + sourceField.getDocId());
            }
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    private void populateSourceFieldValue(io.atlasmap.v2.Field field, Object source, Method m) throws Exception {
        Method getter = m;
        Object parentObject = source;
        AtlasPath atlasPath = new AtlasPath(field.getPath());
        if (atlasPath.hasParent()) {
            parentObject = ClassHelper.parentObjectForPath(source, atlasPath, true);
        }
        getter = getter == null ? this.resolveGetMethod(parentObject, field, !parentObject.equals(source)) : getter;
        Object sourceValue = null;
        if (getter != null) {
            sourceValue = getter.invoke(parentObject, new Object[0]);
        }
        if (sourceValue == null) {
            sourceValue = this.getValueFromMemberField(source, atlasPath.getLastSegment());
        }
        if (sourceValue != null && (this.conversionService.isPrimitive(sourceValue.getClass()).booleanValue() || this.conversionService.isBoxedPrimitive(sourceValue.getClass()).booleanValue())) {
            sourceValue = this.conversionService.copyPrimitive(sourceValue);
        }
        field.setValue(sourceValue);
    }

    private Method resolveGetMethod(Object sourceObject, io.atlasmap.v2.Field field, boolean objectIsParent) throws AtlasException {
        Object parentObject = sourceObject;
        AtlasPath atlasPath = new AtlasPath(field.getPath());
        Method getter = null;
        if (atlasPath.hasParent() && !objectIsParent) {
            parentObject = ClassHelper.parentObjectForPath(sourceObject, atlasPath, true);
        }
        if (parentObject == null) {
            return null;
        }
        List<Class<?>> classTree = this.resolveMappableClasses(parentObject.getClass());
        for (Class<?> clazz : classTree) {
            try {
                if (field instanceof JavaField && ((JavaField)field).getGetMethod() != null) {
                    getter = clazz.getMethod(((JavaField)field).getGetMethod(), new Class[0]);
                    getter.setAccessible(true);
                    return getter;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (String m : Arrays.asList("get", "is")) {
                String getterMethod = m + this.capitalizeFirstLetter(atlasPath.getLastSegment());
                try {
                    getter = clazz.getMethod(getterMethod, new Class[0]);
                    getter.setAccessible(true);
                    return getter;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return null;
    }

    private Object getValueFromMemberField(Object source, String fieldName) throws Exception {
        try {
            Field reflectField = source.getClass().getField(fieldName);
            reflectField.setAccessible(true);
            return reflectField.get(source);
        }
        catch (NoSuchFieldException nsfe) {
            LOG.error(nsfe.getMessage(), (Throwable)nsfe);
            return null;
        }
    }

    private List<Class<?>> resolveMappableClasses(Class<?> className) {
        ArrayList classTree = new ArrayList();
        classTree.add(className);
        Class<?> superClazz = className.getSuperclass();
        while (superClazz != null) {
            if (JdkPackages.contains(superClazz.getPackage().getName()).booleanValue()) {
                superClazz = null;
                continue;
            }
            classTree.add(superClazz);
            superClazz = superClazz.getSuperclass();
        }
        return classTree;
    }

    private String capitalizeFirstLetter(String sentence) {
        if (StringUtil.isEmpty(sentence)) {
            return sentence;
        }
        if (sentence.length() == 1) {
            return String.valueOf(sentence.charAt(0)).toUpperCase();
        }
        return String.valueOf(sentence.charAt(0)).toUpperCase() + sentence.substring(1);
    }

    public void setDocument(Object sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

