/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.java.inspect.ClassHelper;
import io.atlasmap.java.inspect.JdkPackages;
import io.atlasmap.java.inspect.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaWriterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JavaWriterUtil.class);
    protected AtlasConversionService conversionService = null;

    public JavaWriterUtil(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object instantiateObject(Class<?> clz, AtlasPath.SegmentContext segmentContext, boolean createWrapperArray) throws AtlasException {
        try {
            if (Modifier.isAbstract(clz.getModifiers()) && !clz.isPrimitive() && !clz.isArray()) {
                throw new AtlasException("Cannot instantiate object, class is abstract: " + clz.getName() + ", segment: " + segmentContext);
            }
            if (createWrapperArray && AtlasPath.isArraySegment((String)segmentContext.getSegment())) {
                int size = AtlasPath.indexOfSegment((String)segmentContext.getSegment()) + 1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Instantiating array of size " + size + " for class '" + clz.getName() + "', segment: " + segmentContext);
                }
                return Array.newInstance(clz, size);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Instantiating object for class '" + clz.getName() + "', segment: " + segmentContext);
            }
            return clz.newInstance();
        }
        catch (Exception e) {
            throw new AtlasException("Could not instantiate class: " + clz.getName() + ", segment: " + segmentContext.getSegmentPath(), (Throwable)e);
        }
    }

    public Object getObjectFromParent(io.atlasmap.v2.Field field, Object parentObject, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        Object childObject;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving child '" + segmentContext.getSegmentPath() + "'.\n\tparentObject: " + parentObject);
        }
        if (parentObject == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot find child '" + segmentContext.getSegmentPath() + "', parent is null.");
            }
            return null;
        }
        String cleanedSegment = AtlasPath.cleanPathSegment((String)segmentContext.getSegment());
        List<String> getters = ClassHelper.getterMethodNames(cleanedSegment);
        Method getterMethod = null;
        for (String getter : getters) {
            try {
                getterMethod = ClassHelper.detectGetterMethod(parentObject.getClass(), getter);
                break;
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Looking for getter for '" + segmentContext.getSegmentPath() + " on this class: " + parentObject.getClass().getName(), (Throwable)e);
            }
        }
        if (getterMethod == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to detect getter method for: " + segmentContext.getSegment() + " from " + segmentContext.getSegmentPath() + " on parent: " + parentObject);
            }
            return null;
        }
        getterMethod.setAccessible(true);
        try {
            childObject = getterMethod.invoke(parentObject, new Object[0]);
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            if (childObject == null) {
                LOG.debug("Could not find child object for path: " + segmentContext.getSegmentPath());
            } else {
                LOG.debug("Found child object for path '" + segmentContext.getSegmentPath() + "': " + childObject);
            }
        }
        return childObject;
    }

    public void setObjectOnParent(io.atlasmap.v2.Field javaField, AtlasPath.SegmentContext segmentContext, Object parentObject, Object childObject) throws AtlasException {
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting object for path:'" + javaField.getPath() + "'.\n\tchildObject: " + childObject + "\n\tparentObject: " + parentObject);
            }
            AtlasPath pathUtil = new AtlasPath(javaField.getPath());
            try {
                Class<?> childClass = childObject == null ? null : childObject.getClass();
                Method targetMethod = this.resolveSetMethod(parentObject, segmentContext, childClass);
                Object targetObject = parentObject;
                if (childObject == null && this.conversionService.isPrimitive(targetMethod.getParameterTypes()[0]).booleanValue()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not setting null value for primitive method paramter for path:'" + javaField.getPath() + "'.\n\tchildObject: " + childObject + "\n\tparentObject: " + parentObject);
                    }
                    return;
                }
                if (targetMethod != null) {
                    targetMethod.invoke(targetObject, childObject);
                    javaField.setValue(childObject);
                    break block8;
                }
                try {
                    Field field = targetObject.getClass().getField(pathUtil.getLastSegment());
                    field.setAccessible(true);
                    field.set(targetObject, childObject);
                    javaField.setValue(field.get(targetObject));
                }
                catch (NoSuchFieldException nsfe) {
                    throw new AtlasException("Unable to find matting setter method or field for path: " + javaField.getPath() + " on parentObject: " + parentObject.getClass().getName());
                }
            }
            catch (Exception e) {
                String parentClassName = parentObject == null ? null : parentObject.getClass().getName();
                String childClassName = childObject == null ? null : childObject.getClass().getName();
                throw new AtlasException("Unable to set value for path: " + javaField.getPath() + " parentObject: " + parentClassName + " childObject: " + childClassName, (Throwable)e);
            }
        }
    }

    protected Method resolveSetMethod(Object sourceObject, AtlasPath.SegmentContext segmentContext, Class<?> targetType) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String setterMethodName = "set" + JavaWriterUtil.capitalizeFirstLetter(AtlasPath.cleanPathSegment((String)segmentContext.getSegment()));
        List<Class<?>> classTree = this.resolveMappableClasses(sourceObject.getClass());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + classTree.size() + " mappable classes for class '" + sourceObject.getClass().getName() + "': " + classTree);
        }
        Method m = null;
        for (Class<?> clazz : classTree) {
            block11: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Looking for setter '" + setterMethodName + "' on this class: " + clazz.getName());
                }
                try {
                    m = ClassHelper.detectSetterMethod(clazz, setterMethodName, targetType);
                    if (m != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found setter '" + setterMethodName + "' on this class: " + clazz.getName());
                        }
                        return m;
                    }
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("Did not find setter '" + setterMethodName + "' on this class: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!this.conversionService.isPrimitive(targetType).booleanValue() && !this.conversionService.isBoxedPrimitive(targetType).booleanValue()) continue;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Looking for boxed setter '" + setterMethodName + "' on this class: " + clazz.getName());
                }
                if ((m = ClassHelper.detectSetterMethod(clazz, setterMethodName, this.conversionService.boxOrUnboxPrimitive(targetType))) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found setter '" + setterMethodName + "' on this class: " + clazz.getName());
                }
                return m;
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Did not find setter '" + setterMethodName + "' on this class: " + clazz.getName(), (Throwable)e);
            }
        }
        throw new NoSuchMethodException("Unable to resolve expected setter '" + setterMethodName + "' for path: " + segmentContext.getSegmentPath() + ", on object: " + sourceObject);
    }

    public static String capitalizeFirstLetter(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            return String.valueOf(string.charAt(0)).toUpperCase();
        }
        return String.valueOf(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    protected List<Class<?>> resolveMappableClasses(Class<?> className) {
        ArrayList classTree = new ArrayList();
        classTree.add(className);
        Class<?> superClazz = className.getSuperclass();
        while (superClazz != null) {
            if (JdkPackages.contains(superClazz.getPackage().getName()).booleanValue()) {
                superClazz = null;
                continue;
            }
            classTree.add(superClazz);
            superClazz = superClazz.getSuperclass();
        }
        return classTree;
    }
}

