/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.java.inspect.ClassHelper;
import io.atlasmap.java.inspect.JdkPackages;
import io.atlasmap.java.inspect.StringUtil;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentJavaFieldReader
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentJavaFieldReader.class);
    private AtlasConversionService conversionService;
    private Object sourceDocument;

    public void read(AtlasInternalSession session) throws AtlasException {
        try {
            io.atlasmap.v2.Field sourceField = session.head().getSourceField();
            Method getter = null;
            if (sourceField.getFieldType() == null && (sourceField instanceof JavaField || sourceField instanceof JavaEnumField)) {
                getter = this.resolveGetMethod(this.sourceDocument, sourceField);
                if (getter == null) {
                    AtlasUtil.addAudit((AtlasSession)session, (String)sourceField.getDocId(), (String)String.format("Unable to auto-detect sourceField type path=%s docId=%s", sourceField.getPath(), sourceField.getDocId()), (String)sourceField.getPath(), (AuditStatus)AuditStatus.WARN, null);
                    return;
                }
                Class<?> returnType = getter.getReturnType();
                sourceField.setFieldType(this.conversionService.fieldTypeFromClass(returnType));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Auto-detected sourceField type p=" + sourceField.getPath() + " t=" + sourceField.getFieldType());
                }
            }
            this.populateSourceFieldValue(session, sourceField, this.sourceDocument, getter);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed input field sPath=" + sourceField.getPath() + " sV=" + sourceField.getValue() + " sT=" + sourceField.getFieldType() + " docId: " + sourceField.getDocId());
            }
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    private void populateSourceFieldValue(AtlasInternalSession session, io.atlasmap.v2.Field field, Object source, Method m) throws Exception {
        Method getter = m;
        Object parentObject = source;
        AtlasPath atlasPath = new AtlasPath(field.getPath());
        Object sourceValue = null;
        if (atlasPath.isRoot().booleanValue()) {
            sourceValue = source;
        } else {
            if (atlasPath.hasParent()) {
                parentObject = ClassHelper.parentObjectForPath(source, atlasPath, true);
            }
            Method method = getter = getter == null ? this.resolveGetMethod(source, field) : getter;
            if (getter != null) {
                sourceValue = getter.invoke(parentObject, new Object[0]);
            }
        }
        if (sourceValue == null) {
            String cleanedLastSegment = AtlasPath.cleanPathSegment((String)atlasPath.getLastSegment());
            sourceValue = this.getValueFromMemberField(session, parentObject, cleanedLastSegment);
        }
        if (sourceValue != null && (this.conversionService.isPrimitive((sourceValue = this.extractFromCollection(session, sourceValue, atlasPath)).getClass()).booleanValue() || this.conversionService.isBoxedPrimitive(sourceValue.getClass()).booleanValue())) {
            sourceValue = this.conversionService.copyPrimitive(sourceValue);
        }
        field.setValue(sourceValue);
    }

    private Method resolveGetMethod(Object sourceObject, io.atlasmap.v2.Field field) throws AtlasException {
        Object parentObject = sourceObject;
        AtlasPath atlasPath = new AtlasPath(field.getPath());
        Method getter = null;
        if (atlasPath.hasParent()) {
            parentObject = ClassHelper.parentObjectForPath(sourceObject, atlasPath, true);
        }
        if (parentObject == null) {
            return null;
        }
        List<Class<?>> classTree = this.resolveMappableClasses(parentObject.getClass());
        for (Class<?> clazz : classTree) {
            try {
                if (field instanceof JavaField && ((JavaField)field).getGetMethod() != null) {
                    getter = clazz.getMethod(((JavaField)field).getGetMethod(), new Class[0]);
                    getter.setAccessible(true);
                    return getter;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (String m : Arrays.asList("get", "is")) {
                String cleanedLastSegment = AtlasPath.cleanPathSegment((String)atlasPath.getLastSegment());
                String getterMethod = m + this.capitalizeFirstLetter(cleanedLastSegment);
                try {
                    getter = clazz.getMethod(getterMethod, new Class[0]);
                    getter.setAccessible(true);
                    return getter;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return null;
    }

    private Object getValueFromMemberField(AtlasInternalSession session, Object source, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        Field reflectField = this.lookupJavaField(source, fieldName);
        if (reflectField != null) {
            reflectField.setAccessible(true);
            return reflectField.get(source);
        }
        io.atlasmap.v2.Field sourceField = session.head().getSourceField();
        AtlasUtil.addAudit((AtlasSession)session, (String)sourceField.getDocId(), (String)String.format("Field '%s' not found on object '%s'", fieldName, source), (String)sourceField.getPath(), (AuditStatus)AuditStatus.ERROR, null);
        return null;
    }

    private List<Class<?>> resolveMappableClasses(Class<?> className) {
        ArrayList classTree = new ArrayList();
        classTree.add(className);
        Class<?> superClazz = className.getSuperclass();
        while (superClazz != null) {
            if (JdkPackages.contains(superClazz.getPackage().getName()).booleanValue()) {
                superClazz = null;
                continue;
            }
            classTree.add(superClazz);
            superClazz = superClazz.getSuperclass();
        }
        return classTree;
    }

    private Field lookupJavaField(Object source, String fieldName) {
        for (Class<?> targetClazz = source.getClass(); targetClazz != Object.class; targetClazz = targetClazz.getSuperclass()) {
            try {
                return targetClazz.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                e.getMessage();
                continue;
            }
        }
        return null;
    }

    private String capitalizeFirstLetter(String sentence) {
        if (StringUtil.isEmpty(sentence)) {
            return sentence;
        }
        if (sentence.length() == 1) {
            return String.valueOf(sentence.charAt(0)).toUpperCase();
        }
        return String.valueOf(sentence.charAt(0)).toUpperCase() + sentence.substring(1);
    }

    private Object extractFromCollection(AtlasInternalSession session, Object source, AtlasPath atlasPath) {
        if (source == null) {
            return null;
        }
        String lastSegment = atlasPath.getLastSegment();
        if (!AtlasPath.isCollectionSegment((String)lastSegment).booleanValue() || !atlasPath.isIndexedCollection().booleanValue()) {
            return source;
        }
        Integer index = atlasPath.getCollectionIndex(atlasPath.getLastSegment());
        if (AtlasPath.isArraySegment((String)lastSegment)) {
            return Array.get(source, index);
        }
        if (AtlasPath.isListSegment((String)lastSegment)) {
            return ((Collection)Collection.class.cast(source)).toArray()[index];
        }
        if (AtlasPath.isMapSegment((String)lastSegment)) {
            String key = index.toString();
            return ((Map)Map.class.cast(source)).get(key);
        }
        io.atlasmap.v2.Field sourceField = session.head().getSourceField();
        AtlasUtil.addAudit((AtlasSession)session, (String)sourceField.getDocId(), (String)String.format("Ignoring unknown collection type in path '%s'", sourceField.getPath()), (String)sourceField.getPath(), (AuditStatus)AuditStatus.WARN, null);
        return source;
    }

    public void setDocument(Object sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

