/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.core.JavaWriterUtil;
import io.atlasmap.java.core.TargetValueConverter;
import io.atlasmap.java.inspect.ClassHelper;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupTable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentJavaFieldWriter
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentJavaFieldWriter.class);
    private Object rootObject = null;
    private Map<String, Class<?>> classesForFields = new HashMap();
    private JavaWriterUtil writerUtil = new JavaWriterUtil((AtlasConversionService)DefaultAtlasConversionService.getInstance());
    private List<String> processedPaths = new LinkedList<String>();
    private TargetValueConverter converter;
    private AtlasConversionService conversionService;

    public DocumentJavaFieldWriter(AtlasConversionService conversion) {
        this.conversionService = conversion;
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        LookupTable lookupTable = session.head().getLookupTable();
        io.atlasmap.v2.Field sourceField = session.head().getSourceField();
        io.atlasmap.v2.Field targetField = session.head().getTargetField();
        try {
            String targetFieldClassName;
            if (targetField == null) {
                throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
            }
            String string = targetFieldClassName = targetField instanceof JavaField ? ((JavaField)targetField).getClassName() : ((JavaEnumField)targetField).getClassName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing field: " + targetField);
                LOG.debug("Field type: " + targetField.getFieldType());
                LOG.debug("Field path: " + targetField.getPath());
                LOG.debug("Field value: " + targetField.getValue());
                LOG.debug("Field className: " + targetFieldClassName);
            }
            this.processedPaths.add(targetField.getPath());
            AtlasPath path = new AtlasPath(targetField.getPath());
            Object parentObject = this.rootObject;
            boolean segmentIsComplexSegment = true;
            for (AtlasPath.SegmentContext segmentContext : path.getSegmentContexts(true)) {
                boolean segmentIsLastSegment;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now processing segment: " + segmentContext);
                    LOG.debug("Parent object is currently: " + this.writeDocumentToString(false, parentObject));
                }
                if ("/".equals(segmentContext.getSegmentPath())) {
                    if (this.rootObject == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Creating root node: " + segmentContext);
                        }
                        this.rootObject = this.createParentObject(targetField, parentObject, segmentContext);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Root node already exists, skipping segment: " + segmentContext);
                    }
                    parentObject = this.rootObject;
                    continue;
                }
                boolean bl = segmentIsLastSegment = segmentContext.getNext() == null;
                if (segmentIsLastSegment) {
                    if (targetField.getFieldType() == null && targetFieldClassName != null && targetField instanceof JavaField) {
                        FieldType fieldTypeFromClass = this.conversionService.fieldTypeFromClass(targetFieldClassName);
                        targetField.setFieldType(fieldTypeFromClass);
                    }
                    segmentIsComplexSegment = FieldType.COMPLEX.equals((Object)targetField.getFieldType());
                    if (targetField instanceof JavaEnumField) {
                        segmentIsComplexSegment = false;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    if (segmentIsComplexSegment) {
                        LOG.debug("Now processing complex segment: " + segmentContext);
                    } else if (targetField instanceof JavaEnumField) {
                        LOG.debug("Now processing field enum value segment: " + segmentContext);
                    } else {
                        LOG.debug("Now processing field value segment: " + segmentContext);
                    }
                }
                if (segmentIsComplexSegment) {
                    Object childObject = this.findChildObject(targetField, segmentContext, parentObject);
                    if (childObject == null) {
                        childObject = this.createParentObject(targetField, parentObject, segmentContext);
                    }
                    parentObject = childObject;
                    continue;
                }
                if (AtlasPath.isCollectionSegment((String)segmentContext.getSegment()).booleanValue()) {
                    parentObject = this.findOrCreateOrExpandParentCollectionObject(targetField, parentObject, segmentContext);
                }
                Object value = this.converter.convert(session, lookupTable, sourceField, parentObject, targetField);
                this.addChildObject(targetField, segmentContext, parentObject, value);
            }
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error occured while writing field: " + targetField.getPath(), t);
            }
            if (t instanceof AtlasException) {
                throw (AtlasException)t;
            }
            throw new AtlasException(t);
        }
    }

    private Object findChildObject(io.atlasmap.v2.Field field, AtlasPath.SegmentContext segmentContext, Object parentObject) throws AtlasException {
        Object childObject;
        String parentSegment;
        if (parentObject == null) {
            if (this.rootObject != null && segmentContext.getSegmentPath().equals("/")) {
                return this.rootObject;
            }
            return null;
        }
        String segment = segmentContext.getSegment();
        String string = parentSegment = segmentContext.getPrev() == null ? null : segmentContext.getPrev().getSegment();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for child object '" + segment + "' in parent '" + parentSegment + "': " + this.writeDocumentToString(false, parentObject));
        }
        if ((childObject = this.writerUtil.getObjectFromParent(field, parentObject, segmentContext)) != null && AtlasPath.isCollectionSegment((String)segment).booleanValue()) {
            if (!this.collectionHasRoomForIndex(childObject, segmentContext)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found child collection '" + segment + "' (" + childObject.getClass().getName() + ") in parent '" + parentSegment + "', but it doesn't have room for the segment's index. Parent Object: " + this.writeDocumentToString(false, parentObject));
                }
                return null;
            }
            childObject = this.getCollectionItem(childObject, segmentContext);
        }
        if (LOG.isDebugEnabled()) {
            if (childObject == null) {
                LOG.debug("Could not find child object '" + segment + "' in parent '" + parentSegment + "'.");
            } else {
                LOG.debug("Found child object '" + segment + "' in parent '" + parentSegment + "', class: " + childObject.getClass().getName() + ", child object: " + this.writeDocumentToString(false, childObject));
            }
        }
        return childObject;
    }

    private Object createParentObject(io.atlasmap.v2.Field field, Object parentObject, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        String segment = segmentContext.getSegment();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating parent object: " + segmentContext);
        }
        Object childObject = null;
        if (AtlasPath.isCollectionSegment((String)segment).booleanValue()) {
            Object collectionObject;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking for collection wrapper child for " + segmentContext + " on parent: " + parentObject);
            }
            if ((childObject = this.getCollectionItem(collectionObject = this.findOrCreateOrExpandParentCollectionObject(field, parentObject, segmentContext), segmentContext)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not find child object in collection, creating it.");
                }
                childObject = this.createObject(field, segmentContext, parentObject, false);
                this.addChildObject(field, segmentContext, collectionObject, childObject);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Child object inside collection wrapper for segment '" + segment + "': " + this.writeDocumentToString(false, childObject));
            }
        } else {
            childObject = this.createObject(field, segmentContext, parentObject, false);
            this.addChildObject(field, segmentContext, parentObject, childObject);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created child object for segment '" + segment + "': " + this.writeDocumentToString(true, childObject));
        }
        return childObject;
    }

    private Object findOrCreateOrExpandParentCollectionObject(io.atlasmap.v2.Field field, Object parentObject, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        Object collectionObject;
        String segment = segmentContext.getSegment();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for collection wrapper child for " + segmentContext + " on parent: " + parentObject);
        }
        if ((collectionObject = this.writerUtil.getObjectFromParent(field, parentObject, segmentContext)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot find pre-existing child collection for segment '" + segment + "', creating the collection.");
            }
            collectionObject = this.createCollectionWrapperObject(field, segmentContext, parentObject);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collection wrapper child object for segment '" + segment + "': " + this.writeDocumentToString(false, collectionObject));
        }
        collectionObject = this.expandCollectionToFitItem(field, collectionObject, segmentContext, parentObject);
        this.addChildObject(field, segmentContext, parentObject, collectionObject);
        return collectionObject;
    }

    private Object expandCollectionToFitItem(io.atlasmap.v2.Field field, Object obj, AtlasPath.SegmentContext segmentContext, Object parentObject) throws AtlasException {
        Object collectionObject = obj;
        String segment = segmentContext.getSegment();
        if (!this.collectionHasRoomForIndex(collectionObject, segmentContext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collection is not large enough for segment '" + segment + "', expanding the collection.");
            }
            int index = AtlasPath.indexOfSegment((String)segment);
            if (collectionObject instanceof List) {
                List list = (List)collectionObject;
                while (list.size() < index + 1) {
                    list.add(null);
                }
            } else {
                if (collectionObject instanceof Map) {
                    throw new AtlasException("FIXME: Cannot yet handle adding children to maps");
                }
                if (collectionObject.getClass().isArray() && Array.getLength(collectionObject) < index + 1) {
                    Object newArray = this.createObject(field, segmentContext, parentObject, true);
                    for (int i = 0; i < Array.getLength(collectionObject); ++i) {
                        Array.set(newArray, i, Array.get(collectionObject, i));
                    }
                    collectionObject = newArray;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished expanding collection: " + collectionObject);
            }
        }
        return collectionObject;
    }

    private Object createCollectionWrapperObject(io.atlasmap.v2.Field field, AtlasPath.SegmentContext segmentContext, Object parentObject) throws AtlasException {
        String segment = segmentContext.getSegment();
        if (AtlasPath.isArraySegment((String)segment)) {
            return this.createObject(field, segmentContext, parentObject, true);
        }
        if (AtlasPath.isListSegment((String)segment)) {
            return this.writerUtil.instantiateObject(LinkedList.class, segmentContext, false);
        }
        if (AtlasPath.isMapSegment((String)segment)) {
            return this.writerUtil.instantiateObject(HashMap.class, segmentContext, false);
        }
        throw new AtlasException("Can't create collection object for segment: " + segment);
    }

    private Class<?> getClassForField(io.atlasmap.v2.Field field, AtlasPath.SegmentContext segmentContext, Object parentObject, boolean unwrapCollectionType) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up class to use for segment: " + segmentContext + "\n\tparentObject: " + parentObject);
        }
        Class<?> clz = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for configured class for field: " + field + ".");
        }
        String className = null;
        if (field instanceof JavaField) {
            className = ((JavaField)field).getClassName();
        } else if (field instanceof JavaEnumField) {
            className = ((JavaEnumField)field).getClassName();
        }
        if (className != null) {
            try {
                clz = className == null ? null : Class.forName(className);
            }
            catch (Exception e) {
                throw new AtlasException("Could not find class for '" + className + "', for segment: " + segmentContext + ", on field: " + field, (Throwable)e);
            }
        }
        if (clz == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't find class on field. Looking for configured class for segment: " + segmentContext + ".");
            }
            String normalizedSegment = AtlasPath.removeCollectionIndexes((String)segmentContext.getSegmentPath());
            clz = this.classesForFields.get(normalizedSegment);
        }
        Type clzType = null;
        if (clz == null) {
            Method m;
            block17: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Couldn't find configured class for segment: " + segmentContext + ", looking up getter method.");
                }
                m = null;
                try {
                    String methodName = "get" + JavaWriterUtil.capitalizeFirstLetter(AtlasPath.cleanPathSegment((String)segmentContext.getSegment()));
                    m = ClassHelper.detectGetterMethod(parentObject.getClass(), methodName);
                }
                catch (NoSuchMethodException e) {
                    if (!LOG.isDebugEnabled()) break block17;
                    LOG.debug("Couldn't find getter method for segment: " + segmentContext, (Throwable)e);
                }
            }
            clz = m == null ? null : m.getReturnType();
            clzType = m.getGenericReturnType();
        }
        if (clz == null) {
            throw new AtlasException("Could not create object, can't find class to instantiate for segment: " + segmentContext);
        }
        if (unwrapCollectionType) {
            clz = this.unwrapCollectionType(field, segmentContext, parentObject, clz, clzType);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found class '" + clz.getName() + "' to use for segment: " + segmentContext);
        }
        return clz;
    }

    private Class<?> unwrapCollectionType(io.atlasmap.v2.Field field, AtlasPath.SegmentContext segmentContext, Object parentObject, Class<?> clz, Type clzType) throws AtlasException {
        Class<Object> answer = clz;
        if (answer.isArray()) {
            Class<?> oldClass = answer;
            answer = answer.getComponentType();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unwrapped type '" + answer.getName() + "' from wrapper array type '" + oldClass.getName() + "'.");
            }
        } else if (Collection.class.isAssignableFrom(answer)) {
            Class<?> oldClass = answer;
            answer = null;
            String cleanedSegment = AtlasPath.cleanPathSegment((String)segmentContext.getSegment());
            if (clzType instanceof Class) {
                answer = Object.class;
            } else if (clzType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)clzType;
                String typeName = pt.getActualTypeArguments()[0].getTypeName();
                try {
                    answer = typeName == null ? null : Class.forName(typeName);
                }
                catch (Exception e) {
                    throw new AtlasException("Could not find class for '" + typeName + "', for segment: " + segmentContext + ", on field: " + field, (Throwable)e);
                }
            } else if (answer == null) {
                for (Class<?> parentClass = parentObject.getClass(); parentClass != Object.class && answer == null; parentClass = parentClass.getSuperclass()) {
                    answer = this.findClassOfNamedField(parentClass, cleanedSegment);
                }
            }
            if (answer == null) {
                throw new AtlasException("Could not unwrap list collection's generic type for segment: " + segmentContext);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unwrapped type '" + answer.getName() + "' from wrapper list type '" + oldClass.getName() + "'.");
            }
        }
        return answer;
    }

    private Class<?> findClassOfNamedField(Class<?> clazz, String name) {
        for (Field declaredField : clazz.getDeclaredFields()) {
            if (!name.equals(declaredField.getName())) continue;
            if (declaredField.getGenericType() == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping field '{}' on class '{}', the field isn't generic", (Object)declaredField.getName(), (Object)clazz.getName());
                continue;
            }
            ParameterizedType paramType = (ParameterizedType)declaredField.getGenericType();
            String typeName = paramType.getActualTypeArguments()[0].getTypeName();
            try {
                if (typeName == null) continue;
                return Class.forName(typeName);
            }
            catch (Exception e) {
                LOG.warn("Could not load class '{}' for field '{}' on class '{}': {}", new Object[]{typeName, name, clazz.getName(), e.getMessage()});
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private Object createObject(io.atlasmap.v2.Field javaField, AtlasPath.SegmentContext segmentContext, Object parentObject, boolean createWrapperArray) throws AtlasException {
        Class<?> clazz = this.getClassForField(javaField, segmentContext, parentObject, true);
        return this.writerUtil.instantiateObject(clazz, segmentContext, createWrapperArray);
    }

    private Object getCollectionItem(Object collection, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        String segment = segmentContext.getSegment();
        int index = AtlasPath.indexOfSegment((String)segment);
        if (AtlasPath.isArraySegment((String)segment)) {
            return Array.get(collection, index);
        }
        if (AtlasPath.isListSegment((String)segment)) {
            return ((List)collection).get(index);
        }
        if (AtlasPath.isMapSegment((String)segment)) {
            throw new AtlasException("Maps are currently unhandled for segment: " + segment);
        }
        throw new AtlasException("Cannot determine collection type from segment: " + segment);
    }

    private boolean collectionHasRoomForIndex(Object collection, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        boolean result;
        String segment = segmentContext.getSegment();
        int index = AtlasPath.indexOfSegment((String)segment);
        int size = this.getCollectionSize(collection);
        boolean bl = result = size > index;
        if (LOG.isDebugEnabled()) {
            LOG.debug("collectionHasRoomForIndex: " + result + ", size: " + size + ", index: " + index);
        }
        return result;
    }

    private int getCollectionSize(Object collection) throws AtlasException {
        if (collection instanceof List) {
            return ((List)collection).size();
        }
        if (collection instanceof Map) {
            return ((Map)collection).size();
        }
        if (collection.getClass().isArray()) {
            return Array.getLength(collection);
        }
        throw new AtlasException("Cannot determine collection size for: " + collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addChildObject(io.atlasmap.v2.Field field, AtlasPath.SegmentContext segmentContext, Object parentObject, Object childObject) throws AtlasException {
        boolean parentIsCollection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding child object for segment: " + segmentContext + "\n\tparentObject: " + parentObject + "\n\tchild: " + childObject);
        }
        if (this.rootObject == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting root object: " + childObject);
            }
            this.rootObject = childObject;
            return;
        }
        boolean bl = parentIsCollection = parentObject instanceof Collection || parentObject.getClass().isArray();
        if (parentIsCollection) {
            String segment = segmentContext.getSegment();
            int index = AtlasPath.indexOfSegment((String)segment);
            if (parentObject instanceof List) {
                List list = (List)parentObject;
                if (index >= list.size()) {
                    throw new AtlasException("Cannot fit item in list, list size: " + list.size() + ", item index: " + index + ", segment: " + segmentContext);
                }
                list.set(index, childObject);
            } else {
                if (parentObject instanceof Map) {
                    throw new AtlasException("FIXME: Cannot yet handle adding children to maps");
                }
                if (!parentObject.getClass().isArray()) throw new AtlasException("Cannot determine collection type for: " + parentObject);
                if (index >= Array.getLength(parentObject)) {
                    throw new AtlasException("Cannot fit item in array, array size: " + Array.getLength(parentObject) + ", item index: " + index + ", segment: " + segmentContext);
                }
                try {
                    Array.set(parentObject, index, childObject);
                }
                catch (Exception e) {
                    String parentClass = parentObject == null ? null : parentObject.getClass().getName();
                    String childClass = childObject == null ? null : childObject.getClass().getName();
                    throw new AtlasException("Could not set child class '" + childClass + "' on parent '" + parentClass + "' for: " + segmentContext, (Throwable)e);
                }
            }
        } else {
            this.writerUtil.setObjectOnParent(field, segmentContext, parentObject, childObject);
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("Finished adding child object for segment: " + segmentContext + "\n\tparentObject: " + parentObject + "\n\t: " + childObject);
    }

    private String writeDocumentToString(boolean stripSpaces, Object object) throws AtlasException {
        try {
            if (object == null) {
                return "";
            }
            String result = object.toString();
            if (stripSpaces) {
                result = result.replaceAll("\n|\r", "");
                result = result.replaceAll("> *?<", "><");
            }
            return result;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Object getRootObject() {
        return this.rootObject;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    public void setTargetValueConverter(TargetValueConverter converter) {
        this.converter = converter;
    }
}

