/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.java.inspect.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassHelper {
    public static List<String> getterMethodNames(String fieldName) {
        ArrayList<String> opts = new ArrayList<String>();
        opts.add(ClassHelper.getMethodNameFromFieldName(fieldName));
        opts.add(ClassHelper.isMethodNameFromFieldName(fieldName));
        return opts;
    }

    public static String getMethodNameFromFieldName(String fieldName) {
        return "get" + StringUtil.capitalizeFirstLetter(fieldName);
    }

    public static String isMethodNameFromFieldName(String fieldName) {
        return "is" + StringUtil.capitalizeFirstLetter(fieldName);
    }

    public static Method detectGetterMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != 0) continue;
            return method;
        }
        throw new NoSuchMethodException(String.format("No matching getter method for class=%s method=%s", clazz.getName(), methodName));
    }

    public static Method detectSetterMethod(Class<?> clazz, String methodName, Class<?> paramType) throws NoSuchMethodException {
        String paramTypeClassName;
        Method[] methods;
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterCount() != 1) continue;
            candidates.add(method);
        }
        String string = paramTypeClassName = paramType == null ? null : paramType.getName();
        if (candidates.size() == 0) {
            throw new NoSuchMethodException(String.format("No matching setter found for class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
        }
        if (paramType != null) {
            for (Method candidate : candidates) {
                if (!candidate.getParameterTypes()[0].isAssignableFrom(paramType)) continue;
                return candidate;
            }
            throw new NoSuchMethodException(String.format("No matching setter found for class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
        }
        if (candidates.size() == 1) {
            return (Method)candidates.get(0);
        }
        Method getter = null;
        Class<?> returnType = null;
        for (String prefix : Arrays.asList("get", "is")) {
            try {
                getter = ClassHelper.detectGetterMethod(clazz, methodName.replace("set", prefix));
                returnType = getter.getReturnType();
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        for (Method candidate : candidates) {
            Class<?> candidateReturnType = candidate.getParameterTypes()[0];
            if (!(returnType == null ? candidateReturnType == null : returnType.isAssignableFrom(candidateReturnType))) continue;
            return candidate;
        }
        throw new NoSuchMethodException(String.format("Unable to auto-detect setter class=%s method=%s paramType=%s", clazz.getName(), methodName, paramTypeClassName));
    }

    public static Object parentObjectForPath(Object targetObject, AtlasPath pathUtil, boolean skipCollectionWrapper) throws AtlasException {
        try {
            if (targetObject == null) {
                return null;
            }
            if (pathUtil == null) {
                return targetObject;
            }
            if (!pathUtil.hasParent() && !pathUtil.hasCollection()) {
                return targetObject;
            }
            Object parentObject = targetObject;
            AtlasPath parentPath = pathUtil.getLastSegmentParentPath();
            if (parentPath == null) {
                parentPath = pathUtil;
            }
            for (String segment : parentPath.getSegments()) {
                List<String> getters = ClassHelper.getterMethodNames(AtlasPath.cleanPathSegment((String)segment));
                Method getterMethod = null;
                for (String getter : getters) {
                    try {
                        getterMethod = ClassHelper.detectGetterMethod(parentObject.getClass(), getter);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                if (getterMethod == null) {
                    throw new NoSuchMethodException("Unable to detect getter method for " + segment);
                }
                getterMethod.setAccessible(true);
                parentObject = getterMethod.invoke(parentObject, new Object[0]);
                if (!skipCollectionWrapper) continue;
                if (AtlasPath.isListSegment((String)segment) && pathUtil.isIndexedCollection().booleanValue()) {
                    int index = AtlasPath.indexOfSegment((String)segment);
                    parentObject = ((List)parentObject).get(index);
                    continue;
                }
                if (!AtlasPath.isArraySegment((String)segment)) continue;
                int index = AtlasPath.indexOfSegment((String)segment);
                parentObject = Array.get(parentObject, index);
            }
            return parentObject;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

