/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.java.core.ClassHelper;
import io.atlasmap.java.core.accessor.JavaChildAccessor;
import io.atlasmap.java.core.accessor.RootAccessor;
import io.atlasmap.java.v2.AtlasJavaModelFactory;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFieldReader
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFieldReader.class);
    private AtlasConversionService conversionService;
    private Object sourceDocument;

    public Field read(AtlasInternalSession session) throws AtlasException {
        try {
            Field field = session.head().getSourceField();
            if (this.sourceDocument == null) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Unable to read sourceField (path=%s),  document (docId=%s) is null", field.getPath(), field.getDocId()), (AuditStatus)AuditStatus.ERROR, null);
            }
            AtlasPath path = new AtlasPath(field.getPath());
            List<Field> fields = this.getFieldsForPath(session, this.sourceDocument, field, path, 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed input field sPath=" + field.getPath() + " sV=" + field.getValue() + " sT=" + field.getFieldType() + " docId: " + field.getDocId());
            }
            if (path.hasCollection() && !path.isIndexedCollection()) {
                FieldGroup fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
                fieldGroup.getField().addAll(fields);
                session.head().setSourceField((Field)fieldGroup);
                return fieldGroup;
            }
            if (fields.size() == 1) {
                field.setValue(fields.get(0).getValue());
                return field;
            }
            return field;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    private List<Field> getFieldsForPath(AtlasInternalSession session, Object source, Field field, AtlasPath path, int depth) throws AtlasException {
        JavaChildAccessor childAccessor;
        ArrayList<Field> fields = new ArrayList<Field>();
        List segments = path.getSegments(true);
        if (source == null) {
            return fields;
        }
        if (segments.size() < depth) {
            throw new AtlasException(String.format("depth '%s' exceeds segment size '%s'", depth, segments.size()));
        }
        if (segments.size() == depth) {
            Field newField;
            if (field instanceof FieldGroup && field.getFieldType() == FieldType.COMPLEX) {
                FieldGroup group = (FieldGroup)field;
                this.populateChildFields(source, group, path);
                newField = group;
            } else {
                newField = AtlasJavaModelFactory.cloneJavaField((Field)field, (boolean)true);
                if (source != null && (this.conversionService.isPrimitive(source.getClass()).booleanValue() || this.conversionService.isBoxedPrimitive(source.getClass()).booleanValue())) {
                    source = this.conversionService.copyPrimitive(source);
                }
                newField.setValue(source);
                newField.setIndex(null);
            }
            fields.add(newField);
            return fields;
        }
        AtlasPath.SegmentContext segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
        if (depth == 0 && segments.size() > 1 && segmentContext.getCollectionType() == CollectionType.NONE) {
            segmentContext = (AtlasPath.SegmentContext)segments.get(++depth);
        }
        if ((childAccessor = this.getAccessorForSegment(session, source, field, path, segmentContext)) == null || childAccessor.getRawValue() == null) {
            return fields;
        }
        if (segmentContext.getCollectionType() == CollectionType.NONE) {
            List<Field> childFields = this.getFieldsForPath(session, childAccessor.getValue(), field, path, depth + 1);
            fields.addAll(childFields);
            return fields;
        }
        if (segmentContext.getCollectionIndex() != null) {
            Object indexItem = childAccessor.getValueAt(segmentContext.getCollectionIndex());
            List<Field> childFields = this.getFieldsForPath(session, indexItem, field, path, depth + 1);
            fields.addAll(childFields);
        } else {
            List<?> items = childAccessor.getCollectionValues();
            for (int i = 0; i < items.size(); ++i) {
                FieldGroup itemField;
                if (field instanceof FieldGroup) {
                    itemField = AtlasJavaModelFactory.cloneFieldGroup((FieldGroup)((FieldGroup)field));
                    AtlasPath.setCollectionIndexRecursively((FieldGroup)itemField, (int)depth, (int)i);
                } else {
                    itemField = AtlasJavaModelFactory.cloneJavaField((Field)field, (boolean)false);
                    AtlasPath itemPath = new AtlasPath(field.getPath());
                    itemPath.setCollectionIndex(depth, Integer.valueOf(i));
                    itemField.setPath(itemPath.toString());
                }
                List<Field> arrayFields = this.getFieldsForPath(session, items.get(i), (Field)itemField, new AtlasPath(itemField.getPath()), depth + 1);
                fields.addAll(arrayFields);
            }
        }
        return fields;
    }

    private JavaChildAccessor getAccessorForSegment(AtlasInternalSession session, Object source, Field field, AtlasPath path, AtlasPath.SegmentContext segmentContext) throws AtlasException {
        JavaChildAccessor accessor = null;
        accessor = segmentContext.isRoot() ? new RootAccessor(source) : ClassHelper.lookupAccessor(source, segmentContext.getName());
        if (accessor == null) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Field '%s' not found on object '%s'", segmentContext.getName(), source), (AuditStatus)AuditStatus.ERROR, null);
            return null;
        }
        try {
            accessor.getValue();
        }
        catch (Exception e) {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Cannot access field '%s' on object '%s': %s", segmentContext.getName(), source, e.getMessage()), (AuditStatus)AuditStatus.ERROR, null);
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return null;
        }
        if (path.getLastSegment() == segmentContext && field.getFieldType() == null && (field instanceof JavaField || field instanceof JavaEnumField)) {
            this.detectFieldType(session, accessor, field);
        }
        return accessor;
    }

    private void detectFieldType(AtlasInternalSession session, JavaChildAccessor accessor, Field field) throws AtlasException {
        Class<?> returnType;
        block5: {
            returnType = null;
            try {
                returnType = accessor.getRawClass();
            }
            catch (Exception e) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Cannot access the type of field '%s' on object '%s': %s", accessor.getName(), accessor.getRawValue(), e.getMessage()), (AuditStatus)AuditStatus.ERROR, null);
                if (!LOG.isDebugEnabled()) break block5;
                LOG.error("", (Throwable)e);
            }
        }
        if (returnType != null) {
            field.setFieldType(this.conversionService.fieldTypeFromClass(returnType));
            if (LOG.isTraceEnabled()) {
                LOG.trace("Auto-detected sourceField type p=" + field.getPath() + " t=" + field.getFieldType());
            }
        } else {
            AtlasUtil.addAudit((AtlasInternalSession)session, (Field)field, (String)String.format("Unable to auto-detect sourceField type path=%s docId=%s", field.getPath(), field.getDocId()), (AuditStatus)AuditStatus.WARN, null);
        }
    }

    private void populateChildFields(Object source, FieldGroup fieldGroup, AtlasPath path) throws AtlasException {
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Field child : fieldGroup.getField()) {
            AtlasPath childPath = new AtlasPath(child.getPath());
            JavaChildAccessor accessor = ClassHelper.lookupAccessor(source, childPath.getLastSegment().getName());
            if (childPath.getLastSegment().getCollectionType() != CollectionType.NONE) {
                FieldGroup childGroup = this.populateCollectionItems(accessor, child);
                newChildren.add(childGroup);
                continue;
            }
            if (child instanceof FieldGroup) {
                this.populateChildFields(accessor.getValue(), (FieldGroup)child, childPath);
            } else {
                child.setValue(accessor.getValue());
            }
            newChildren.add(child);
        }
        fieldGroup.getField().clear();
        fieldGroup.getField().addAll(newChildren);
    }

    private FieldGroup populateCollectionItems(JavaChildAccessor accessor, Field field) throws AtlasException {
        if (accessor == null || accessor.getCollectionType() == CollectionType.NONE) {
            throw new AtlasException(String.format("Couldn't find a collection object for field %s:%s", field.getDocId(), field.getPath()));
        }
        FieldGroup group = field instanceof FieldGroup ? (FieldGroup)field : AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
        for (int i = 0; i < accessor.getCollectionValues().size(); ++i) {
            AtlasPath itemPath = new AtlasPath(group.getPath());
            List segments = itemPath.getSegments(true);
            itemPath.setCollectionIndex(segments.size() - 1, Integer.valueOf(i));
            if (field instanceof FieldGroup) {
                FieldGroup itemGroup = AtlasJavaModelFactory.cloneFieldGroup((FieldGroup)((FieldGroup)field));
                AtlasPath.setCollectionIndexRecursively((FieldGroup)itemGroup, (int)segments.size(), (int)i);
                this.populateChildFields(accessor.getValueAt(i), itemGroup, itemPath);
                group.getField().add(itemGroup);
                continue;
            }
            Field itemField = AtlasJavaModelFactory.cloneJavaField((Field)field, (boolean)false);
            itemField.setPath(itemPath.toString());
            itemField.setValue(accessor.getValueAt(i));
            group.getField().add(itemField);
        }
        return group;
    }

    public void setDocument(Object sourceDocument) {
        this.sourceDocument = sourceDocument;
    }

    public void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

