/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassFinder {
    private static final char PKG_SEPARATOR = '.';
    private static final char DIR_SEPARATOR = '/';
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";

    public static List<Class<?>> find(String scannedPackage) {
        String scannedPath = scannedPackage.replace('.', '/');
        URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
        if (scannedUrl == null) {
            throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
        }
        File scannedDir = new File(scannedUrl.getFile());
        ArrayList classes = new ArrayList();
        for (File file : scannedDir.listFiles()) {
            classes.addAll(ClassFinder.find(file, scannedPackage));
        }
        return classes;
    }

    private static List<Class<?>> find(File file, String scannedPackage) {
        ArrayList classes;
        block4: {
            String resource;
            block3: {
                classes = new ArrayList();
                resource = scannedPackage + '.' + file.getName();
                if (!file.isDirectory()) break block3;
                for (File child : file.listFiles()) {
                    classes.addAll(ClassFinder.find(child, resource));
                }
                break block4;
            }
            if (!resource.endsWith(CLASS_FILE_SUFFIX)) break block4;
            int endIndex = resource.length() - CLASS_FILE_SUFFIX.length();
            String className = resource.substring(0, endIndex);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }
}

