/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.java.inspect.ClassFinder;
import io.atlasmap.java.inspect.InspectionException;
import io.atlasmap.java.inspect.JarClassLoader;
import io.atlasmap.java.inspect.JdkPackages;
import io.atlasmap.java.inspect.StringUtil;
import io.atlasmap.java.v2.AtlasJavaModelFactory;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.JavaEnumField;
import io.atlasmap.java.v2.JavaField;
import io.atlasmap.java.v2.Modifier;
import io.atlasmap.java.v2.ModifierList;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.StringList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInspectionService {
    private static final Logger logger = LoggerFactory.getLogger(ClassInspectionService.class);
    public static final int MAX_REENTRY_LIMIT = 1;
    public static final int MAX_ARRAY_DIM_LIMIT = 256;
    private List<String> listClasses = new ArrayList<String>(Arrays.asList("java.util.List", "java.util.ArrayList", "java.util.LinkedList", "java.util.Vector", "java.util.Stack", "java.util.AbstractList", "java.util.AbstractSequentialList"));
    private AtlasConversionService atlasConversionService = null;
    private List<String> fieldBlacklist = new ArrayList<String>(Arrays.asList("serialVersionUID"));
    private List<String> classNameBlacklist = new ArrayList<String>();
    private Boolean disableProtectedOnlyFields = false;
    private Boolean disablePrivateOnlyFields = false;
    private Boolean disablePublicOnlyFields = false;
    private Boolean disablePublicGetterSetterFields = false;

    public List<String> getListClasses() {
        return this.listClasses;
    }

    public List<String> getClassNameBlacklist() {
        return this.classNameBlacklist;
    }

    public List<String> getFieldBlacklist() {
        return this.fieldBlacklist;
    }

    public Boolean getDisableProtectedOnlyFields() {
        return this.disableProtectedOnlyFields;
    }

    public void setDisableProtectedOnlyFields(Boolean disableProtectedOnlyFields) {
        this.disableProtectedOnlyFields = disableProtectedOnlyFields;
    }

    public Boolean getDisablePrivateOnlyFields() {
        return this.disablePrivateOnlyFields;
    }

    public void setDisablePrivateOnlyFields(Boolean disablePrivateOnlyFields) {
        this.disablePrivateOnlyFields = disablePrivateOnlyFields;
    }

    public Boolean getDisablePublicOnlyFields() {
        return this.disablePublicOnlyFields;
    }

    public void setDisablePublicOnlyFields(Boolean disablePublicOnlyFields) {
        this.disablePublicOnlyFields = disablePublicOnlyFields;
    }

    public Boolean getDisablePublicGetterSetterFields() {
        return this.disablePublicGetterSetterFields;
    }

    public void setDisablePublicGetterSetterFields(Boolean disablePublicGetterSetterFields) {
        this.disablePublicGetterSetterFields = disablePublicGetterSetterFields;
    }

    public Map<String, JavaClass> inspectPackage(String packageName) throws ClassNotFoundException, InspectionException {
        return this.inspectPackages(Arrays.asList(packageName), false);
    }

    public Map<String, JavaClass> inspectPackages(String packageName, boolean inspectChildren) throws ClassNotFoundException, InspectionException {
        return this.inspectPackages(Arrays.asList(packageName), inspectChildren);
    }

    public Map<String, JavaClass> inspectPackages(List<String> packages, boolean inspectChildren) throws ClassNotFoundException, InspectionException {
        packages = inspectChildren ? this.findChildPackages(packages) : packages;
        HashMap<String, JavaClass> classes = new HashMap<String, JavaClass>();
        for (String p : packages) {
            classes.putAll(this.inspectClasses(this.findClassesForPackage(p)));
        }
        return classes;
    }

    public List<String> findClassesForPackage(String packageName) {
        LinkedList<String> classNames = new LinkedList<String>();
        List<Class<?>> classes = ClassFinder.find(packageName);
        if (classes != null) {
            for (Class<?> clz : classes) {
                classNames.add(clz.getCanonicalName());
            }
        }
        return classNames;
    }

    public List<String> findChildPackages(List<String> packages) {
        LinkedList<String> foundPackages = new LinkedList<String>();
        for (String p : packages) {
            foundPackages.addAll(this.findChildPackages(p));
        }
        return foundPackages;
    }

    public List<String> findChildPackages(String packageName) {
        LinkedList<String> packageNames = new LinkedList<String>();
        Package originalPackage = Package.getPackage(packageName);
        Package[] allPackages = Package.getPackages();
        if (allPackages != null) {
            for (Package tmpPackage : allPackages) {
                if (!tmpPackage.getName().startsWith(originalPackage.getName())) continue;
                packageNames.add(tmpPackage.getName());
            }
        }
        return packageNames;
    }

    public Map<String, JavaClass> inspectClasses(List<String> classNames) {
        HashMap<String, JavaClass> classes = new HashMap<String, JavaClass>();
        for (String c : classNames) {
            JavaClass d = this.inspectClass(c);
            classes.put(d.getClassName(), d);
        }
        return classes;
    }

    public JavaClass inspectClass(String className) {
        JavaClass d = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            d = this.inspectClass(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            d = AtlasJavaModelFactory.createJavaClass();
            d.setClassName(className);
            d.setStatus(FieldStatus.NOT_FOUND);
        }
        return d;
    }

    public JavaClass inspectClass(String className, String classpath) throws InspectionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Inspecting class: " + className + ", classPath: " + classpath);
        }
        if (className == null || classpath == null) {
            throw new InspectionException("ClassName and Classpath must be specified");
        }
        JavaClass d = null;
        try {
            JarClassLoader jcl = new JarClassLoader("target/reference-jars");
            Class<?> clazz = jcl.loadClass(className);
            d = this.inspectClass(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Class was not found: " + className);
            }
            d = AtlasJavaModelFactory.createJavaClass();
            d.setClassName(className);
            d.setStatus(FieldStatus.NOT_FOUND);
        }
        return d;
    }

    public JavaClass inspectClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must be specified");
        }
        JavaClass javaClass = AtlasJavaModelFactory.createJavaClass();
        this.inspectClass(clazz, javaClass, new HashSet<String>(), null);
        return javaClass;
    }

    protected void inspectClass(Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Class<?> clz = clazz;
        if (clazz.isArray()) {
            javaClass.setArrayDimensions(this.detectArrayDimensions(clazz));
            javaClass.setCollectionType(CollectionType.ARRAY);
            clz = this.detectArrayClass(clazz);
        } else {
            clz = clazz;
        }
        javaClass.setClassName(clz.getCanonicalName());
        javaClass.setPackageName(clz.getPackage() != null ? clz.getPackage().getName() : null);
        javaClass.setAnnotation(Boolean.valueOf(clz.isAnnotation()));
        javaClass.setAnnonymous(Boolean.valueOf(clz.isAnonymousClass()));
        javaClass.setEnumeration(Boolean.valueOf(clz.isEnum()));
        javaClass.setInterface(Boolean.valueOf(clz.isInterface()));
        javaClass.setLocalClass(Boolean.valueOf(clz.isLocalClass()));
        javaClass.setMemberClass(Boolean.valueOf(clz.isMemberClass()));
        javaClass.setPrimitive(Boolean.valueOf(clz.isPrimitive()));
        javaClass.setSynthetic(Boolean.valueOf(clz.isSynthetic()));
        if (javaClass.getUri() == null) {
            javaClass.setUri(String.format("atlas:java?className=%s", clz.getCanonicalName()));
        }
        Class<?> tmpClazz = clz;
        Class<?> superClazz = tmpClazz.getSuperclass();
        while (superClazz != null) {
            if (JdkPackages.contains(superClazz.getPackage().getName()).booleanValue()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skipping SuperClass " + superClazz.getName() + " which is a Jdk core class");
                }
                superClazz = null;
                continue;
            }
            this.inspectClassFields(superClazz, javaClass, cachedClasses, pathPrefix);
            this.inspectClassMethods(superClazz, javaClass, cachedClasses, pathPrefix);
            tmpClazz = superClazz;
            superClazz = tmpClazz.getSuperclass();
        }
        this.inspectClassFields(clz, javaClass, cachedClasses, pathPrefix);
        ?[] enumConstants = clz.getEnumConstants();
        if (enumConstants != null) {
            javaClass.setEnumeration(Boolean.valueOf(true));
            for (Object o : enumConstants) {
                JavaEnumField out = new JavaEnumField();
                if (o instanceof Enum) {
                    Enum in = (Enum)o;
                    out.setName(in.name());
                    out.setOrdinal(Integer.valueOf(in.ordinal()));
                    javaClass.getJavaEnumFields().getJavaEnumField().add(out);
                    out.setStatus(FieldStatus.SUPPORTED);
                    continue;
                }
                out.setClassName(o.getClass().getCanonicalName());
                out.setStatus(FieldStatus.ERROR);
            }
        } else {
            javaClass.setEnumeration(Boolean.valueOf(false));
        }
        this.inspectClassMethods(clz, javaClass, cachedClasses, pathPrefix);
        if (javaClass.getModifiers() == null) {
            javaClass.setModifiers(new ModifierList());
        } else {
            javaClass.getModifiers().getModifier().clear();
        }
        javaClass.getModifiers().getModifier().addAll(this.detectModifiers(clz.getModifiers()));
    }

    protected JavaField inspectGetMethod(Method m, JavaField s, Set<String> cachedClasses, String pathPrefix) {
        s.setName(StringUtil.removeGetterAndLowercaseFirstLetter(m.getName()));
        if (pathPrefix != null && pathPrefix.length() > 0) {
            s.setPath(pathPrefix + "/" + StringUtil.removeGetterAndLowercaseFirstLetter(m.getName()));
        } else {
            s.setPath(StringUtil.removeGetterAndLowercaseFirstLetter(m.getName()));
        }
        if (m.getParameterCount() != 0) {
            s.setStatus(FieldStatus.UNSUPPORTED);
            return s;
        }
        if (m.getReturnType().equals(Void.TYPE)) {
            s.setStatus(FieldStatus.UNSUPPORTED);
            return s;
        }
        Class<?> returnType = m.getReturnType();
        if (returnType.isArray()) {
            s.setCollectionType(CollectionType.ARRAY);
            s.setArrayDimensions(this.detectArrayDimensions(returnType));
            returnType = this.detectArrayClass(returnType);
        }
        s.setClassName(returnType.getCanonicalName());
        s.setGetMethod(m.getName());
        if (this.getConversionService().isPrimitive(returnType).booleanValue()) {
            s.setPrimitive(Boolean.valueOf(true));
            s.setFieldType(this.getConversionService().fieldTypeFromClass(returnType));
            s.setStatus(FieldStatus.SUPPORTED);
        } else if (this.getConversionService().isBoxedPrimitive(returnType).booleanValue()) {
            s.setPrimitive(Boolean.valueOf(true));
            s.setFieldType(this.getConversionService().fieldTypeFromClass(returnType));
            s.setStatus(FieldStatus.SUPPORTED);
        } else {
            s.setPrimitive(Boolean.valueOf(false));
            s.setFieldType(FieldType.COMPLEX);
            Class<?> complexClazz = null;
            JavaClass tmpField = this.convertJavaFieldToJavaClass(s);
            s = tmpField;
            if (returnType.getCanonicalName() == null) {
                s.setStatus(FieldStatus.UNSUPPORTED);
            } else if (!cachedClasses.contains(returnType.getCanonicalName())) {
                try {
                    complexClazz = Class.forName(returnType.getCanonicalName());
                    cachedClasses.add(returnType.getCanonicalName());
                    this.inspectClass(complexClazz, tmpField, cachedClasses, s.getPath());
                    if (tmpField.getStatus() == null) {
                        s.setStatus(FieldStatus.SUPPORTED);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    s.setStatus(FieldStatus.NOT_FOUND);
                }
            } else {
                s.setStatus(FieldStatus.CACHED);
            }
        }
        return s;
    }

    protected JavaField inspectSetMethod(Method m, JavaField s, Set<String> cachedClasses, String pathPrefix) {
        s.setName(StringUtil.removeSetterAndLowercaseFirstLetter(m.getName()));
        if (pathPrefix != null && pathPrefix.length() > 0) {
            s.setPath(pathPrefix + "/" + StringUtil.removeSetterAndLowercaseFirstLetter(m.getName()));
        } else {
            s.setPath(StringUtil.removeSetterAndLowercaseFirstLetter(m.getName()));
        }
        if (m.getParameterCount() != 1) {
            s.setStatus(FieldStatus.UNSUPPORTED);
            return s;
        }
        if (!m.getReturnType().equals(Void.TYPE)) {
            s.setStatus(FieldStatus.UNSUPPORTED);
            return s;
        }
        Class<?>[] params = m.getParameterTypes();
        if (params == null || params.length != 1) {
            s.setStatus(FieldStatus.UNSUPPORTED);
            return s;
        }
        Class<?> paramType = params[0];
        if (paramType.isArray()) {
            s.setCollectionType(CollectionType.ARRAY);
            s.setArrayDimensions(this.detectArrayDimensions(paramType));
            paramType = this.detectArrayClass(paramType);
        }
        s.setClassName(paramType.getCanonicalName());
        s.setSetMethod(m.getName());
        if (this.getConversionService().isPrimitive(paramType).booleanValue()) {
            s.setPrimitive(Boolean.valueOf(true));
            s.setFieldType(this.getConversionService().fieldTypeFromClass(paramType));
            s.setStatus(FieldStatus.SUPPORTED);
        } else if (this.getConversionService().isBoxedPrimitive(paramType).booleanValue()) {
            s.setPrimitive(Boolean.valueOf(true));
            s.setFieldType(this.getConversionService().fieldTypeFromClass(paramType));
            s.setStatus(FieldStatus.SUPPORTED);
        } else {
            s.setPrimitive(Boolean.valueOf(false));
            s.setFieldType(FieldType.COMPLEX);
            Class<?> complexClazz = null;
            JavaClass tmpField = this.convertJavaFieldToJavaClass(s);
            s = tmpField;
            if (paramType.getCanonicalName() == null) {
                s.setStatus(FieldStatus.UNSUPPORTED);
            } else if (!cachedClasses.contains(paramType.getCanonicalName())) {
                try {
                    complexClazz = Class.forName(paramType.getCanonicalName());
                    cachedClasses.add(paramType.getCanonicalName());
                    this.inspectClass(complexClazz, tmpField, cachedClasses, s.getPath());
                    if (tmpField.getStatus() == null) {
                        s.setStatus(FieldStatus.SUPPORTED);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    s.setStatus(FieldStatus.NOT_FOUND);
                }
            } else {
                s.setStatus(FieldStatus.CACHED);
            }
        }
        return s;
    }

    protected JavaField inspectField(Field f, Set<String> cachedClasses, String pathPrefix) {
        JavaField s;
        block33: {
            Class<?> clazz;
            block32: {
                String getterName;
                block31: {
                    s = AtlasJavaModelFactory.createJavaField();
                    clazz = f.getType();
                    s.setName(f.getName());
                    if (pathPrefix != null && pathPrefix.length() > 0) {
                        s.setPath(pathPrefix + "/" + f.getName());
                    } else {
                        s.setPath(f.getName());
                    }
                    if (clazz.isArray()) {
                        s.setCollectionType(CollectionType.ARRAY);
                        s.setArrayDimensions(this.detectArrayDimensions(clazz));
                        clazz = this.detectArrayClass(clazz);
                    } else if (this.isFieldList(clazz.getCanonicalName())) {
                        s.setCollectionType(CollectionType.LIST);
                        s.setCollectionClassName(clazz.getCanonicalName());
                        try {
                            clazz = this.detectListClass(f);
                            if (clazz == null) {
                                s.setStatus(FieldStatus.ERROR);
                                return s;
                            }
                        }
                        catch (ClassCastException | ClassNotFoundException cce) {
                            logger.debug("Error detecting inner listClass: " + cce.getMessage() + " for field: " + f.getName(), (Throwable)cce);
                            s.setStatus(FieldStatus.ERROR);
                            return s;
                        }
                    }
                    s.setFieldType(this.getConversionService().fieldTypeFromClass(clazz));
                    if (this.getConversionService().isPrimitive(clazz).booleanValue() || this.getConversionService().isBoxedPrimitive(clazz).booleanValue()) {
                        s.setPrimitive(Boolean.valueOf(true));
                        s.setStatus(FieldStatus.SUPPORTED);
                    } else {
                        s.setPrimitive(Boolean.valueOf(false));
                        Class<?> complexClazz = null;
                        Annotation[] tmpField = this.convertJavaFieldToJavaClass(s);
                        s = tmpField;
                        if (clazz.getCanonicalName() == null) {
                            s.setStatus(FieldStatus.UNSUPPORTED);
                        } else if (!cachedClasses.contains(clazz.getCanonicalName())) {
                            try {
                                complexClazz = Class.forName(clazz.getCanonicalName());
                                cachedClasses.add(clazz.getCanonicalName());
                                this.inspectClass(complexClazz, (JavaClass)tmpField, cachedClasses, s.getPath());
                                if (tmpField.getStatus() == null) {
                                    s.setStatus(FieldStatus.SUPPORTED);
                                }
                            }
                            catch (ClassNotFoundException cnfe) {
                                s.setStatus(FieldStatus.NOT_FOUND);
                            }
                        } else {
                            s.setStatus(FieldStatus.CACHED);
                        }
                    }
                    s.setClassName(clazz.getCanonicalName());
                    s.setSynthetic(Boolean.valueOf(f.isSynthetic()));
                    Annotation[] annotations = f.getAnnotations();
                    if (annotations != null) {
                        for (Annotation a : annotations) {
                            if (s.getAnnotations() == null) {
                                s.setAnnotations(new StringList());
                            }
                            s.getAnnotations().getString().add(a.annotationType().getCanonicalName());
                        }
                    }
                    if (s.getModifiers() == null) {
                        s.setModifiers(new ModifierList());
                    }
                    s.getModifiers().getModifier().addAll(this.detectModifiers(f.getModifiers()));
                    List<String> pTypes = this.detectParameterizedTypes(f, false);
                    if (pTypes != null) {
                        if (s.getParameterizedTypes() == null) {
                            s.setParameterizedTypes(new StringList());
                        }
                        s.getParameterizedTypes().getString().addAll(pTypes);
                    }
                    try {
                        getterName = "get" + StringUtil.capitalizeFirstLetter(f.getName());
                        f.getDeclaringClass().getMethod(getterName, new Class[0]);
                        s.setGetMethod(getterName);
                    }
                    catch (NoSuchMethodException e) {
                        if (!logger.isDebugEnabled()) break block31;
                        logger.debug("No 'get' method for field named: " + f.getName() + " in class: " + f.getDeclaringClass().getName());
                    }
                }
                if (s.getGetMethod() == null && ("boolean".equals(s.getClassName()) || "java.lang.Boolean".equals(s.getClassName()))) {
                    try {
                        getterName = "is" + StringUtil.capitalizeFirstLetter(f.getName());
                        f.getDeclaringClass().getMethod(getterName, new Class[0]);
                        s.setGetMethod(getterName);
                    }
                    catch (NoSuchMethodException e) {
                        if (!logger.isDebugEnabled()) break block32;
                        logger.debug("No 'is' method for field named: " + f.getName() + " in class: " + f.getDeclaringClass().getName());
                    }
                }
            }
            try {
                String setterName = "set" + StringUtil.capitalizeFirstLetter(f.getName());
                f.getDeclaringClass().getMethod(setterName, clazz);
                s.setSetMethod(setterName);
            }
            catch (NoSuchMethodException e) {
                if (!logger.isDebugEnabled()) break block33;
                logger.debug("No 'set' method for field named: " + f.getName() + " in class: " + f.getDeclaringClass().getName());
            }
        }
        return s;
    }

    protected void inspectClassFields(Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null && !javaClass.isEnumeration().booleanValue()) {
            for (Field f : fields) {
                if (Enum.class.isAssignableFrom(f.getType())) continue;
                JavaField s = this.inspectField(f, cachedClasses, pathPrefix);
                if (this.getFieldBlacklist().contains(f.getName())) {
                    s.setStatus(FieldStatus.BLACK_LIST);
                }
                if (s.isSynthetic() != null && s.isSynthetic().booleanValue()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Synthetic field class detected: " + s.getName());
                    continue;
                }
                if (s.getGetMethod() == null && s.getSetMethod() == null) {
                    if (s.getModifiers().getModifier().contains(Modifier.PRIVATE) && !this.getDisablePrivateOnlyFields().booleanValue()) {
                        javaClass.getJavaFields().getJavaField().add(s);
                        continue;
                    }
                    if (s.getModifiers().getModifier().contains(Modifier.PROTECTED) && !this.getDisableProtectedOnlyFields().booleanValue()) {
                        javaClass.getJavaFields().getJavaField().add(s);
                        continue;
                    }
                    if (!s.getModifiers().getModifier().contains(Modifier.PUBLIC) || this.getDisablePublicOnlyFields().booleanValue()) continue;
                    javaClass.getJavaFields().getJavaField().add(s);
                    continue;
                }
                if (this.getDisablePublicGetterSetterFields().booleanValue()) continue;
                javaClass.getJavaFields().getJavaField().add(s);
            }
        }
    }

    protected void inspectClassMethods(Class<?> clazz, JavaClass javaClass, Set<String> cachedClasses, String pathPrefix) {
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null && !javaClass.isEnumeration().booleanValue()) {
            for (Method m : methods) {
                JavaField s = AtlasJavaModelFactory.createJavaField();
                s.setName(m.getName());
                s.setSynthetic(Boolean.valueOf(m.isSynthetic()));
                if (m.isVarArgs() || m.isBridge() || m.isSynthetic() || m.isDefault()) {
                    s.setStatus(FieldStatus.UNSUPPORTED);
                    logger.warn("VarArg, Bridge, Synthetic or Default method " + m.getName() + " detected");
                    continue;
                }
                s.setSynthetic(Boolean.valueOf(m.isSynthetic()));
                if (m.getName().startsWith("get") || m.getName().startsWith("is")) {
                    s = this.inspectGetMethod(m, s, cachedClasses, pathPrefix);
                }
                if (m.getName().startsWith("set")) {
                    s = this.inspectSetMethod(m, s, cachedClasses, pathPrefix);
                }
                boolean found = false;
                for (int i = 0; i < javaClass.getJavaFields().getJavaField().size(); ++i) {
                    JavaField exists = (JavaField)javaClass.getJavaFields().getJavaField().get(i);
                    if (!s.getName().equals(exists.getName())) continue;
                    found = true;
                    if (exists.getGetMethod() == null && s.getGetMethod() != null) {
                        exists.setGetMethod(s.getGetMethod());
                    }
                    if (exists.getSetMethod() != null || s.getSetMethod() == null) continue;
                    exists.setSetMethod(s.getSetMethod());
                }
                if (found) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Field already defined for method: " + m.getName() + " class: " + clazz.getName());
                    continue;
                }
                if (s.getGetMethod() != null || s.getSetMethod() != null) {
                    javaClass.getJavaFields().getJavaField().add(s);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Ignoring non-field method: " + m.getName() + " class: " + clazz.getName());
            }
        }
    }

    protected boolean isFieldList(String fieldType) {
        return this.getListClasses().contains(fieldType);
    }

    protected Integer detectArrayDimensions(Class<?> clazz) {
        Integer arrayDim = 0;
        if (clazz == null) {
            return null;
        }
        if (!clazz.isArray()) {
            return arrayDim;
        }
        Integer n = arrayDim;
        Integer n2 = arrayDim = Integer.valueOf(arrayDim + 1);
        for (Class<?> tmpClazz = clazz.getComponentType(); tmpClazz != null && tmpClazz.isArray() && arrayDim < 256; tmpClazz = tmpClazz.getComponentType()) {
            n2 = arrayDim;
            Integer n3 = arrayDim = Integer.valueOf(arrayDim + 1);
        }
        return arrayDim;
    }

    protected List<Modifier> detectModifiers(int m) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (java.lang.reflect.Modifier.isAbstract(m)) {
            modifiers.add(Modifier.ABSTRACT);
        }
        if (java.lang.reflect.Modifier.isFinal(m)) {
            modifiers.add(Modifier.FINAL);
        }
        if (java.lang.reflect.Modifier.isInterface(m)) {
            modifiers.add(Modifier.INTERFACE);
        }
        if (java.lang.reflect.Modifier.isNative(m)) {
            modifiers.add(Modifier.NATIVE);
        }
        if (java.lang.reflect.Modifier.isPrivate(m)) {
            modifiers.add(Modifier.PRIVATE);
        }
        if (java.lang.reflect.Modifier.isProtected(m)) {
            modifiers.add(Modifier.PROTECTED);
        }
        if (java.lang.reflect.Modifier.isPublic(m)) {
            modifiers.add(Modifier.PUBLIC);
        }
        if (java.lang.reflect.Modifier.isStatic(m)) {
            modifiers.add(Modifier.STATIC);
        }
        if (java.lang.reflect.Modifier.isStrict(m)) {
            modifiers.add(Modifier.STRICT);
        }
        if (java.lang.reflect.Modifier.isSynchronized(m)) {
            modifiers.add(Modifier.SYNCHRONIZED);
        }
        if (java.lang.reflect.Modifier.isTransient(m)) {
            modifiers.add(Modifier.TRANSIENT);
        }
        if (java.lang.reflect.Modifier.isVolatile(m)) {
            modifiers.add(Modifier.VOLATILE);
        }
        return modifiers;
    }

    protected Class<?> detectListClass(Field field) throws ClassNotFoundException {
        List<String> types = this.detectParameterizedTypes(field, true);
        if (types != null && !types.isEmpty()) {
            return Class.forName(types.get(0));
        }
        return null;
    }

    protected Class<?> detectArrayClass(Class<?> clazz) {
        Class<?> tmpClazz;
        Integer arrayDim = new Integer(0);
        if (clazz == null) {
            return null;
        }
        if (!clazz.isArray()) {
            return clazz;
        }
        Integer n = arrayDim;
        Integer n2 = arrayDim = Integer.valueOf(arrayDim + 1);
        for (tmpClazz = clazz.getComponentType(); tmpClazz != null && tmpClazz.isArray() && arrayDim < 256; tmpClazz = tmpClazz.getComponentType()) {
            n2 = arrayDim;
            Integer n3 = arrayDim = Integer.valueOf(arrayDim + 1);
        }
        return tmpClazz;
    }

    protected List<String> detectParameterizedTypes(Field field, boolean onlyClasses) {
        ArrayList<String> pTypes = null;
        if (field == null || field.getGenericType() == null || !(field.getGenericType() instanceof ParameterizedType)) {
            return null;
        }
        Type[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        if (types.length == 0) {
            return null;
        }
        for (Type t : types) {
            if (pTypes == null) {
                pTypes = new ArrayList<String>();
            }
            if (!onlyClasses && t instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)t;
                AnnotatedType[] annotatedBounds = tv.getAnnotatedBounds();
                Object genericDeclaration = tv.getGenericDeclaration();
                pTypes.add(((Class)tv.getAnnotatedBounds()[0].getType()).getCanonicalName());
            }
            if (!onlyClasses && t instanceof WildcardType) {
                WildcardType wc = (WildcardType)t;
                Type[] upperBounds = wc.getUpperBounds();
                Type[] lowerBounds = wc.getLowerBounds();
                if (upperBounds != null && upperBounds.length > 0) {
                    pTypes.add(wc.getUpperBounds()[0].getClass().getCanonicalName());
                } else if (lowerBounds != null && lowerBounds.length > 0) {
                    pTypes.add(wc.getLowerBounds()[0].getClass().getCanonicalName());
                }
            }
            if (!(t instanceof Class)) continue;
            pTypes.add(((Class)t).getCanonicalName());
        }
        return pTypes;
    }

    protected JavaClass convertJavaFieldToJavaClass(JavaField javaField) {
        JavaClass javaClass = AtlasJavaModelFactory.createJavaClass();
        javaClass.setArrayDimensions(javaField.getArrayDimensions());
        javaClass.setArraySize(javaField.getArraySize());
        javaClass.setCollectionClassName(javaField.getCollectionClassName());
        javaClass.setCollectionType(javaField.getCollectionType());
        javaClass.setDocId(javaField.getDocId());
        javaClass.setPrimitive(javaField.isPrimitive());
        javaClass.setSynthetic(javaField.isSynthetic());
        javaClass.setClassName(javaField.getClassName());
        javaClass.setGetMethod(javaField.getGetMethod());
        javaClass.setName(javaField.getName());
        javaClass.setPath(javaField.getPath());
        javaClass.setRequired(javaField.isRequired());
        javaClass.setSetMethod(javaField.getSetMethod());
        javaClass.setStatus(javaField.getStatus());
        javaClass.setFieldType(javaField.getFieldType());
        if (javaField.getClassName() != null) {
            javaClass.setUri(String.format("atlas:java?className=%s", javaField.getClassName()));
        }
        javaClass.setValue(javaField.getValue());
        javaClass.setAnnotations(javaField.getAnnotations());
        javaClass.setModifiers(javaField.getModifiers());
        javaClass.setParameterizedTypes(javaField.getParameterizedTypes());
        return javaClass;
    }

    protected List<String> classpathStringToList(String classpath) {
        if (classpath == null) {
            return null;
        }
        ArrayList<String> jars = new ArrayList<String>();
        if (classpath.isEmpty()) {
            return jars;
        }
        if (!classpath.contains(":")) {
            jars.add(classpath);
            return jars;
        }
        String[] items = classpath.split(":", 256);
        if (items == null) {
            return jars;
        }
        jars.addAll(Arrays.asList(items));
        return jars;
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }
}

