/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.java.inspect.ClassHelper;
import io.atlasmap.java.inspect.ConstructException;
import io.atlasmap.java.inspect.ConstructInvalidException;
import io.atlasmap.java.inspect.ConstructPrimitiveException;
import io.atlasmap.java.inspect.ConstructUnsupportedException;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.JavaField;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaConstructService {
    private static final Logger logger = LoggerFactory.getLogger(JavaConstructService.class);
    private AtlasConversionService atlasConversionService = null;

    public Object constructClass(JavaClass javaClass) throws ConstructException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.constructClass(javaClass, null);
    }

    public Object constructClass(JavaClass javaClass, List<String> pathFilters) throws ConstructException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.validateJavaClass(javaClass);
        if (this.getConversionService().isPrimitive(javaClass.getClassName()).booleanValue()) {
            throw new ConstructPrimitiveException("Unable to instantiate a Java primitive: " + javaClass.getClassName());
        }
        if (javaClass.getCollectionType() != null) {
            switch (javaClass.getCollectionType()) {
                case ARRAY: {
                    return this.instantiateArray(javaClass, pathFilters);
                }
                case LIST: {
                    return this.instantiateList(javaClass, pathFilters);
                }
                case MAP: {
                    return this.instantiateMap(javaClass, pathFilters);
                }
            }
            throw new ConstructUnsupportedException(String.format("Unsupported collectionType for instantiation c=%s cType=%s", javaClass.getClassName(), javaClass.getCollectionType().value()));
        }
        return this.constructClassIgnoreCollection(javaClass, pathFilters);
    }

    protected Object constructClassIgnoreCollection(JavaClass javaClass, List<String> pathFilters) throws ConstructException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object targetObject = this.instantiateClass(javaClass.getClassName());
        JavaConstructService.filterFields(javaClass, pathFilters);
        if (javaClass.getJavaFields() == null || javaClass.getJavaFields().getJavaField() == null && javaClass.getJavaFields().getJavaField().isEmpty()) {
            return targetObject;
        }
        for (JavaField f : javaClass.getJavaFields().getJavaField()) {
            if (!(f instanceof JavaClass)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Constructing complex child p=%s c=%s", f.getPath(), f.getClassName()));
            }
            Object parentObject = targetObject;
            Method setter = null;
            boolean doSetter = true;
            if (f.getGetMethod() != null) {
                Method getter = null;
                Object getterResult = null;
                try {
                    getter = ClassHelper.detectGetterMethod(parentObject.getClass(), f.getGetMethod());
                    getter.setAccessible(true);
                    getterResult = getter.invoke(parentObject, new Object[0]);
                }
                catch (IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                    logger.warn(String.format("Error invoking getter for field p=%s c=%s msg=%s", f.getPath(), f.getClassName(), e.getMessage()), (Throwable)e);
                    continue;
                }
                if (getterResult != null) {
                    doSetter = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Field instantiated by parent class p=%s c=%s", f.getPath(), f.getClassName()));
                    }
                }
            }
            if (!doSetter || f.getSetMethod() == null) continue;
            try {
                setter = ClassHelper.detectSetterMethod(parentObject.getClass(), f.getSetMethod(), null);
                setter.setAccessible(true);
                setter.invoke(parentObject, this.constructClass((JavaClass)f, pathFilters));
            }
            catch (IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn(String.format("Error invoking setter for field p=%s c=%s msg=%s", f.getPath(), f.getClassName(), e.getMessage()), (Throwable)e);
            }
        }
        return targetObject;
    }

    protected Object instantiateClass(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> c = Class.forName(className);
        return c.newInstance();
    }

    protected Object instantiateArray(JavaClass javaClass, List<String> pathFilters) throws ConstructException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Constructing array c=%s size=%s", javaClass.getClassName(), javaClass.getArraySize()));
        }
        Object objectArray = Array.newInstance(Class.forName(javaClass.getClassName()), (int)javaClass.getArraySize());
        for (int i = 0; i < javaClass.getArraySize(); ++i) {
            ((Object[])objectArray)[i] = this.constructClassIgnoreCollection(javaClass, pathFilters);
        }
        return objectArray;
    }

    protected Object instantiateList(JavaClass javaClass, List<String> pathFilters) throws ConstructException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Constructing list c=%s", javaClass.getCollectionClassName()));
        }
        Class<?> collectionClass = Class.forName(javaClass.getCollectionClassName());
        return collectionClass.newInstance();
    }

    protected Object instantiateMap(JavaClass javaClass, List<String> pathFilters) throws ConstructException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Constructing map c=%s", javaClass.getCollectionClassName()));
        }
        Class<?> collectionClass = Class.forName(javaClass.getCollectionClassName());
        return collectionClass.newInstance();
    }

    protected void validateJavaClass(JavaClass javaClass) throws ConstructException {
        if (javaClass == null) {
            throw new ConstructInvalidException("JavaClass cannot be null");
        }
        if (javaClass.getClassName() == null || javaClass.getClassName().trim().length() < 1) {
            throw new ConstructInvalidException("JavaClass.className must be specified");
        }
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }

    public static void filterFields(JavaClass javaClass, List<String> filteredPaths) {
        if (filteredPaths == null || filteredPaths.size() == 0) {
            return;
        }
        if (javaClass == null || javaClass.getJavaFields() == null || javaClass.getJavaFields().getJavaField() == null || javaClass.getJavaFields().getJavaField().isEmpty()) {
            return;
        }
        ArrayList<JavaField> remove = new ArrayList<JavaField>();
        for (JavaField jf : javaClass.getJavaFields().getJavaField()) {
            if (!filteredPaths.contains(jf.getPath())) {
                remove.add(jf);
                continue;
            }
            if (!(jf instanceof JavaClass)) continue;
            JavaConstructService.filterFields((JavaClass)jf, filteredPaths);
        }
        for (JavaField jf : remove) {
            javaClass.getJavaFields().getJavaField().remove(jf);
        }
    }
}

