/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.inspect.MavenClasspathHelper;
import io.atlasmap.java.v2.ClassInspectionRequest;
import io.atlasmap.java.v2.ClassInspectionResponse;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.MavenClasspathRequest;
import io.atlasmap.java.v2.MavenClasspathResponse;
import io.atlasmap.v2.Json;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas/java")
public class JavaService {
    private static final Logger LOG = LoggerFactory.getLogger(JavaService.class);

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @GET
    @Path(value="/class")
    @Produces(value={"application/json"})
    public Response getClass(@QueryParam(value="className") String className) throws Exception {
        ClassInspectionService classInspectionService = new ClassInspectionService();
        classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        JavaClass c = classInspectionService.inspectClass(className);
        classInspectionService = null;
        return Response.ok().entity((Object)this.toJson(c)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mavenclasspath")
    public Response generateClasspath(InputStream requestIn) throws Exception {
        MavenClasspathRequest request = this.fromJson(requestIn, MavenClasspathRequest.class);
        MavenClasspathResponse response = new MavenClasspathResponse();
        MavenClasspathHelper mavenClasspathHelper = null;
        try {
            mavenClasspathHelper = new MavenClasspathHelper();
            if (request.getExecuteTimeout() != null) {
                mavenClasspathHelper.setProcessMaxExecutionTime(request.getExecuteTimeout().longValue());
            }
            long startTime = System.currentTimeMillis();
            String mavenResponse = mavenClasspathHelper.generateClasspathFromPom(request.getPomXmlData());
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            response.setClasspath(mavenResponse);
        }
        catch (Exception e) {
            LOG.error("Error generating classpath from maven: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/class")
    public Response inspectClass(InputStream requestIn) throws Exception {
        ClassInspectionRequest request = this.fromJson(requestIn, ClassInspectionRequest.class);
        ClassInspectionResponse response = new ClassInspectionResponse();
        ClassInspectionService classInspectionService = new ClassInspectionService();
        classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.configureInspectionService(classInspectionService, request);
        long startTime = System.currentTimeMillis();
        try {
            JavaClass c = null;
            c = request.getClasspath() == null || request.getClasspath().isEmpty() ? classInspectionService.inspectClass(request.getClassName()) : classInspectionService.inspectClass(request.getClassName(), request.getClasspath());
            response.setJavaClass(c);
        }
        catch (Exception e) {
            LOG.error("Error inspecting class with classpath: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        finally {
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
        }
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    protected void configureInspectionService(ClassInspectionService classInspectionService, ClassInspectionRequest request) {
        if (request.getFieldNameBlacklist() != null && request.getFieldNameBlacklist().getString() != null && !request.getFieldNameBlacklist().getString().isEmpty()) {
            classInspectionService.getFieldBlacklist().addAll(request.getFieldNameBlacklist().getString());
        }
        if (request.isDisablePrivateOnlyFields() != null) {
            classInspectionService.setDisablePrivateOnlyFields(request.isDisablePrivateOnlyFields());
        }
        if (request.isDisableProtectedOnlyFields() != null) {
            classInspectionService.setDisableProtectedOnlyFields(request.isDisableProtectedOnlyFields());
        }
        if (request.isDisablePublicOnlyFields() != null) {
            classInspectionService.setDisablePublicOnlyFields(request.isDisablePublicOnlyFields());
        }
        if (request.isDisablePublicGetterSetterFields() != null) {
            classInspectionService.setDisablePublicGetterSetterFields(request.isDisablePublicGetterSetterFields());
        }
    }
}

