/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.java.inspect.ClassInspectionService;
import io.atlasmap.java.inspect.MavenClasspathHelper;
import io.atlasmap.java.v2.ClassInspectionRequest;
import io.atlasmap.java.v2.ClassInspectionResponse;
import io.atlasmap.java.v2.JavaClass;
import io.atlasmap.java.v2.MavenClasspathRequest;
import io.atlasmap.java.v2.MavenClasspathResponse;
import io.atlasmap.service.AtlasService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Json;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/java/")
public class JavaService {
    private static final Logger LOG = LoggerFactory.getLogger(JavaService.class);
    @Context
    private ResourceContext resourceContext;

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    @Operation(summary="Simple", description="Simple hello service")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=String.class))}, description="Return a response")})
    public String simpleHelloWorld(@Parameter(description="From") @QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @GET
    @Path(value="/class")
    @Produces(value={"application/json"})
    @Operation(summary="Inspect Class", description="Inspect a Java Class with specified fully qualified class name and return a Document object")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=JavaClass.class))}, description="Return a Document object represented by JavaClass")})
    public Response getClass(@Parameter(description="The fully qualified class name to inspect") @QueryParam(value="className") String className) {
        ClassInspectionService classInspectionService = new ClassInspectionService();
        classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        JavaClass c = classInspectionService.inspectClass(className, CollectionType.NONE, null);
        classInspectionService = null;
        return Response.ok().entity((Object)this.toJson(c)).build();
    }

    @POST
    @Path(value="/mavenclasspath")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Generate Maven Classpath", description="Retrieve a maven classpath string")
    @RequestBody(description="MavenClasspathRequest object", content={@Content(schema=@Schema(implementation=MavenClasspathRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=MavenClasspathResponse.class))}, description="Return a MavenClasspathResponse object which contains classpath string")})
    public Response generateClasspath(InputStream requestIn) {
        MavenClasspathRequest request = this.fromJson(requestIn, MavenClasspathRequest.class);
        MavenClasspathResponse response = new MavenClasspathResponse();
        MavenClasspathHelper mavenClasspathHelper = null;
        try {
            mavenClasspathHelper = new MavenClasspathHelper();
            if (request.getExecuteTimeout() != null) {
                mavenClasspathHelper.setProcessMaxExecutionTime(request.getExecuteTimeout().longValue());
            }
            long startTime = System.currentTimeMillis();
            String mavenResponse = mavenClasspathHelper.generateClasspathFromPom(request.getPomXmlData());
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            response.setClasspath(mavenResponse);
        }
        catch (Exception e) {
            LOG.error("Error generating classpath from maven: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/class")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Inspect Class", description="Inspect a Java Class with specified fully qualified class name and return a Document object")
    @RequestBody(description="MavenClasspathRequest object", content={@Content(schema=@Schema(implementation=MavenClasspathRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=JavaClass.class))}, description="Return a Document object represented by JavaClass")})
    public Response inspectClass(InputStream requestIn) {
        ClassInspectionRequest request = this.fromJson(requestIn, ClassInspectionRequest.class);
        ClassInspectionResponse response = new ClassInspectionResponse();
        ClassInspectionService classInspectionService = new ClassInspectionService();
        classInspectionService.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.configureInspectionService(classInspectionService, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class inspection request: {}", (Object)new String(this.toJson(request)));
        }
        long startTime = System.currentTimeMillis();
        try {
            JavaClass c = null;
            if (request.getClasspath() == null || request.getClasspath().isEmpty()) {
                AtlasService atlasService = (AtlasService)this.resourceContext.getResource(AtlasService.class);
                c = classInspectionService.inspectClass((ClassLoader)atlasService.getLibraryLoader(), request.getClassName(), request.getCollectionType(), request.getCollectionClassName());
            } else {
                c = classInspectionService.inspectClass(request.getClassName(), request.getCollectionType(), request.getClasspath());
            }
            response.setJavaClass(c);
        }
        catch (Exception e) {
            LOG.error("Error inspecting class with classpath: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        finally {
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class inspection response: {}", (Object)new String(this.toJson(response)));
        }
        return Response.ok().entity((Object)this.toJson(response)).build();
    }

    protected void configureInspectionService(ClassInspectionService classInspectionService, ClassInspectionRequest request) {
        if (request.getFieldNameBlacklist() != null && request.getFieldNameBlacklist().getString() != null && !request.getFieldNameBlacklist().getString().isEmpty()) {
            classInspectionService.getFieldBlacklist().addAll(request.getFieldNameBlacklist().getString());
        }
        if (request.isDisablePrivateOnlyFields() != null) {
            classInspectionService.setDisablePrivateOnlyFields(request.isDisablePrivateOnlyFields());
        }
        if (request.isDisableProtectedOnlyFields() != null) {
            classInspectionService.setDisableProtectedOnlyFields(request.isDisableProtectedOnlyFields());
        }
        if (request.isDisablePublicOnlyFields() != null) {
            classInspectionService.setDisablePublicOnlyFields(request.isDisablePublicOnlyFields());
        }
        if (request.isDisablePublicGetterSetterFields() != null) {
            classInspectionService.setDisablePublicGetterSetterFields(request.isDisablePublicGetterSetterFields());
        }
    }
}

