/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldReader
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFieldReader.class);
    private AtlasConversionService conversionService;
    private JsonNode rootNode;

    private JsonFieldReader() {
    }

    public JsonFieldReader(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void read(AtlasInternalSession session) throws AtlasException {
        JsonField jsonField = (JsonField)JsonField.class.cast(session.head().getSourceField());
        if (this.rootNode == null) {
            throw new AtlasException("document is not set");
        }
        if (jsonField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        JsonNode valueNode = null;
        AtlasPath path = new AtlasPath(jsonField.getPath());
        if (path.getSegments().size() >= 1) {
            valueNode = this.rootNode.size() == 1 && !((String)path.getSegments().get(0)).startsWith((String)this.rootNode.fieldNames().next()) ? (JsonNode)this.rootNode.elements().next() : this.rootNode;
            for (String nodeName : path.getSegments()) {
                if (valueNode == null) break;
                valueNode = this.getValueNode(valueNode, nodeName);
            }
        }
        if (valueNode == null) {
            return;
        }
        if (valueNode.isNull()) {
            jsonField.setValue(null);
        } else if (jsonField.getFieldType() != null) {
            try {
                Object convertedValue = this.conversionService.convertType((Object)valueNode.asText(), jsonField.getFormat(), jsonField.getFieldType(), null);
                jsonField.setValue(convertedValue);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)jsonField.getDocId(), (String)String.format("Failed to convert field value '%s' into type '%s'", valueNode.asText(), jsonField.getFieldType()), (String)jsonField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)valueNode.asText());
            }
        } else if (valueNode.isTextual()) {
            this.handleTextualNode(valueNode, jsonField);
        } else if (valueNode.isNumber()) {
            this.handleNumberNode(valueNode, jsonField);
        } else if (valueNode.isBoolean()) {
            this.handleBooleanNode(valueNode, jsonField);
        } else if (valueNode.isContainerNode()) {
            this.handleContainerNode(valueNode, jsonField);
        } else if (valueNode.isNull()) {
            jsonField.setValue(null);
        } else {
            LOG.warn(String.format("Detected unsupported json type for field p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            jsonField.setValue((Object)valueNode.toString());
            jsonField.setFieldType(FieldType.UNSUPPORTED);
        }
    }

    private JsonNode getValueNode(JsonNode parent, String nodeName) {
        String strippedNodeName = nodeName;
        Integer index = null;
        if (nodeName.contains("[")) {
            index = Integer.parseInt(nodeName.substring(nodeName.indexOf("[") + 1, nodeName.indexOf("]")));
            strippedNodeName = nodeName.substring(0, nodeName.indexOf("["));
        } else if (nodeName.contains("<")) {
            index = Integer.parseInt(nodeName.substring(nodeName.indexOf("<") + 1, nodeName.indexOf(">")));
            strippedNodeName = nodeName.substring(0, nodeName.indexOf("<"));
        }
        JsonNode answer = parent.get(strippedNodeName);
        if (answer != null && answer.isArray() && index != null) {
            if (index >= 0) {
                answer = answer.get(index.intValue());
            } else {
                LOG.warn(String.format("Detected negative index for field p=%s, ignoring...", nodeName));
            }
        }
        return answer;
    }

    private void handleTextualNode(JsonNode valueNode, JsonField jsonField) {
        if (jsonField.getFieldType() == null || FieldType.STRING.equals((Object)jsonField.getFieldType())) {
            jsonField.setValue((Object)valueNode.textValue());
            jsonField.setFieldType(FieldType.STRING);
        } else if (FieldType.CHAR.equals((Object)jsonField.getFieldType())) {
            jsonField.setValue((Object)Character.valueOf(valueNode.textValue().charAt(0)));
        } else {
            LOG.warn(String.format("Unsupported FieldType for text data t=%s p=%s docId=%s", jsonField.getFieldType().value(), jsonField.getPath(), jsonField.getDocId()));
        }
    }

    private void handleNumberNode(JsonNode valueNode, JsonField jsonField) {
        if (valueNode.isInt()) {
            jsonField.setValue((Object)valueNode.intValue());
            jsonField.setFieldType(FieldType.INTEGER);
        } else if (valueNode.isDouble()) {
            jsonField.setValue((Object)valueNode.doubleValue());
            jsonField.setFieldType(FieldType.DOUBLE);
        } else if (valueNode.isBigDecimal()) {
            jsonField.setValue((Object)valueNode.decimalValue());
            jsonField.setFieldType(FieldType.DECIMAL);
        } else if (valueNode.isFloat()) {
            jsonField.setValue((Object)Float.valueOf(valueNode.floatValue()));
            jsonField.setFieldType(FieldType.DOUBLE);
        } else if (valueNode.isLong()) {
            jsonField.setValue((Object)valueNode.longValue());
            jsonField.setFieldType(FieldType.LONG);
        } else if (valueNode.isShort()) {
            jsonField.setValue((Object)valueNode.shortValue());
            jsonField.setFieldType(FieldType.SHORT);
        } else if (valueNode.isBigInteger()) {
            jsonField.setValue((Object)valueNode.bigIntegerValue());
            jsonField.setFieldType(FieldType.BIG_INTEGER);
        } else {
            jsonField.setValue((Object)valueNode.numberValue());
            jsonField.setFieldType(FieldType.NUMBER);
        }
    }

    private void handleBooleanNode(JsonNode valueNode, JsonField jsonField) {
        jsonField.setValue((Object)valueNode.booleanValue());
        jsonField.setFieldType(FieldType.BOOLEAN);
    }

    private void handleContainerNode(JsonNode valueNode, JsonField jsonField) {
        if (valueNode.isArray()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Detected json array p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setValue((Object)valueNode.toString());
            jsonField.setFieldType(FieldType.COMPLEX);
            jsonField.setCollectionType(CollectionType.ARRAY);
        } else if (valueNode.isObject()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Detected json complex object p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setValue((Object)valueNode.toString());
            jsonField.setFieldType(FieldType.COMPLEX);
        }
    }

    public void setDocument(String document) throws AtlasException {
        if (document == null || document.isEmpty()) {
            throw new AtlasException((Throwable)new IllegalArgumentException("document cannot be null nor empty"));
        }
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            JsonParser parser = factory.createParser(document);
            this.rootNode = (JsonNode)mapper.readTree(parser);
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

