/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldWriter
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFieldWriter.class);
    private ObjectMapper objectMapper = null;
    private ObjectNode rootNode = null;

    public JsonFieldWriter() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        this.rootNode = this.objectMapper.createObjectNode();
    }

    public JsonFieldWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.rootNode = objectMapper.createObjectNode();
    }

    public ObjectNode getRootNode() {
        return this.rootNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        if (targetField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Field: " + AtlasModelFactory.toString((Field)targetField));
            LOG.debug("Field type=" + targetField.getFieldType() + " path=" + targetField.getPath() + " v=" + targetField.getValue());
        }
        AtlasPath path = new AtlasPath(targetField.getPath());
        String lastSegment = path.getLastSegment();
        ObjectNode parentNode = this.rootNode;
        String parentSegment = null;
        for (String segment : path.getSegments()) {
            if (!segment.equals(lastSegment)) {
                JsonNode childNode;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Now processing parent segment: " + segment);
                }
                if ((childNode = JsonFieldWriter.getChildNode(parentNode, parentSegment, segment)) == null) {
                    childNode = this.createParentNode(parentNode, parentSegment, segment);
                } else if (childNode instanceof ArrayNode) {
                    int index = AtlasPath.indexOfSegment((String)segment);
                    ArrayNode arrayChild = (ArrayNode)childNode;
                    if (arrayChild.size() < index + 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                        }
                        while (arrayChild.size() < index + 1) {
                            arrayChild.addObject();
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object Array after resizing: " + arrayChild);
                        }
                    }
                    childNode = arrayChild.get(index);
                }
                parentNode = (ObjectNode)childNode;
                parentSegment = segment;
                continue;
            }
            if (targetField.getFieldType() == FieldType.COMPLEX) {
                this.createParentNode(parentNode, parentSegment, segment);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing field value segment: " + segment);
            }
            this.writeValue(parentNode, parentSegment, segment, targetField);
        }
    }

    private void writeValue(ObjectNode parentNode, String parentSegment, String segment, Field field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing field value '" + segment + "' in parent node '" + parentSegment + "', parentNode: " + parentNode);
        }
        JsonNode valueNode = this.createValueNode(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Value to write: " + valueNode);
        }
        String cleanedSegment = AtlasPath.cleanPathSegment((String)segment);
        if (AtlasPath.isCollectionSegment((String)segment).booleanValue()) {
            ArrayNode arrayChild;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field type is collection. Fetching array '" + segment + "' from parent '" + parentSegment + "': " + parentNode);
            }
            if ((arrayChild = (ArrayNode)JsonFieldWriter.getChildNode(parentNode, parentSegment, segment)) == null) {
                arrayChild = parentNode.putArray(cleanedSegment);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not find array to place value in, created it in parent: " + parentNode);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Array before placing value: " + arrayChild);
            }
            int index = AtlasPath.indexOfSegment((String)segment);
            if (arrayChild.size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addNull();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Value Array after resizing: " + arrayChild);
                }
            }
            arrayChild.set(index, valueNode);
        } else {
            parentNode.replace(cleanedSegment, valueNode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent node after value written: " + parentNode);
        }
    }

    private ObjectNode createParentNode(ObjectNode parentNode, String parentSegment, String segment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating parent node '" + segment + "' under previous parent '" + parentSegment + "' (" + parentNode.getClass().getName() + ")");
        }
        ObjectNode childNode = null;
        String cleanedSegment = AtlasPath.cleanPathSegment((String)segment);
        if (AtlasPath.isCollectionSegment((String)segment).booleanValue()) {
            ArrayNode arrayChild = parentNode.putArray(cleanedSegment);
            int index = AtlasPath.indexOfSegment((String)segment);
            if (arrayChild.size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addObject();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object Array after resizing: " + arrayChild);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created wrapper parent array node '" + segment + "': " + arrayChild);
            }
            childNode = (ObjectNode)arrayChild.get(index);
        } else {
            childNode = parentNode.putObject(cleanedSegment);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent Node '" + parentSegment + "' after adding child parent node '" + segment + "':" + parentNode);
        }
        return childNode;
    }

    private JsonNode createValueNode(Field jsonField) {
        FieldType type = jsonField.getFieldType();
        Object value = jsonField.getValue();
        Object valueNode = null;
        valueNode = FieldType.STRING.equals((Object)type) ? (value != null ? this.rootNode.textNode(String.valueOf(value)) : this.rootNode.nullNode()) : (FieldType.CHAR.equals((Object)type) ? this.rootNode.textNode(Character.toString(((Character)value).charValue())) : (FieldType.BOOLEAN.equals((Object)type) ? this.rootNode.booleanNode(((Boolean)value).booleanValue()) : (FieldType.INTEGER.equals((Object)type) ? this.rootNode.numberNode((Integer)value) : (FieldType.DOUBLE.equals((Object)type) || FieldType.FLOAT.equals((Object)type) || FieldType.NUMBER.equals((Object)type) ? this.rootNode.numberNode(new BigDecimal(String.valueOf(value))) : (FieldType.SHORT.equals((Object)type) ? this.rootNode.numberNode(Short.valueOf(String.valueOf(value))) : (FieldType.LONG.equals((Object)type) ? this.rootNode.numberNode(Long.valueOf(String.valueOf(value))) : (FieldType.BYTE.equals((Object)type) ? this.rootNode.numberNode(Byte.valueOf(String.valueOf(value))) : this.rootNode.nullNode())))))));
        if (LOG.isDebugEnabled()) {
            String valueClass = value == null ? "null" : value.getClass().getName();
            LOG.debug("Converted JsonField value to ValueNode. Type: " + type + ", value: " + value + "(" + valueClass + "), node class: " + valueNode.getClass().getName() + ", node: " + valueNode);
        }
        return valueNode;
    }

    public static JsonNode getChildNode(ObjectNode parentNode, String parentSegment, String segment) {
        String cleanedSegment;
        JsonNode childNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for child node '" + segment + "' in parent '" + parentSegment + "': " + parentNode);
        }
        if (JsonNodeType.MISSING.equals((Object)(childNode = parentNode.path(cleanedSegment = AtlasPath.cleanPathSegment((String)segment))).getNodeType())) {
            childNode = null;
        }
        if (LOG.isDebugEnabled()) {
            if (childNode == null) {
                LOG.debug("Could not find child node '" + segment + "' in parent '" + parentSegment + "'.");
            } else {
                LOG.debug("Found child node '" + segment + "' in parent '" + parentSegment + "', class: " + childNode.getClass().getName() + ", node: " + childNode);
            }
        }
        return childNode;
    }
}

