/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.v2.ActionDetails;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Json;
import io.atlasmap.v2.StringMap;
import io.atlasmap.v2.StringMapEntry;
import io.atlasmap.v2.Validations;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas")
public class AtlasService {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasService.class);
    private final DefaultAtlasContextFactory atlasContextFactory = DefaultAtlasContextFactory.getInstance();
    private String baseFolder = "target/mappings";

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/fieldActions")
    @Produces(value={"application/json"})
    public Response listFieldActions(@Context UriInfo uriInfo) {
        ActionDetails details = new ActionDetails();
        if (this.atlasContextFactory == null || this.atlasContextFactory.getFieldActionService() == null) {
            return Response.ok().entity((Object)this.toJson(details)).build();
        }
        details.getActionDetail().addAll(this.atlasContextFactory.getFieldActionService().listActionDetails());
        return Response.ok().entity((Object)this.toJson(details)).build();
    }

    @GET
    @Path(value="/mappings")
    @Produces(value={"application/json"})
    public Response listMappings(@Context UriInfo uriInfo, final @QueryParam(value="filter") String filter) {
        StringMap sMap = new StringMap();
        java.nio.file.Path mappingFolder = Paths.get(this.baseFolder, new String[0]);
        File[] mappings = mappingFolder.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (filter != null && name != null && !name.toLowerCase().contains(filter.toLowerCase())) {
                    return false;
                }
                return name != null ? name.matches("atlasmapping-[a-zA-Z0-9\\.\\-]+.xml") : false;
            }
        });
        if (mappings == null) {
            return Response.ok().entity((Object)this.toJson(sMap)).build();
        }
        try {
            for (File mapping : mappings) {
                AtlasMapping map = this.getMappingFromFile(mapping.getAbsolutePath());
                StringMapEntry mapEntry = new StringMapEntry();
                mapEntry.setName(map.getName());
                UriBuilder builder = uriInfo.getBaseUriBuilder().path("v2").path("atlas").path("mapping").path(map.getName());
                mapEntry.setValue(builder.build(new Object[0]).toString());
                sMap.getStringMapEntry().add(mapEntry);
            }
        }
        catch (JAXBException e) {
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok().entity((Object)this.toJson(sMap)).build();
    }

    @DELETE
    @Path(value="/mapping/{mappingId}")
    @Produces(value={"application/json"})
    public Response removeMappingRequest(@PathParam(value="mappingId") String mappingId) {
        java.nio.file.Path mappingFilePath = Paths.get(this.baseFolder + File.separator + this.generateMappingFileName(mappingId), new String[0]);
        File mappingFile = mappingFilePath.toFile();
        if (!mappingFile.exists()) {
            return Response.noContent().build();
        }
        if (mappingFile != null && !mappingFile.delete()) {
            LOG.warn("Unable to delete mapping file " + mappingFile.toString());
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/mapping/{mappingId}")
    @Produces(value={"application/json"})
    public Response getMappingRequest(@PathParam(value="mappingId") String mappingId) {
        java.nio.file.Path mappingFilePath = Paths.get(this.baseFolder + File.separator + this.generateMappingFileName(mappingId), new String[0]);
        File mappingFile = mappingFilePath.toFile();
        if (!mappingFile.exists()) {
            return Response.noContent().build();
        }
        AtlasMapping atlasMapping = null;
        try {
            atlasMapping = this.getMappingFromFile(mappingFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error("Error retrieving mapping " + e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity((Object)this.toJson(atlasMapping)).build();
    }

    @PUT
    @Path(value="/mapping")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createMappingRequest(InputStream mapping, @Context UriInfo uriInfo) {
        return this.saveMapping(this.fromJson(mapping, AtlasMapping.class), uriInfo);
    }

    @POST
    @Path(value="/mapping/{mappingId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateMappingRequest(InputStream mapping, @Context UriInfo uriInfo) {
        return this.saveMapping(this.fromJson(mapping, AtlasMapping.class), uriInfo);
    }

    @PUT
    @Path(value="/mapping/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateMappingRequest(InputStream mapping, @Context UriInfo uriInfo) {
        try {
            return this.validateMapping(this.fromJson(mapping, AtlasMapping.class), uriInfo);
        }
        catch (AtlasException | IOException e) {
            throw new WebApplicationException(e.getMessage(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/ping")
    public String ping() {
        return "pong";
    }

    protected Response validateMapping(AtlasMapping mapping, UriInfo uriInfo) throws IOException, AtlasException {
        File temporaryMappingFile = File.createTempFile("atlas-mapping", "xml");
        temporaryMappingFile.deleteOnExit();
        this.atlasContextFactory.getMappingService().saveMappingAsFile(mapping, temporaryMappingFile);
        AtlasContext context = this.atlasContextFactory.createContext(temporaryMappingFile.toURI());
        AtlasSession session = context.createSession();
        context.processValidation(session);
        Validations validations = session.getValidations();
        if (session.getValidations() == null) {
            validations = new Validations();
        }
        if (temporaryMappingFile.exists() && !temporaryMappingFile.delete()) {
            LOG.warn("Failed to deleting temporary file: " + (temporaryMappingFile != null ? temporaryMappingFile.toString() : null));
        }
        return Response.ok().entity((Object)this.toJson(validations)).build();
    }

    protected Response saveMapping(AtlasMapping mapping, UriInfo uriInfo) {
        try {
            this.saveMappingToFile(mapping);
        }
        catch (Exception e) {
            LOG.error("Error saving mapping " + mapping.getName() + " to file: " + e.getMessage(), (Throwable)e);
        }
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        builder.path(mapping.getName());
        return Response.ok().location(builder.build(new Object[0])).build();
    }

    public AtlasMapping getMappingFromFile(String fileName) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"io.atlasmap.v2:io.atlasmap.java.v2:io.atlasmap.xml.v2:io.atlasmap.json.v2");
        Marshaller marshaller = null;
        Unmarshaller unmarshaller = null;
        marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        unmarshaller = jaxbContext.createUnmarshaller();
        StreamSource fileSource = new StreamSource(new File(fileName));
        JAXBElement mappingElem = unmarshaller.unmarshal((Source)fileSource, AtlasMapping.class);
        if (mappingElem != null) {
            return (AtlasMapping)mappingElem.getValue();
        }
        return null;
    }

    protected void saveMappingToFile(AtlasMapping atlasMapping) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"io.atlasmap.v2:io.atlasmap.java.v2:io.atlasmap.xml.v2:io.atlasmap.json.v2");
        Marshaller marshaller = null;
        marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)atlasMapping, this.createMappingFile(atlasMapping.getName()));
    }

    private File createMappingFile(String mappingName) {
        File dir = new File(this.baseFolder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = this.baseFolder + File.separator + this.generateMappingFileName(mappingName);
        LOG.debug("Creating mapping file '{}'", (Object)fileName);
        return new File(fileName);
    }

    protected String generateMappingFileName(String mappingName) {
        return String.format("atlasmapping-%s.xml", mappingName);
    }
}

