/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.service;

import io.atlasmap.api.AtlasException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasLibraryLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasLibraryLoader.class);
    private File saveDir;
    private URLClassLoader urlClassLoader;
    private Set<ClassLoader> alternativeLoaders = new HashSet<ClassLoader>();
    private Set<AtlasLibraryLoaderListener> listeners = new HashSet<AtlasLibraryLoaderListener>();

    public AtlasLibraryLoader(String saveDirName) throws AtlasException {
        super(AtlasLibraryLoader.class.getClassLoader());
        LOG.debug("Using {} as a lib directory", (Object)saveDirName);
        this.saveDir = new File(saveDirName);
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        if (!this.saveDir.isDirectory()) {
            throw new AtlasException(String.format("'%s' is not a directory", this.saveDir.getName()));
        }
        this.reload();
    }

    public void addJarFromStream(InputStream is) throws Exception {
        int nRead;
        File dest = new File(this.saveDir + File.separator + UUID.randomUUID().toString() + ".jar");
        while (dest.exists()) {
            dest = new File(this.saveDir + File.separator + UUID.randomUUID().toString() + ".jar");
        }
        FileOutputStream buffer = new FileOutputStream(dest);
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        buffer.close();
        LinkedList<URL> urls = new LinkedList<URL>();
        urls.add(dest.toURI().toURL());
        if (this.urlClassLoader != null) {
            URL[] origUrls = this.urlClassLoader.getURLs();
            urls.addAll(Arrays.asList(origUrls));
        }
        this.reload();
    }

    public void clearLibaries() {
        File[] files = this.saveDir.listFiles();
        if (!this.saveDir.exists() || !this.saveDir.isDirectory() || files == null) {
            return;
        }
        for (File f : this.saveDir.listFiles()) {
            f.delete();
        }
        this.reload();
    }

    public void reload() {
        LinkedList<URL> urls = new LinkedList<URL>();
        File[] files = this.saveDir.listFiles();
        if (!this.saveDir.exists() || !this.saveDir.isDirectory() || files == null) {
            return;
        }
        for (File f : files) {
            try {
                if (!f.isFile()) {
                    LOG.warn("Ignoring invalid file {}", (Object)f.getAbsolutePath());
                    continue;
                }
                urls.add(f.toURI().toURL());
            }
            catch (Exception e) {
                LOG.warn("Ignoring invalid file", (Throwable)e);
            }
        }
        this.urlClassLoader = urls.size() == 0 ? null : new URLClassLoader(urls.toArray(new URL[0]), AtlasLibraryLoader.class.getClassLoader());
        this.listeners.forEach(l -> l.onUpdate(this));
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        LOG.debug("Loading Class:{}", (Object)name);
        if (this.urlClassLoader != null) {
            try {
                return this.urlClassLoader.loadClass(name);
            }
            catch (Throwable t) {
                LOG.debug("Class not found: [ClassLoader:<uploaded jar>, Class name:{}, message:{}]", (Object)name, (Object)t.getMessage());
            }
        }
        if (!this.alternativeLoaders.isEmpty()) {
            for (ClassLoader cl : this.alternativeLoaders) {
                try {
                    return cl.loadClass(name);
                }
                catch (Throwable t) {
                    LOG.debug("Class not found: [ClassLoader:{}, Class name:{}, message:{}]", new Object[]{cl, name, t.getMessage()});
                }
            }
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            return tccl.loadClass(name);
        }
        catch (Throwable t) {
            LOG.debug("Class not found: [ClassLoader:{}, class name:{}, message:{}]", new Object[]{tccl, name, t.getMessage()});
            return super.loadClass(name);
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader tccl;
        URL answer;
        if (this.urlClassLoader != null && (answer = this.urlClassLoader.getResource(name)) != null) {
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)this.urlClassLoader, (Object)name);
            return answer;
        }
        if (!this.alternativeLoaders.isEmpty()) {
            for (ClassLoader cl : this.alternativeLoaders) {
                answer = cl.getResource(name);
                if (answer == null) continue;
                LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
                return answer;
            }
        }
        if ((answer = (tccl = Thread.currentThread().getContextClassLoader()).getResource(name)) != null) {
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)tccl, (Object)name);
            return answer;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final HashSet answer = new HashSet();
        if (this.urlClassLoader != null) {
            Enumeration<URL> e = this.urlClassLoader.getResources(name);
            while (e.hasMoreElements()) {
                LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)this.urlClassLoader, (Object)name);
                answer.add(e.nextElement());
            }
        }
        if (!this.alternativeLoaders.isEmpty()) {
            for (ClassLoader cl : this.alternativeLoaders) {
                Enumeration<URL> e = cl.getResources(name);
                while (e.hasMoreElements()) {
                    LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
                    answer.add(e.nextElement());
                }
            }
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = tccl.getResources(name);
        while (e.hasMoreElements()) {
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)tccl, (Object)name);
            answer.add(e.nextElement());
        }
        e = super.getResources(name);
        while (e.hasMoreElements()) {
            LOG.debug("Found resource:[ClassLoader:parent, name:{}]", (Object)this, (Object)name);
            answer.add(e.nextElement());
        }
        return new Enumeration<URL>(){
            Iterator<URL> iterator;
            {
                this.iterator = answer.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader tccl;
        InputStream answer;
        if (this.urlClassLoader != null && (answer = this.urlClassLoader.getResourceAsStream(name)) != null) {
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)this.urlClassLoader, (Object)name);
            return answer;
        }
        if (!this.alternativeLoaders.isEmpty()) {
            for (ClassLoader cl : this.alternativeLoaders) {
                answer = cl.getResourceAsStream(name);
                if (answer == null) continue;
                LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
                return answer;
            }
        }
        if ((answer = (tccl = Thread.currentThread().getContextClassLoader()).getResourceAsStream(name)) != null) {
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)tccl, (Object)name);
            return answer;
        }
        return super.getResourceAsStream(name);
    }

    public boolean isEmpty() {
        return this.urlClassLoader == null;
    }

    public void addAlternativeLoader(ClassLoader cl) {
        this.alternativeLoaders.add(cl);
    }

    public void addListener(AtlasLibraryLoaderListener listener) {
        this.listeners.add(listener);
    }

    public static interface AtlasLibraryLoaderListener {
        public void onUpdate(AtlasLibraryLoader var1);
    }
}

