/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.service;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.CompoundClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasLibraryLoader
extends CompoundClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasLibraryLoader.class);
    private File saveDir;
    private URLClassLoader urlClassLoader;
    private Set<ClassLoader> alternativeLoaders = new HashSet<ClassLoader>();
    private Set<AtlasLibraryLoaderListener> listeners = new HashSet<AtlasLibraryLoaderListener>();

    public AtlasLibraryLoader(String saveDirName) throws AtlasException {
        LOG.debug("Using {} as a lib directory", (Object)saveDirName);
        this.saveDir = new File(saveDirName);
        if (!this.saveDir.exists()) {
            this.saveDir.mkdirs();
        }
        if (!this.saveDir.isDirectory()) {
            throw new AtlasException(String.format("'%s' is not a directory", this.saveDir.getName()));
        }
        this.reload();
    }

    public void addJarFromStream(InputStream is) throws Exception {
        int nRead;
        File dest = new File(this.saveDir + File.separator + UUID.randomUUID().toString() + ".jar");
        while (dest.exists()) {
            dest = new File(this.saveDir + File.separator + UUID.randomUUID().toString() + ".jar");
        }
        FileOutputStream buffer = new FileOutputStream(dest);
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        buffer.close();
        LinkedList<URL> urls = new LinkedList<URL>();
        urls.add(dest.toURI().toURL());
        if (this.urlClassLoader != null) {
            URL[] origUrls = this.urlClassLoader.getURLs();
            urls.addAll(Arrays.asList(origUrls));
        }
        this.reload();
    }

    public void clearLibraries() {
        if (this.urlClassLoader != null) {
            try {
                this.urlClassLoader.close();
            }
            catch (Exception e) {
                LOG.warn("Ignoring an error while closing an old URLClassLoader: {}", (Object)e.getMessage());
            }
            this.urlClassLoader = null;
        }
        File[] files = this.saveDir.listFiles();
        if (!this.saveDir.exists() || !this.saveDir.isDirectory() || files == null) {
            return;
        }
        for (File f : this.saveDir.listFiles()) {
            try {
                Files.delete(f.toPath());
            }
            catch (Exception e) {
                LOG.warn("Failed to remove jar file: '{}'", (Object)e.getMessage());
            }
        }
        this.reload();
    }

    public ArrayList<String> getLibraryClassNames() throws AtlasException {
        String classSuffix = ".class";
        ArrayList<String> classNames = new ArrayList<String>();
        if (this.urlClassLoader == null) {
            return classNames;
        }
        URL[] candidateURLs = this.urlClassLoader.getURLs();
        for (int i = 0; i < candidateURLs.length; ++i) {
            try (ZipInputStream zip = new ZipInputStream(new FileInputStream(candidateURLs[i].toURI().getPath()));){
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory() && entry.getName().endsWith(".class")) {
                        String className = entry.getName().replace('/', '.');
                        classNames.add(className.substring(0, className.length() - ".class".length()));
                    }
                    entry = zip.getNextEntry();
                }
                continue;
            }
            catch (IOException | URISyntaxException e) {
                throw new AtlasException(String.format("URL library '%s' access error: %s", candidateURLs[i].getPath(), e.getMessage()));
            }
        }
        return classNames;
    }

    public ArrayList<String> getSubTypesOf(Class<?> clazz, boolean allowAbstract) throws AtlasException {
        ArrayList<String> answer = new ArrayList<String>();
        if (clazz == null) {
            return answer;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching sub types of {}", (Object)clazz.getName());
        }
        for (String className : this.getLibraryClassNames()) {
            try {
                Class<?> c = this.loadClass(className);
                if (!clazz.isAssignableFrom(c) || !allowAbstract && (c.isInterface() || Modifier.isAbstract(c.getModifiers()))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found {}", (Object)className);
                }
                answer.add(className);
            }
            catch (Exception e) {
                LOG.debug("", (Throwable)e);
            }
        }
        return answer;
    }

    public synchronized void reload() {
        LinkedList<URL> urls = new LinkedList<URL>();
        File[] files = this.saveDir.listFiles();
        if (!this.saveDir.exists() || !this.saveDir.isDirectory() || files == null) {
            return;
        }
        for (File f : files) {
            try {
                if (!f.isFile()) {
                    LOG.warn("Ignoring invalid file {}", (Object)f.getAbsolutePath());
                    continue;
                }
                urls.add(f.toURI().toURL());
            }
            catch (Exception e) {
                LOG.warn("Ignoring invalid file", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading library jars: {}", urls);
        }
        this.urlClassLoader = urls.size() == 0 ? null : new URLClassLoader(urls.toArray(new URL[0]), AtlasLibraryLoader.class.getClassLoader());
        this.listeners.forEach(l -> l.onUpdate(this));
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        LOG.debug("Loading Class:{}", (Object)name);
        for (ClassLoader cl : this.sortLoaders()) {
            try {
                return cl.loadClass(name);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw ncdfe;
            }
            catch (Throwable t) {
                LOG.debug("Class not found: [ClassLoader:{}, Class name:{}, message:{}]", new Object[]{cl, name, t.getMessage(), t});
            }
        }
        return super.loadClass(name);
    }

    private Set<ClassLoader> sortLoaders() {
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        if (this.urlClassLoader != null) {
            loaders.add(this.urlClassLoader);
        }
        loaders.addAll(this.alternativeLoaders);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (this != tccl) {
            loaders.add(tccl);
        }
        return loaders;
    }

    public URL getResource(String name) {
        for (ClassLoader cl : this.sortLoaders()) {
            URL answer = cl.getResource(name);
            if (answer == null) continue;
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
            return answer;
        }
        return super.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        final LinkedHashSet<URL> answer = new LinkedHashSet<URL>();
        for (ClassLoader cl : this.sortLoaders()) {
            Enumeration<URL> e = cl.getResources(name);
            while (e.hasMoreElements()) {
                LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
                answer.add(e.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iterator;
            {
                this.iterator = answer.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    public InputStream getResourceAsStream(String name) {
        for (ClassLoader cl : this.sortLoaders()) {
            InputStream answer = cl.getResourceAsStream(name);
            if (answer == null) continue;
            LOG.debug("Found resource:[ClassLoader:{}, name:{}]", (Object)cl, (Object)name);
            return answer;
        }
        return super.getResourceAsStream(name);
    }

    public boolean isEmpty() {
        return this.urlClassLoader == null;
    }

    public void addAlternativeLoader(ClassLoader cl) {
        if (this != cl) {
            this.alternativeLoaders.add(cl);
        }
    }

    public void addListener(AtlasLibraryLoaderListener listener) {
        this.listeners.add(listener);
    }

    public static interface AtlasLibraryLoaderListener {
        public void onUpdate(AtlasLibraryLoader var1);
    }
}

