/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasMappingBuilder;
import io.atlasmap.api.AtlasPreviewContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.ADMArchiveHandler;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.CompoundClassLoader;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.service.AtlasLibraryLoader;
import io.atlasmap.v2.ActionDetails;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Json;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingFileType;
import io.atlasmap.v2.ProcessMappingRequest;
import io.atlasmap.v2.ProcessMappingResponse;
import io.atlasmap.v2.StringMap;
import io.atlasmap.v2.StringMapEntry;
import io.atlasmap.v2.Validations;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class AtlasService {
    static final String MAPPING_NAME_PREFIX = "UI.";
    static final String ATLASMAP_ADM_PATH = "atlasmap.adm.path";
    static final String ATLASMAP_WORKSPACE = "atlasmap.workspace";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasService.class);
    private final DefaultAtlasContextFactory atlasContextFactory = DefaultAtlasContextFactory.getInstance();
    private final AtlasPreviewContext previewContext;
    private String baseFolder = "";
    private String mappingFolder = "";
    private String libFolder = "";
    private AtlasLibraryLoader libraryLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlasService() throws AtlasException {
        String atlasmapWorkspace = System.getProperty(ATLASMAP_WORKSPACE);
        LOG.debug("AtlasMap backend Working directory: {}", (Object)atlasmapWorkspace);
        this.baseFolder = atlasmapWorkspace != null && atlasmapWorkspace.length() > 0 ? atlasmapWorkspace : "target";
        this.mappingFolder = this.baseFolder + File.separator + "mappings";
        this.libFolder = this.baseFolder + File.separator + "lib";
        this.libraryLoader = new AtlasLibraryLoader(this.libFolder);
        this.libraryLoader.addAlternativeLoader(DefaultAtlasFieldActionService.class.getClassLoader());
        this.libraryLoader.addListener(new AtlasLibraryLoader.AtlasLibraryLoaderListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdate(AtlasLibraryLoader loader) {
                DefaultAtlasContextFactory defaultAtlasContextFactory = AtlasService.this.atlasContextFactory;
                synchronized (defaultAtlasContextFactory) {
                    AtlasService.this.atlasContextFactory.destroy();
                    AtlasService.this.atlasContextFactory.init((CompoundClassLoader)AtlasService.this.libraryLoader);
                }
            }
        });
        String atlasmapAdmPath = System.getProperty(ATLASMAP_ADM_PATH);
        if (atlasmapAdmPath != null && atlasmapAdmPath.length() > 0) {
            LOG.debug("Loading initial ADM file: {}", (Object)atlasmapAdmPath);
            this.libraryLoader.clearLibraries();
            ADMArchiveHandler admHandler = new ADMArchiveHandler((ClassLoader)((Object)this.libraryLoader));
            java.nio.file.Path mappingDirPath = Paths.get(this.getMappingSubDirectory(0), new String[0]);
            admHandler.setPersistDirectory(mappingDirPath);
            admHandler.setIgnoreLibrary(false);
            admHandler.setLibraryDirectory(Paths.get(this.libFolder, new String[0]));
            admHandler.load(Paths.get(atlasmapAdmPath, new String[0]));
            this.libraryLoader.reload();
            admHandler.persist();
        }
        DefaultAtlasContextFactory defaultAtlasContextFactory = this.atlasContextFactory;
        synchronized (defaultAtlasContextFactory) {
            this.atlasContextFactory.destroy();
            this.atlasContextFactory.init((CompoundClassLoader)this.libraryLoader);
        }
        this.previewContext = this.atlasContextFactory.createPreviewContext();
    }

    @GET
    @Path(value="/fieldActions")
    @Produces(value={"application/json"})
    @Operation(summary="List FieldActions", description="Retrieves a list of available field action")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ActionDetails.class))}, description="Return a list of field action detail")})
    public Response listFieldActions(@Context UriInfo uriInfo) {
        ActionDetails details = new ActionDetails();
        if (this.atlasContextFactory == null || this.atlasContextFactory.getFieldActionService() == null) {
            return Response.ok().entity((Object)this.toJson(details)).build();
        }
        details.getActionDetail().addAll(this.atlasContextFactory.getFieldActionService().listActionDetails());
        byte[] serialized = this.toJson(details);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new String(serialized));
        }
        return Response.ok().entity((Object)serialized).build();
    }

    @Deprecated
    @GET
    @Path(value="/mappings")
    @Produces(value={"application/json"})
    @Operation(summary="List Mappings", description="Retrieves a list of mapping file name saved with specified mappingDefinitionId")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=StringMap.class))}, description="Return a list of a pair of mapping file name and content")})
    public Response listMappingsOld(@Context UriInfo uriInfo, @QueryParam(value="filter") String filter) {
        return this.listMappings(uriInfo, filter, 0);
    }

    @GET
    @Path(value="/mappings/{mappingDefinitionId}")
    @Produces(value={"application/json"})
    @Operation(summary="List Mappings", description="Retrieves a list of mapping file name saved with specified mappingDefinitionId")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=StringMap.class))}, description="Return a list of a pair of mapping file name and content")})
    public Response listMappings(@Context UriInfo uriInfo, @QueryParam(value="filter") String filter, @Parameter(description="Mapping Definition ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId) {
        StringMap sMap = new StringMap();
        LOG.debug("listMappings with filter '{}'", (Object)filter);
        ADMArchiveHandler handler = this.loadExplodedMappingDirectory(mappingDefinitionId);
        AtlasMapping map = handler.getMappingDefinition();
        if (map == null) {
            return Response.ok().entity((Object)this.toJson(sMap)).build();
        }
        StringMapEntry mapEntry = new StringMapEntry();
        mapEntry.setName(map.getName());
        UriBuilder builder = uriInfo.getBaseUriBuilder().path("v2").path("atlas").path("mapping").path(map.getName());
        mapEntry.setValue(builder.build(new Object[0]).toString());
        sMap.getStringMapEntry().add(mapEntry);
        byte[] serialized = this.toJson(sMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new String(serialized));
        }
        return Response.ok().entity((Object)serialized).build();
    }

    @Deprecated
    @DELETE
    @Path(value="/mapping")
    @Produces(value={"application/json"})
    @Operation(summary="Remove Mapping", description="Remove a mapping file saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Specified mapping file was removed successfully"), @ApiResponse(responseCode="204", description="Mapping file was not found")})
    public Response removeMappingRequestOld() {
        return this.removeMappingRequest(0);
    }

    @DELETE
    @Path(value="/mapping/{mappingDefinitionId}")
    @Produces(value={"application/json"})
    @Operation(summary="Remove Mapping", description="Remove a mapping file saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Specified mapping file was removed successfully"), @ApiResponse(responseCode="204", description="Mapping file was not found")})
    public Response removeMappingRequest(@Parameter(description="Mapping ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId) {
        java.nio.file.Path mappingDirPath = Paths.get(this.getMappingSubDirectory(mappingDefinitionId), new String[0]);
        File mappingDirFile = mappingDirPath.toFile();
        if (mappingDirFile == null || !mappingDirFile.exists()) {
            return Response.noContent().build();
        }
        if (!mappingDirFile.isDirectory()) {
            LOG.warn("Removing invalid file '{}' in a persistent directory", (Object)mappingDirFile.getAbsolutePath());
        } else {
            AtlasUtil.deleteDirectory((File)mappingDirFile);
        }
        return Response.ok().build();
    }

    @Deprecated
    @DELETE
    @Path(value="/mapping/RESET")
    @Produces(value={"application/json"})
    @Operation(summary="Remove Mapping by ID", description="Remove mapping file and catalogs related to specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mapping file and Catalogs were removed successfully"), @ApiResponse(responseCode="204", description="Unable to remove mapping file and Catalogs for the specified ID")})
    public Response resetMappingByIdOld() {
        return this.resetMappingById(0);
    }

    @DELETE
    @Path(value="/mapping/RESET/{mappingDefinitionId}")
    @Produces(value={"application/json"})
    @Operation(summary="Remove Mapping by ID", description="Remove mapping file and catalogs related to specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mapping file and Catalogs were removed successfully"), @ApiResponse(responseCode="204", description="Unable to remove mapping file and Catalogs for the specified ID")})
    public Response resetMappingById(@Parameter(description="Mapping ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId) {
        LOG.debug("resetMappingById {} ", (Object)mappingDefinitionId);
        java.nio.file.Path mappingFolderPath = Paths.get(this.getMappingSubDirectory(mappingDefinitionId), new String[0]);
        File mappingFolderFile = mappingFolderPath.toFile();
        if (mappingFolderFile == null || !mappingFolderFile.exists()) {
            return Response.ok().build();
        }
        if (!mappingFolderFile.isDirectory()) {
            LOG.warn("{} is not a directory - removing anyway", (Object)mappingFolderFile.getAbsolutePath());
        }
        AtlasUtil.deleteDirectory((File)mappingFolderFile);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/mapping/RESET/ALL")
    @Produces(value={"application/json"})
    @Operation(summary="Remove All Mappings", description="Remove all mapping files and catalogs saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All mapping files were removed successfully"), @ApiResponse(responseCode="204", description="Unable to remove all mapping files")})
    public Response resetAllMappings() {
        LOG.debug("resetAllMappings");
        java.nio.file.Path mappingFolderPath = Paths.get(this.mappingFolder, new String[0]);
        File mappingFolderPathFile = mappingFolderPath.toFile();
        if (mappingFolderPathFile == null || !mappingFolderPathFile.exists()) {
            return Response.ok().build();
        }
        AtlasUtil.deleteDirectoryContents((File)mappingFolderPathFile);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/mapping/resetLibs")
    @Produces(value={"application/json"})
    @Operation(summary="Remove All User-Defined JAR libraries", description="Remove all user-defined JAR files saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All user-defined JAR files were removed successfully"), @ApiResponse(responseCode="204", description="Unable to remove all user-defined JAR files")})
    public Response resetUserLibs() {
        LOG.debug("resetUserLibs");
        this.libraryLoader.clearLibraries();
        return Response.ok().build();
    }

    @Deprecated
    @GET
    @Path(value="/mapping/{mappingFormat}")
    @Produces(value={"application/json", "application/xml", "application/octet-stream"})
    @Operation(summary="Get Mapping", description="Retrieve a mapping file saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AtlasMapping.class))}, description="Return a mapping file content"), @ApiResponse(responseCode="204", description="Mapping file was not found"), @ApiResponse(responseCode="500", description="Mapping file access error")})
    public Response getMappingRequestOld(@Parameter(description="Mapping Format") @PathParam(value="mappingFormat") MappingFileType mappingFormat) {
        return this.getMappingRequest(mappingFormat, 0);
    }

    @GET
    @Path(value="/mapping/{mappingFormat}/{mappingDefinitionId}")
    @Produces(value={"application/json", "application/xml", "application/octet-stream"})
    @Operation(summary="Get Mapping", description="Retrieve a mapping file saved on the server")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=AtlasMapping.class))}, description="Return a mapping file content"), @ApiResponse(responseCode="204", description="Mapping file was not found"), @ApiResponse(responseCode="500", description="Mapping file access error")})
    public Response getMappingRequest(@Parameter(description="Mapping Format") @PathParam(value="mappingFormat") MappingFileType mappingFormat, @Parameter(description="Mapping ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId) {
        LOG.debug("getMappingRequest: {} '{}'", (Object)mappingFormat, (Object)mappingDefinitionId);
        ADMArchiveHandler admHandler = this.loadExplodedMappingDirectory(mappingDefinitionId);
        switch (mappingFormat) {
            case JSON: {
                byte[] serialized = null;
                try {
                    serialized = admHandler.getMappingDefinitionBytes();
                }
                catch (Exception e) {
                    LOG.error("Error retrieving mapping definition file for ID:" + mappingDefinitionId, (Throwable)e);
                    throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
                if (LOG.isDebugEnabled() && serialized != null) {
                    LOG.debug(new String(serialized));
                }
                if (serialized == null) {
                    LOG.debug("Mapping definition not found for ID:{}", (Object)mappingDefinitionId);
                    return Response.noContent().build();
                }
                return Response.ok().entity((Object)serialized).build();
            }
            case GZ: {
                try {
                    if (admHandler.getGzippedADMDigestBytes() == null) {
                        LOG.debug("ADM Digest file not found for ID:{}", (Object)mappingDefinitionId);
                        return Response.noContent().build();
                    }
                    return Response.ok().entity((Object)admHandler.getGzippedADMDigestBytes()).build();
                }
                catch (Exception e) {
                    LOG.error("Error getting compressed ADM digest file.\n" + e.getMessage(), (Throwable)e);
                    throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            case ZIP: {
                Response response;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    admHandler.setIgnoreLibrary(false);
                    admHandler.setLibraryDirectory(Paths.get(this.libFolder, new String[0]));
                    admHandler.export((OutputStream)out);
                    response = Response.ok().entity((Object)out.toByteArray()).build();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Error getting ADM archive file.\n" + e.getMessage(), (Throwable)e);
                        throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
                out.close();
                return response;
            }
        }
        throw new WebApplicationException("Unrecognized mapping format: " + mappingFormat, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @Deprecated
    @PUT
    @Path(value="/mapping/{mappingFormat}")
    @Consumes(value={"application/json", "application/xml", "application/octet-stream"})
    @Produces(value={"application/json"})
    @Operation(summary="Create Mapping", description="Save a mapping file on the server")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded"), @ApiResponse(responseCode="500", description="Mapping file save error")})
    public Response createMappingRequestOld(InputStream mapping, @Parameter(description="Mapping Format") @PathParam(value="mappingFormat") MappingFileType mappingFormat, @Context UriInfo uriInfo) {
        return this.createMappingRequest(mapping, mappingFormat, 0, uriInfo);
    }

    @PUT
    @Path(value="/mapping/{mappingFormat}/{mappingDefinitionId}")
    @Consumes(value={"application/json", "application/xml", "application/octet-stream"})
    @Produces(value={"application/json"})
    @Operation(summary="Create Mapping", description="Save a mapping file on the server")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded"), @ApiResponse(responseCode="500", description="Mapping file save error")})
    public Response createMappingRequest(InputStream mapping, @Parameter(description="Mapping Format") @PathParam(value="mappingFormat") MappingFileType mappingFormat, @Parameter(description="Mapping ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId, @Context UriInfo uriInfo) {
        LOG.debug("createMappingRequest (save) with format '{}'", (Object)mappingFormat);
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        ADMArchiveHandler admHandler = this.loadExplodedMappingDirectory(mappingDefinitionId);
        switch (mappingFormat) {
            case JSON: {
                try {
                    admHandler.setMappingDefinitionBytes(mapping);
                    admHandler.persist();
                    if (admHandler.getMappingDefinition() != null) {
                        builder.path(admHandler.getMappingDefinition().getName());
                    }
                }
                catch (AtlasException e) {
                    LOG.error("Error saving Mapping Definition file.\n" + e.getMessage(), (Throwable)e);
                    throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
                return Response.ok().location(builder.build(new Object[0])).build();
            }
            case GZ: {
                LOG.debug("  saveGzippedADMDigestRequest '{}' - ID: {}", (Object)admHandler.getGzippedADMDigestFileName(), (Object)mappingDefinitionId);
                try {
                    admHandler.setGzippedADMDigest(mapping);
                    admHandler.persist();
                }
                catch (AtlasException e) {
                    LOG.error("Error saving gzipped ADM digest file.\n" + e.getMessage(), (Throwable)e);
                    throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
                builder.path(admHandler.getGzippedADMDigestFileName());
                return Response.ok().location(builder.build(new Object[0])).build();
            }
            case ZIP: {
                LOG.debug("  importADMArchiveRequest - ID:'{}'", (Object)mappingDefinitionId);
                try {
                    admHandler.setIgnoreLibrary(false);
                    admHandler.setLibraryDirectory(Paths.get(this.libFolder, new String[0]));
                    admHandler.load(mapping);
                    this.libraryLoader.reload();
                    admHandler.persist();
                    LOG.debug("  importADMArchiveRequest complete - ID:'{}'", (Object)mappingDefinitionId);
                }
                catch (Exception e) {
                    LOG.error("Error importing ADM archive.\n" + e.getMessage(), (Throwable)e);
                    throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                }
                builder.path("atlasmap-" + mappingDefinitionId + ".adm");
                return Response.ok().location(builder.build(new Object[0])).build();
            }
            case XML: {
                throw new WebApplicationException("XML mapping format is no longer supported. Please use JSON format instead.");
            }
        }
        throw new WebApplicationException("Unrecognized mapping format: " + mappingFormat, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @Deprecated
    @POST
    @Path(value="/mapping")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Mapping", description="Update existing mapping file on the server")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded")})
    public Response updateMappingRequestOld(InputStream mapping, @Context UriInfo uriInfo) {
        return this.updateMappingRequest(mapping, 0, uriInfo);
    }

    @POST
    @Path(value="/mapping/{mappingDefinitionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Mapping", description="Update existing mapping file on the server")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded")})
    public Response updateMappingRequest(InputStream mapping, @Parameter(description="Mapping Definition ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId, @Context UriInfo uriInfo) {
        ADMArchiveHandler handler = this.loadExplodedMappingDirectory(mappingDefinitionId);
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        try {
            handler.setMappingDefinitionBytes(mapping);
            handler.persist();
            builder.path(handler.getMappingDefinition().getName());
        }
        catch (AtlasException e) {
            LOG.error("Error saving Mapping Definition file.\n" + e.getMessage(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok().location(builder.build(new Object[0])).build();
    }

    @Deprecated
    @PUT
    @Path(value="/mapping/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Validate Mapping", description="Validate mapping file")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Validations.class))}, description="Return a validation result")})
    public Response validateMappingRequestOld(InputStream mapping, @Context UriInfo uriInfo) {
        return this.validateMappingRequest(mapping, 0, uriInfo);
    }

    @PUT
    @Path(value="/mapping/validate/{mappingDefinitionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Validate Mapping", description="Validate mapping file")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=Validations.class))}, description="Return a validation result")})
    public Response validateMappingRequest(InputStream mapping, @Parameter(description="Mapping ID") @PathParam(value="mappingDefinitionId") Integer mappingDefinitionId, @Context UriInfo uriInfo) {
        try {
            AtlasMapping atlasMapping = this.fromJson(mapping, AtlasMapping.class);
            LOG.debug("Validate mappings: {}", (Object)atlasMapping.getName());
            return this.validateMapping(mappingDefinitionId, atlasMapping, uriInfo);
        }
        catch (AtlasException | IOException e) {
            throw new WebApplicationException(e.getMessage(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/mapping/process")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Process Mapping", description="Process Mapping by feeding input data")
    @RequestBody(description="Mapping file content", content={@Content(schema=@Schema(implementation=AtlasMapping.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=ProcessMappingResponse.class))}, description="Return a mapping result"), @ApiResponse(responseCode="204", description="Skipped empty mapping execution")})
    public Response processMappingRequest(InputStream request, @Context UriInfo uriInfo) {
        ProcessMappingRequest pmr = this.fromJson(request, ProcessMappingRequest.class);
        if (pmr.getAtlasMapping() != null) {
            throw new WebApplicationException("Whole mapping execution is not yet supported");
        }
        Mapping mapping = pmr.getMapping();
        if (mapping == null) {
            return Response.noContent().build();
        }
        Audits audits = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Preview request: {}", (Object)new String(this.toJson(mapping)));
            }
            audits = this.previewContext.processPreview(mapping);
        }
        catch (AtlasException e) {
            throw new WebApplicationException("Unable to process mapping preview", (Throwable)e);
        }
        ProcessMappingResponse response = new ProcessMappingResponse();
        response.setMapping(mapping);
        if (audits != null) {
            response.setAudits(audits);
        }
        byte[] serialized = this.toJson(response);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preview outcome: {}", (Object)new String(serialized));
        }
        return Response.ok().entity((Object)serialized).build();
    }

    @GET
    @Path(value="/ping")
    @Operation(summary="Ping", description="Simple liveness check method used in liveness checks. Must not be protected via authetication.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(type="string"))}, description="Return 'pong'")})
    public Response ping() {
        LOG.debug("Ping...  responding with 'pong'.");
        return Response.ok().entity((Object)this.toJson("pong")).build();
    }

    @GET
    @Path(value="/version")
    @Operation(summary="Version", description="Retrieves AtlasMap core library version.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(type="string"))}, description="Return 'pong'")})
    public Response version() {
        String version = (String)this.atlasContextFactory.getProperties().get("atlasmap.core.version");
        LOG.debug("Answering AtlasMap version: {}", (Object)version);
        return Response.ok().entity((Object)this.toJson(version)).build();
    }

    @GET
    @Path(value="/library/list")
    @Produces(value={"application/json"})
    @Operation(summary="List Library Classes", description="Retrieves a list of available Java library class names from uploaded JARs.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(type="ArrayList<String>"))}, description="Return a list of loadable class names")})
    public Response listLibraryClasses(@Context UriInfo uriInfo) {
        ArrayList<String> classNames;
        try {
            classNames = this.libraryLoader.getLibraryClassNames();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Library class retrieval error.", (Throwable)e);
            }
            throw new WebApplicationException("Error retrieving class names from uploaded JARs.");
        }
        byte[] serialized = this.toJson(classNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new String(serialized));
        }
        return Response.ok().entity((Object)serialized).build();
    }

    @PUT
    @Path(value="/library")
    @Operation(summary="Upload Library", description="Upload a Java library archive file")
    @Consumes(value={"application/octet-stream"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Library upload successful.")})
    public Response uploadLibrary(InputStream requestIn) {
        if (requestIn == null) {
            throw new WebApplicationException("No library file found in request body");
        }
        try {
            this.libraryLoader.addJarFromStream(requestIn);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to import a jar file. This error occurs when:\n").append("\t1. The jar file is not compatible with the JVM AtlasMap backend server is running on\n").append("\t2. The jar file is broken\n").append("\t3. There is a missing file under META-INF/services, i.e. Java service declaration for custom transformation, custom transformation model, custom mapping builder, etc\n");
            throw new WebApplicationException(buf.toString(), (Throwable)e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/mappingBuilders")
    @Operation(summary="List mapping builder classes", description="List mapping builder classes which defines custom mapping logic")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(type="ArrayList<String>"))}, description="Return a list of loadable class names")})
    public Response listMappingBuilderClasses(@Context UriInfo uriInfo) {
        ArrayList<String> classNames;
        try {
            classNames = this.libraryLoader.getSubTypesOf(AtlasMappingBuilder.class, false);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Library class retrieval error.", (Throwable)e);
            }
            throw new WebApplicationException("Error retrieving class names from uploaded JARs.");
        }
        byte[] serialized = this.toJson(classNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug(new String(serialized));
        }
        return Response.ok().entity((Object)serialized).build();
    }

    public AtlasLibraryLoader getLibraryLoader() {
        return this.libraryLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response validateMapping(Integer mappingDefinitionId, AtlasMapping mapping, UriInfo uriInfo) throws IOException, AtlasException {
        AtlasSession session;
        DefaultAtlasContextFactory defaultAtlasContextFactory = this.atlasContextFactory;
        synchronized (defaultAtlasContextFactory) {
            DefaultAtlasContext context = this.atlasContextFactory.createContext(mapping);
            session = context.createSession();
            context.processValidation(session);
        }
        Validations validations = session.getValidations();
        if (session.getValidations() == null) {
            validations = new Validations();
        }
        return Response.ok().entity((Object)this.toJson(validations)).build();
    }

    private byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            if (LOG.isDebugEnabled()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(value));
                StringBuffer buf = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                }
                LOG.debug(buf.toString());
                return (T)Json.withClassLoader((ClassLoader)((Object)this.libraryLoader)).readValue(buf.toString(), clazz);
            }
            return (T)Json.withClassLoader((ClassLoader)((Object)this.libraryLoader)).readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    private String getMappingSubDirectory(Integer mappingDefinitionId) {
        return this.mappingFolder + File.separator + mappingDefinitionId;
    }

    private ADMArchiveHandler loadExplodedMappingDirectory(Integer mappingDefinitionId) {
        java.nio.file.Path mappingDirPath = Paths.get(this.getMappingSubDirectory(mappingDefinitionId), new String[0]);
        File mappingDirFile = mappingDirPath.toFile();
        if (!mappingDirFile.exists()) {
            mappingDirFile.mkdirs();
        }
        ADMArchiveHandler admHandler = new ADMArchiveHandler((ClassLoader)((Object)this.libraryLoader));
        admHandler.setIgnoreLibrary(true);
        try {
            admHandler.load(mappingDirPath);
        }
        catch (Exception e) {
            LOG.error("Unexpected error while loading mapping directory.\n" + e.getMessage(), (Throwable)e);
            throw new WebApplicationException(e.getMessage(), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return admHandler;
    }
}

