/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldTransformer;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.v2.XmlField;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlFieldReader
extends XmlFieldTransformer
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFieldReader.class);
    private AtlasConversionService conversionService;
    private Document document;

    private XmlFieldReader() {
    }

    public XmlFieldReader(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public XmlFieldReader(AtlasConversionService conversionService, Map<String, String> namespaces) {
        super(namespaces);
        this.conversionService = conversionService;
    }

    public void read(AtlasInternalSession session) throws AtlasException {
        if (this.document == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("'document' cannot be null"));
        }
        Field field = session.head().getSourceField();
        if (field == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        this.seedDocumentNamespaces(this.document);
        XmlField xmlField = (XmlField)XmlField.class.cast(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading source value for field: " + xmlField.getPath());
        }
        if (this.document == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'document' cannot be null"));
        }
        if (xmlField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'xmlField' cannot be null"));
        }
        Element parentNode = this.document.getDocumentElement();
        for (AtlasPath.SegmentContext sc : new XmlPath(xmlField.getPath()).getSegmentContexts(false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing segment: " + sc.getSegment());
                LOG.debug("Parent element is currently: " + XmlIOHelper.writeDocumentToString(true, parentNode));
            }
            if (sc.getPrev() == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping root segment: " + sc);
                continue;
            }
            if (!XmlPath.isAttributeSegment((String)sc.getSegment()).booleanValue()) {
                List<Element> children;
                String childrenElementName = XmlPath.cleanPathSegment((String)sc.getSegment());
                String namespaceAlias = XmlPath.getNamespace(sc.getSegment());
                if (namespaceAlias != null && !"".equals(namespaceAlias)) {
                    childrenElementName = namespaceAlias + ":" + childrenElementName;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Looking for children elements with name: " + childrenElementName);
                }
                if ((children = XmlIOHelper.getChildrenWithName(childrenElementName, parentNode)) == null || children.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping source value set, couldn't find children with name '" + childrenElementName + "', for segment: " + sc);
                    }
                    return;
                }
                parentNode = children.get(0);
                if (XmlPath.isCollectionSegment((String)sc.getSegment()).booleanValue()) {
                    int index = XmlPath.indexOfSegment((String)sc.getSegment());
                    if (index >= children.size()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Skipping source value set, children list can't fit index " + index + ", children list size: " + children.size());
                        }
                        return;
                    }
                    parentNode = children.get(index);
                }
            }
            if (sc.getNext() != null) continue;
            String value = parentNode.getTextContent();
            if (XmlPath.isAttributeSegment((String)sc.getSegment()).booleanValue()) {
                String attributeName = XmlPath.getAttribute((String)sc.getSegment());
                value = parentNode.getAttribute(attributeName);
            }
            if (value == null) {
                return;
            }
            if (xmlField.getFieldType() == null) {
                xmlField.setValue((Object)value);
                xmlField.setFieldType(FieldType.STRING);
                continue;
            }
            try {
                Object convertedValue = this.conversionService.convertType((Object)value, xmlField.getFormat(), xmlField.getFieldType(), null);
                xmlField.setValue(convertedValue);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)xmlField.getDocId(), (String)String.format("Failed to convert field value '%s' into type '%s'", value, xmlField.getFieldType()), (String)xmlField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)value);
            }
        }
    }

    public void setDocument(String docString, boolean namespaced) throws AtlasException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaced);
            DocumentBuilder b = dbf.newDocumentBuilder();
            this.document = b.parse(new ByteArrayInputStream(docString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

