/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.core.AtlasPath;
import java.util.Map;

public class XmlPath
extends AtlasPath {
    public static final String PATH_SEPARATOR = "/";
    public static final String AT = "@";
    public static final String COLON = ":";

    public XmlPath(String path) {
        super(path);
    }

    public XmlPath(String path, Map<String, String> namespacesToReplace) {
        super(XmlPath.updatedPath(path, namespacesToReplace));
    }

    private static String updatedPath(String fieldPath, Map<String, String> namespacesToReplace) {
        boolean isStartedWtSlash = false;
        String path = fieldPath;
        String updatedPath = "";
        if (namespacesToReplace != null && namespacesToReplace.size() > 0) {
            if (path != null && !"".equals(path)) {
                if (path.startsWith(PATH_SEPARATOR)) {
                    path = path.replaceFirst(PATH_SEPARATOR, "");
                    isStartedWtSlash = true;
                }
                if (path.contains(PATH_SEPARATOR)) {
                    String[] parts;
                    for (String part : parts = path.split(PATH_SEPARATOR, 512)) {
                        int index = part.indexOf(COLON);
                        if (index >= 0) {
                            String namespace;
                            if (part.startsWith(AT)) {
                                namespace = part.substring(1, index);
                                if (namespacesToReplace.containsKey(namespace)) {
                                    updatedPath = updatedPath + PATH_SEPARATOR + AT + namespacesToReplace.get(namespace) + part.substring(index);
                                    continue;
                                }
                                updatedPath = updatedPath + PATH_SEPARATOR + part;
                                continue;
                            }
                            namespace = part.substring(0, index);
                            if (namespacesToReplace.containsKey(namespace)) {
                                updatedPath = updatedPath + PATH_SEPARATOR + namespacesToReplace.get(namespace) + part.substring(index);
                                continue;
                            }
                            updatedPath = updatedPath + PATH_SEPARATOR + part;
                            continue;
                        }
                        updatedPath = updatedPath + PATH_SEPARATOR + part;
                    }
                } else {
                    updatedPath = path;
                }
                if (!isStartedWtSlash) {
                    updatedPath = updatedPath.substring(1);
                }
            } else {
                updatedPath = path;
            }
        }
        return updatedPath;
    }

    public static Boolean isNamespaceSegment(String pathSegment) {
        return pathSegment != null && pathSegment.contains(COLON);
    }

    public static String getNamespace(String pathSeg) {
        String pathSegment = pathSeg;
        if (!XmlPath.isNamespaceSegment(pathSegment).booleanValue()) {
            return null;
        }
        if ((pathSegment = pathSegment.substring(0, pathSegment.indexOf(58))).startsWith(AT)) {
            pathSegment = pathSegment.substring(1);
        }
        return pathSegment;
    }
}

