/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldTransformer;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlFieldWriter
extends XmlFieldTransformer
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFieldWriter.class);
    private Document document = null;
    private boolean enableElementNamespaces = true;
    private boolean enableAttributeNamespaces = true;
    private boolean ignoreMissingNamespaces = true;

    public XmlFieldWriter() throws AtlasException {
        this(new HashMap<String, String>(), null);
    }

    public XmlFieldWriter(Map<String, String> namespaces, String seedDocument) throws AtlasException {
        super(namespaces);
        this.document = this.createDocument(namespaces, seedDocument);
        this.seedDocumentNamespaces(this.document);
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        if (targetField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now processing field p={} t={} v={}", new Object[]{targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
        XmlPath path = new XmlPath(targetField.getPath());
        String lastSegment = path.getLastSegment();
        Element parentNode = null;
        String parentSegment = null;
        for (String segment : path.getSegments()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing segment: {}", (Object)segment);
                LOG.debug("Parent element is currently: {}", (Object)XmlIOHelper.writeDocumentToString(true, parentNode));
            }
            if (parentNode == null) {
                parentNode = this.document.getDocumentElement();
                String cleanedSegment = XmlPath.cleanPathSegment((String)segment);
                if (parentNode == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating root element with name: {}", (Object)cleanedSegment);
                    }
                    Element rootNode = this.createElement(segment);
                    this.addNamespacesToElement(rootNode, this.namespaces);
                    this.document.appendChild(rootNode);
                    parentNode = rootNode;
                } else if (!parentNode.getNodeName().equals(segment)) {
                    throw new AtlasException(String.format("Root element name '%s' does not match expected name '%s' from path: %s", parentNode.getNodeName(), segment, targetField.getPath()));
                }
                parentSegment = segment;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                if (segment.equals(lastSegment)) {
                    LOG.debug("Now processing field value segment: {}", (Object)segment);
                } else {
                    LOG.debug("Now processing parent segment: {}", (Object)segment);
                }
            }
            if (segment.equals(lastSegment) && targetField.getValue() == null) break;
            if (!XmlPath.isAttributeSegment((String)segment).booleanValue()) {
                Element childNode = this.getChildNode(parentNode, parentSegment, segment);
                if (childNode == null) {
                    childNode = this.createParentNode(parentNode, parentSegment, segment);
                }
                parentNode = childNode;
                parentSegment = segment;
            }
            if (!segment.equals(lastSegment)) continue;
            this.writeValue(parentNode, segment, targetField);
        }
    }

    private void addNamespacesToElement(Element node, Map<String, String> namespaces) {
        for (String namespaceAlias : namespaces.keySet()) {
            String namespaceUri = namespaces.get(namespaceAlias);
            String attributeName = "xmlns";
            if (namespaceAlias != null && !namespaceAlias.equals("")) {
                attributeName = attributeName + ":" + namespaceAlias;
            }
            node.setAttributeNS("http://www.w3.org/2000/xmlns/", attributeName, namespaceUri);
        }
    }

    private void writeValue(Element parentNode, String segment, Field field) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing field value in parent node '{}', parentNode: {}", (Object)segment, (Object)XmlIOHelper.writeDocumentToString(true, parentNode));
        }
        String value = this.convertValue(field);
        if (XmlPath.isAttributeSegment((String)segment).booleanValue()) {
            String cleanedSegment = XmlPath.cleanPathSegment((String)segment);
            if (this.enableAttributeNamespaces) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attribute namespaces are enabled, determining namespace.");
                }
                String namespaceAlias = null;
                String namespaceUri = null;
                if (XmlPath.isNamespaceSegment(segment).booleanValue()) {
                    namespaceAlias = XmlPath.getNamespace(segment);
                    namespaceUri = (String)this.namespaces.get(namespaceAlias);
                    LOG.debug("Parsed namespace alias '{}', from segment '{}', namespaceUri: {}", new Object[]{namespaceAlias, segment, namespaceUri});
                }
                if (!this.ignoreMissingNamespaces && namespaceUri == null) {
                    throw new AtlasException(String.format("Cannot find namespace URI for attribute: '%s', available namespaces: %s", segment, this.namespaces));
                }
                if (namespaceUri != null) {
                    parentNode.setAttributeNS(namespaceUri, namespaceAlias + ":" + cleanedSegment, value);
                } else {
                    parentNode.setAttribute(cleanedSegment, value);
                }
            } else {
                parentNode.setAttribute(cleanedSegment, value);
            }
        } else {
            parentNode.setTextContent(value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent node after value written: {}", (Object)XmlIOHelper.writeDocumentToString(true, parentNode));
        }
    }

    private Element getChildNode(Element parentNode, String parentSegment, String segment) throws AtlasException {
        Element childNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for child node '{}' in parent '{}': {}", new Object[]{segment, parentSegment, XmlIOHelper.writeDocumentToString(true, parentNode)});
        }
        if (parentNode == null) {
            return null;
        }
        String cleanedSegment = XmlPath.cleanPathSegment((String)segment);
        String namespaceAlias = XmlPath.getNamespace(segment);
        if (namespaceAlias != null && !namespaceAlias.isEmpty()) {
            cleanedSegment = namespaceAlias + ":" + cleanedSegment;
        }
        List<Element> children = XmlIOHelper.getChildrenWithName(cleanedSegment, parentNode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} children in '{}' with the name '{}'", new Object[]{children.size(), parentSegment, cleanedSegment});
        }
        Element element = childNode = children.size() > 0 ? children.get(0) : null;
        if (children.size() > 0 && XmlPath.isCollectionSegment((String)segment).booleanValue()) {
            int index = XmlPath.indexOfSegment((String)segment);
            childNode = null;
            if (children.size() > index) {
                childNode = children.get(index);
            }
        }
        if (LOG.isDebugEnabled()) {
            if (childNode == null) {
                LOG.debug("Could not find child node '{}' in parent '{}'", (Object)segment, (Object)parentSegment);
            } else {
                LOG.debug("Found child node '{}' in parent '{}', class: {}, node: {}", new Object[]{segment, parentSegment, childNode.getClass().getName(), XmlIOHelper.writeDocumentToString(true, childNode)});
            }
        }
        return childNode;
    }

    private Element createParentNode(Element parentNode, String parentSegment, String segment) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating parent node '{}' under previous parent '{}'.", (Object)segment, (Object)parentSegment);
        }
        Element childNode = null;
        String cleanedSegment = XmlPath.cleanPathSegment((String)segment);
        if (XmlPath.isCollectionSegment((String)segment).booleanValue()) {
            List<Element> children;
            int index = XmlPath.indexOfSegment((String)segment);
            String namespaceAlias = XmlPath.getNamespace(segment);
            if (namespaceAlias != null && !"".equals(namespaceAlias)) {
                cleanedSegment = namespaceAlias + ":" + cleanedSegment;
            }
            if ((children = XmlIOHelper.getChildrenWithName(cleanedSegment, parentNode)).size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Child Element Array is too small, resizing to accomodate index: {}, current array: {}", (Object)index, children);
                }
                while (children.size() < index + 1) {
                    Element child = (Element)parentNode.appendChild(this.createElement(segment));
                    children.add(child);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Child Element Array after resizing: {}", children);
                }
            }
            children = XmlIOHelper.getChildrenWithName(cleanedSegment, parentNode);
            childNode = children.get(index);
        } else {
            childNode = (Element)parentNode.appendChild(this.createElement(segment));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent Node '{}' after adding child parent node '{}': {}", new Object[]{parentSegment, segment, XmlIOHelper.writeDocumentToString(true, parentNode)});
        }
        return childNode;
    }

    private Element createElement(String segment) throws AtlasException {
        String cleanedSegment = XmlPath.cleanPathSegment((String)segment);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating element for segment '{}'.", (Object)segment);
        }
        if (this.enableElementNamespaces) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Element namespaces are enabled, determining namespace.");
            }
            String namespaceAlias = null;
            String namespaceUri = null;
            if (XmlPath.isNamespaceSegment(segment).booleanValue()) {
                namespaceAlias = XmlPath.getNamespace(segment);
                namespaceUri = (String)this.namespaces.get(namespaceAlias);
                LOG.debug("Parsed namespace alias '{}', from segment '{}', namespaceUri: {}, known namespaces: {}", new Object[]{namespaceAlias, segment, namespaceUri, this.namespaces});
            }
            if (!this.ignoreMissingNamespaces && namespaceUri == null) {
                throw new AtlasException(String.format("Cannot find namespace URI for element: '%s', available namespaces: %s", segment, this.namespaces));
            }
            if (namespaceUri != null) {
                return this.document.createElementNS(namespaceUri, namespaceAlias + ":" + cleanedSegment);
            }
        }
        return this.document.createElement(cleanedSegment);
    }

    private String convertValue(Field field) {
        String value;
        FieldType type = field.getFieldType();
        Object originalValue = field.getValue();
        String string = value = originalValue != null ? String.valueOf(originalValue) : null;
        if (LOG.isDebugEnabled()) {
            String valueClass = originalValue == null ? "null" : originalValue.getClass().getName();
            LOG.debug("Converted field value. Type: {}, originalValue: {}({}), to: '{}", new Object[]{type, originalValue, valueClass, value});
        }
        return value;
    }

    private Document createDocument(Map<String, String> namespaces, String seedDocument) throws AtlasException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            if (namespaces != null && !namespaces.isEmpty()) {
                documentBuilderFactory.setNamespaceAware(true);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (seedDocument != null) {
                Document document = documentBuilder.parse(new ByteArrayInputStream(seedDocument.getBytes("UTF-8")));
                Element rootNode = document.getDocumentElement();
                NamedNodeMap attributes = rootNode.getAttributes();
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node n = attributes.item(i);
                        String nodeName = n.getNodeName();
                        if (nodeName == null || !nodeName.startsWith("xmlns")) continue;
                        String namespaceAlias = "";
                        if (nodeName.contains(":")) {
                            namespaceAlias = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (namespaces.containsKey(namespaceAlias)) continue;
                        namespaces.put(namespaceAlias, n.getNodeValue());
                    }
                }
                if (namespaces.size() > 0) {
                    Element oldRootNode = rootNode;
                    rootNode = (Element)oldRootNode.cloneNode(true);
                    this.addNamespacesToElement(rootNode, namespaces);
                    document.removeChild(oldRootNode);
                    document.appendChild(rootNode);
                }
                return document;
            }
            return documentBuilder.newDocument();
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isEnableElementNamespaces() {
        return this.enableElementNamespaces;
    }

    public void setEnableElementNamespaces(boolean enableElementNamespaces) {
        this.enableElementNamespaces = enableElementNamespaces;
    }

    public boolean isEnableAttributeNamespaces() {
        return this.enableAttributeNamespaces;
    }

    public void setEnableAttributeNamespaces(boolean enableAttributeNamespaces) {
        this.enableAttributeNamespaces = enableAttributeNamespaces;
    }

    public boolean isIgnoreMissingNamespaces() {
        return this.ignoreMissingNamespaces;
    }

    public void setIgnoreMissingNamespaces(boolean ignoreMissingNamespaces) {
        this.ignoreMissingNamespaces = ignoreMissingNamespaces;
    }
}

