/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlIOHelper {
    public static List<Element> getChildrenWithName(String name, Element parentNode) {
        LinkedList<Element> children = new LinkedList<Element>();
        if (parentNode == null) {
            return children;
        }
        NodeList nodeChildren = parentNode.getChildNodes();
        for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals(name)) continue;
            children.add((Element)child);
        }
        return children;
    }

    public static String writeDocumentToString(boolean stripSpaces, Node node) throws AtlasException {
        try {
            if (node == null) {
                return "";
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String result = writer.getBuffer().toString();
            if (stripSpaces) {
                result = result.replaceAll("\n|\r", "");
                result = result.replaceAll("> *?<", "><");
            }
            return result;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

