/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.xml.inspect.InstanceInspector;
import io.atlasmap.xml.inspect.SchemaInspector;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.v2.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlInspectionService {
    public XmlDocument inspectXmlDocument(String sourceDocument) throws XmlInspectionException {
        Document document;
        if (sourceDocument == null || sourceDocument.isEmpty()) {
            throw new IllegalArgumentException("Source must be specified");
        }
        try {
            document = this.getDocument(new ByteArrayInputStream(sourceDocument.getBytes()), true);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlInspectionException(e.getMessage(), e);
        }
        return this.inspectXmlDocument(document);
    }

    public XmlDocument inspectXmlDocument(File sourceDocument) throws XmlInspectionException {
        Document document;
        if (sourceDocument == null) {
            throw new IllegalArgumentException("Source must be specified");
        }
        try {
            document = this.getDocument(new FileInputStream(sourceDocument), true);
        }
        catch (Exception e) {
            throw new XmlInspectionException(e.getMessage(), e);
        }
        return this.inspectXmlDocument(document);
    }

    public XmlDocument inspectXmlDocument(Document sourceDocument) {
        if (sourceDocument == null) {
            throw new IllegalArgumentException("Source must be specified");
        }
        InstanceInspector inspector = new InstanceInspector();
        inspector.inspect(sourceDocument);
        return inspector.getXmlDocument();
    }

    public XmlDocument inspectSchema(String schemaSource) throws XmlInspectionException {
        if (schemaSource == null || schemaSource.isEmpty()) {
            throw new IllegalArgumentException("Source must be specified");
        }
        SchemaInspector inspector = new SchemaInspector();
        inspector.inspect(schemaSource);
        return inspector.getXmlDocument();
    }

    public XmlDocument inspectSchema(File schemaFile) throws XmlInspectionException {
        if (schemaFile == null || !schemaFile.exists()) {
            throw new IllegalArgumentException("Source must be specified and available");
        }
        SchemaInspector inspector = new SchemaInspector();
        inspector.inspect(schemaFile);
        return inspector.getXmlDocument();
    }

    private Document getDocument(InputStream is, boolean namespaced) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaced);
        DocumentBuilder b = dbf.newDocumentBuilder();
        return b.parse(is);
    }
}

