/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XSOMClasspathEntityResolver
implements EntityResolver {
    private ClassLoader classLoader;

    public XSOMClasspathEntityResolver(ClassLoader loader) {
        this.classLoader = loader != null ? loader : XSOMClasspathEntityResolver.class.getClassLoader();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URI uri;
        if (publicId != null || systemId == null) {
            return null;
        }
        try {
            uri = new URI(systemId);
        }
        catch (Exception e) {
            return null;
        }
        if (uri.getScheme() != null || uri.getSchemeSpecificPart() == null) {
            return null;
        }
        String path = uri.getSchemeSpecificPart();
        if (path.startsWith(".") || path.startsWith(File.pathSeparator)) {
            return null;
        }
        InputStream is = this.classLoader.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        return new InputSource(is);
    }
}

