/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldTransformer;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlFieldWriter
extends XmlFieldTransformer
implements AtlasFieldWriter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFieldWriter.class);
    private Document document = null;
    private boolean enableElementNamespaces = true;
    private boolean enableAttributeNamespaces = true;
    private boolean ignoreMissingNamespaces = true;

    public XmlFieldWriter() throws AtlasException {
        this(XmlFieldWriter.class.getClassLoader(), new HashMap<String, String>(), null);
    }

    public XmlFieldWriter(ClassLoader classLoader, Map<String, String> namespaces, String seedDocument) throws AtlasException {
        super(classLoader, namespaces);
        this.classLoader = classLoader;
        this.document = this.createDocument(namespaces, seedDocument);
        this.seedDocumentNamespaces(this.document);
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        if (targetField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now processing field path={} type={} value={}", new Object[]{targetField.getPath(), targetField.getFieldType(), targetField.getValue()});
        }
        XmlPath path = new XmlPath(targetField.getPath());
        XmlPath.XmlSegmentContext lastSegment = path.getLastSegment();
        Element parentNode = null;
        XmlPath.XmlSegmentContext parentSegment = null;
        for (XmlPath.XmlSegmentContext segment : path.getXmlSegments(false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing segment: {}", (Object)segment);
                LOG.debug("Parent element is currently: {}", (Object)this.xmlHelper.writeDocumentToString(true, parentNode));
            }
            if (parentNode == null) {
                parentNode = this.document.getDocumentElement();
                if (parentNode == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Creating root element with name: {}", (Object)segment.getName());
                    }
                    Element rootNode = this.createElement(segment);
                    this.addNamespacesToElement(rootNode, this.namespaces);
                    this.document.appendChild(rootNode);
                    parentNode = rootNode;
                } else if (!parentNode.getNodeName().equals(segment.getQName())) {
                    throw new AtlasException(String.format("Root element name '%s' does not match expected name '%s' from path: %s", parentNode.getNodeName(), segment.getName(), targetField.getPath()));
                }
                parentSegment = segment;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                if (((Object)((Object)segment)).equals((Object)lastSegment)) {
                    LOG.debug("Now processing field value segment: {}", (Object)segment);
                } else {
                    LOG.debug("Now processing parent segment: {}", (Object)segment);
                }
            }
            if (((Object)((Object)segment)).equals((Object)lastSegment) && targetField.getValue() == null) break;
            if (!segment.isAttribute()) {
                Element childNode = this.getChildNode(parentNode, parentSegment, segment);
                if (childNode == null) {
                    childNode = this.createParentNode(parentNode, parentSegment, segment);
                }
                if (childNode == null) {
                    return;
                }
                parentNode = childNode;
                parentSegment = segment;
            }
            if (!((Object)((Object)segment)).equals((Object)lastSegment)) continue;
            this.writeValue(parentNode, segment, targetField);
        }
    }

    private void addNamespacesToElement(Element node, Map<String, String> namespaces) {
        for (String namespaceAlias : namespaces.keySet()) {
            String namespaceUri = namespaces.get(namespaceAlias);
            String attributeName = "xmlns";
            if (namespaceAlias != null && !namespaceAlias.equals("")) {
                attributeName = attributeName + ":" + namespaceAlias;
            }
            node.setAttributeNS("http://www.w3.org/2000/xmlns/", attributeName, namespaceUri);
        }
    }

    private void writeValue(Element parentNode, XmlPath.XmlSegmentContext segment, Field field) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing field value in parent node '{}', parentNode: {}", (Object)segment, (Object)this.xmlHelper.writeDocumentToString(true, parentNode));
        }
        String value = this.convertValue(field);
        if (segment.isAttribute()) {
            if (this.enableAttributeNamespaces) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attribute namespaces are enabled, determining namespace.");
                }
                String namespaceAlias = null;
                String namespaceUri = null;
                if (segment.getNamespace() != null) {
                    namespaceAlias = segment.getNamespace();
                    namespaceUri = (String)this.namespaces.get(namespaceAlias);
                    LOG.debug("Parsed namespace alias '{}', from segment '{}', namespaceUri: {}", new Object[]{namespaceAlias, segment, namespaceUri});
                }
                if (!this.ignoreMissingNamespaces && namespaceUri == null) {
                    throw new AtlasException(String.format("Cannot find namespace URI for attribute: '%s', available namespaces: %s", new Object[]{segment, this.namespaces}));
                }
                if (namespaceUri != null) {
                    parentNode.setAttributeNS(namespaceUri, namespaceAlias + ":" + segment.getName(), value);
                } else {
                    parentNode.setAttribute(segment.getName(), value);
                }
            } else {
                parentNode.setAttribute(segment.getName(), value);
            }
        } else {
            parentNode.setTextContent(value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent node after value written: {}", (Object)this.xmlHelper.writeDocumentToString(true, parentNode));
        }
    }

    private Element getChildNode(Element parentNode, XmlPath.XmlSegmentContext parentSegment, XmlPath.XmlSegmentContext segment) throws AtlasException {
        Element childNode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking for child node '{}' in parent '{}': {}", new Object[]{segment, parentSegment, this.xmlHelper.writeDocumentToString(true, parentNode)});
        }
        if (parentNode == null) {
            return null;
        }
        String cleanedSegmentName = segment.getName();
        String namespaceAlias = segment.getNamespace();
        if (namespaceAlias != null && !namespaceAlias.isEmpty()) {
            cleanedSegmentName = namespaceAlias + ":" + cleanedSegmentName;
        }
        List<Element> children = XmlIOHelper.getChildrenWithName(cleanedSegmentName, parentNode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} children in '{}' with the name '{}'", new Object[]{children.size(), parentSegment, cleanedSegmentName});
        }
        Element element = childNode = children.size() > 0 ? children.get(0) : null;
        if (children.size() > 0 && segment.getCollectionType() != CollectionType.NONE) {
            int index = segment.getCollectionIndex();
            childNode = null;
            if (children.size() > index) {
                childNode = children.get(index);
            }
        }
        if (LOG.isDebugEnabled()) {
            if (childNode == null) {
                LOG.debug("Could not find child node '{}' in parent '{}'", (Object)segment, (Object)parentSegment);
            } else {
                LOG.debug("Found child node '{}' in parent '{}', class: {}, node: {}", new Object[]{segment, parentSegment, childNode.getClass().getName(), this.xmlHelper.writeDocumentToString(true, childNode)});
            }
        }
        return childNode;
    }

    private Element createParentNode(Element parentNode, XmlPath.XmlSegmentContext parentSegment, XmlPath.XmlSegmentContext segment) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating parent node '{}' under previous parent '{}'.", (Object)segment, (Object)parentSegment);
        }
        Element childNode = null;
        String cleanedSegmentName = segment.getName();
        if (segment.getCollectionType() != CollectionType.NONE) {
            List<Element> children;
            Integer index = segment.getCollectionIndex();
            if (index == null) {
                return null;
            }
            String namespaceAlias = segment.getNamespace();
            if (namespaceAlias != null && !"".equals(namespaceAlias)) {
                cleanedSegmentName = namespaceAlias + ":" + cleanedSegmentName;
            }
            if ((children = XmlIOHelper.getChildrenWithName(cleanedSegmentName, parentNode)).size() < index + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Child Element Array is too small, resizing to accomodate index: {}, current array: {}", (Object)index, children);
                }
                while (children.size() < index + 1) {
                    Element child = (Element)parentNode.appendChild(this.createElement(segment));
                    children.add(child);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Child Element Array after resizing: {}", children);
                }
            }
            children = XmlIOHelper.getChildrenWithName(cleanedSegmentName, parentNode);
            childNode = children.get(index);
        } else {
            childNode = (Element)parentNode.appendChild(this.createElement(segment));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parent Node '{}' after adding child parent node '{}': {}", new Object[]{parentSegment, segment, this.xmlHelper.writeDocumentToString(true, parentNode)});
        }
        return childNode;
    }

    private Element createElement(XmlPath.XmlSegmentContext segment) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating element for segment '{}'.", (Object)segment);
        }
        if (this.enableElementNamespaces) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Element namespaces are enabled, determining namespace.");
            }
            String namespaceAlias = null;
            String namespaceUri = null;
            if (segment.getNamespace() != null) {
                namespaceAlias = segment.getNamespace();
                namespaceUri = (String)this.namespaces.get(namespaceAlias);
                LOG.debug("Parsed namespace alias '{}', from segment '{}', namespaceUri: {}, known namespaces: {}", new Object[]{namespaceAlias, segment, namespaceUri, this.namespaces});
            }
            if (!this.ignoreMissingNamespaces && namespaceUri == null) {
                throw new AtlasException(String.format("Cannot find namespace URI for element: '%s', available namespaces: %s", new Object[]{segment, this.namespaces}));
            }
            if (namespaceUri != null) {
                return this.document.createElementNS(namespaceUri, namespaceAlias + ":" + segment.getName());
            }
        }
        return this.document.createElement(segment.getName());
    }

    private String convertValue(Field field) {
        String value;
        FieldType type = field.getFieldType();
        Object originalValue = field.getValue();
        String string = value = originalValue != null ? String.valueOf(originalValue) : null;
        if (LOG.isDebugEnabled()) {
            String valueClass = originalValue == null ? "null" : originalValue.getClass().getName();
            LOG.debug("Converted field value. Type: {}, originalValue: {}({}), to: '{}", new Object[]{type, originalValue, valueClass, value});
        }
        return value;
    }

    private Document createDocument(Map<String, String> namespaces, String seedDocument) throws AtlasException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            if (namespaces != null && !namespaces.isEmpty()) {
                documentBuilderFactory.setNamespaceAware(true);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (seedDocument != null && !seedDocument.isEmpty()) {
                Document document = documentBuilder.parse(new ByteArrayInputStream(seedDocument.getBytes("UTF-8")));
                Element rootNode = document.getDocumentElement();
                NamedNodeMap attributes = rootNode.getAttributes();
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node n = attributes.item(i);
                        String nodeName = n.getNodeName();
                        if (nodeName == null || !nodeName.startsWith("xmlns")) continue;
                        String namespaceAlias = "";
                        if (nodeName.contains(":")) {
                            namespaceAlias = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (namespaces.containsKey(namespaceAlias)) continue;
                        namespaces.put(namespaceAlias, n.getNodeValue());
                    }
                }
                if (namespaces.size() > 0) {
                    Element oldRootNode = rootNode;
                    rootNode = (Element)oldRootNode.cloneNode(true);
                    this.addNamespacesToElement(rootNode, namespaces);
                    document.removeChild(oldRootNode);
                    document.appendChild(rootNode);
                }
                return document;
            }
            return documentBuilder.newDocument();
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean isEnableElementNamespaces() {
        return this.enableElementNamespaces;
    }

    public void setEnableElementNamespaces(boolean enableElementNamespaces) {
        this.enableElementNamespaces = enableElementNamespaces;
    }

    public boolean isEnableAttributeNamespaces() {
        return this.enableAttributeNamespaces;
    }

    public void setEnableAttributeNamespaces(boolean enableAttributeNamespaces) {
        this.enableAttributeNamespaces = enableAttributeNamespaces;
    }

    public boolean isIgnoreMissingNamespaces() {
        return this.ignoreMissingNamespaces;
    }

    public void setIgnoreMissingNamespaces(boolean ignoreMissingNamespaces) {
        this.ignoreMissingNamespaces = ignoreMissingNamespaces;
    }
}

