/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.xml.core.XmlIOHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlFieldTransformer {
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected ClassLoader classLoader;
    protected XmlIOHelper xmlHelper;

    public XmlFieldTransformer(ClassLoader cl) {
        this(cl, new HashMap<String, String>());
    }

    public XmlFieldTransformer(ClassLoader cl, Map<String, String> namespaces) {
        this.classLoader = cl;
        this.xmlHelper = new XmlIOHelper(cl);
        this.namespaces = namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    protected void seedDocumentNamespaces(Document document) {
        NodeList nodeList = document.getChildNodes();
        if (this.namespaces == null) {
            this.namespaces = new LinkedHashMap<String, String>();
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int x = 0; x < namedNodeMap.getLength(); ++x) {
                Node attribute = namedNodeMap.item(x);
                if (attribute.getNamespaceURI() == null) continue;
                if (attribute.getLocalName().equals("xmlns")) {
                    this.namespaces.put(attribute.getNodeValue(), "");
                    continue;
                }
                this.namespaces.put(attribute.getNodeValue(), attribute.getLocalName());
            }
        }
    }
}

