/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.atlasmap.v2.Json;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.InspectionType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import io.atlasmap.xml.v2.XmlInspectionResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas/xml")
public class XmlService {
    private static final Logger LOG = LoggerFactory.getLogger(XmlService.class);

    protected byte[] toJson(Object value) {
        try {
            return Json.mapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected <T> T fromJson(InputStream value, Class<T> clazz) {
        try {
            return (T)Json.mapper().readValue(value, clazz);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @GET
    @Path(value="/inspect")
    @Produces(value={"application/json"})
    public Response getClass(@QueryParam(value="uri") String uri, @QueryParam(value="type") String type) {
        XmlDocument d = null;
        try {
            if (type == null) {
                throw new Exception("uri and type parameters must be specified");
            }
            InspectionType inspectType = InspectionType.valueOf((String)type);
            XmlInspectionService s = new XmlInspectionService();
            switch (inspectType) {
                case INSTANCE: {
                    d = s.inspectXmlDocument(new File(uri));
                    break;
                }
                case SCHEMA: {
                    d = s.inspectSchema(new File(uri));
                    break;
                }
                default: {
                    throw new Exception("Unknown type specified: " + type);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error inspecting xml: " + e.getMessage(), (Throwable)e);
        }
        return Response.ok().entity((Object)this.toJson(d)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/inspect")
    public Response inspectClass(InputStream request) {
        return this.inspectClass(this.fromJson(request, XmlInspectionRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Response inspectClass(XmlInspectionRequest request) {
        block10: {
            startTime = System.currentTimeMillis();
            response = new XmlInspectionResponse();
            d = null;
            try {
                if (request.getType() == null) {
                    response.setErrorMessage("Instance or Schema type must be specified in request");
                    break block10;
                }
                s = new XmlInspectionService();
                switch (1.$SwitchMap$io$atlasmap$xml$v2$InspectionType[request.getType().ordinal()]) {
                    case 1: {
                        d = s.inspectXmlDocument(request.getXmlData());
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        d = s.inspectSchema(request.getXmlData());
                        ** break;
lbl17:
                        // 1 sources

                        break;
                    }
                    default: {
                        response.setErrorMessage("Unsupported inspection type: " + request.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                XmlService.LOG.error("Error inspecting xml: " + e.getMessage(), (Throwable)e);
                response.setErrorMessage(e.getMessage());
            }
            finally {
                response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            }
        }
        response.setXmlDocument(d);
        return Response.ok().entity((Object)this.toJson(response)).build();
    }
}

