/*
 * Decompiled with CFR 0.152.
 */
package com.mediadriver.atlas.java.module.v2;

import com.mediadriver.atlas.api.v2.AtlasContextFactory;
import com.mediadriver.atlas.api.v2.AtlasConversionException;
import com.mediadriver.atlas.api.v2.AtlasException;
import com.mediadriver.atlas.api.v2.AtlasNotFoundException;
import com.mediadriver.atlas.api.v2.AtlasSession;
import com.mediadriver.atlas.core.v2.AtlasUtil;
import com.mediadriver.atlas.core.v2.DefaultAtlasContextFactory;
import com.mediadriver.atlas.java.v2.JavaField;
import com.mediadriver.atlas.javapath.v2.JavaPath;
import com.mediadriver.atlas.spi.v2.AtlasModule;
import com.mediadriver.atlas.spi.v2.AtlasModuleDetail;
import com.mediadriver.atlas.spi.v2.AtlasModuleMode;
import com.mediadriver.atlas.v2.AtlasMapping;
import com.mediadriver.atlas.v2.AtlasModelFactory;
import com.mediadriver.atlas.v2.Field;
import com.mediadriver.atlas.v2.FieldAction;
import com.mediadriver.atlas.v2.FieldActions;
import com.mediadriver.atlas.v2.FieldMapping;
import com.mediadriver.atlas.v2.FieldMappings;
import com.mediadriver.atlas.v2.FieldType;
import com.mediadriver.atlas.v2.MapAction;
import com.mediadriver.atlas.v2.MapFieldMapping;
import com.mediadriver.atlas.v2.MappedField;
import com.mediadriver.atlas.v2.SeparateFieldMapping;
import java.lang.reflect.Method;
import java.util.List;

@AtlasModuleDetail(name="JavaModule", uri="atlas:java", modes={"SOURCE", "TARGET"}, dataFormats={"java"}, configPackages={"com.mediadriver.atlas.java.v2"})
public class JavaModule
implements AtlasModule {
    public void init() {
    }

    public void destroy() {
    }

    public void processInput(AtlasSession session) throws AtlasException {
        AtlasMapping atlasMapping = session.getAtlasMapping();
        FieldMappings fieldMappings = atlasMapping.getFieldMappings();
        List fieldMappingList = fieldMappings.getFieldMapping();
        Object source = session.getInput();
        try {
            MappedField sourceMappedField = null;
            Field sourceField = null;
            for (FieldMapping fieldMapping : fieldMappingList) {
                if (fieldMapping instanceof MapFieldMapping) {
                    sourceMappedField = ((MapFieldMapping)fieldMapping).getInputField();
                    sourceField = sourceMappedField.getField();
                    if (!(sourceField instanceof JavaField)) continue;
                    this.populateValue((JavaField)sourceField, source);
                    continue;
                }
                if (!(fieldMapping instanceof SeparateFieldMapping) || !((sourceField = (sourceMappedField = ((SeparateFieldMapping)fieldMapping).getInputField()).getField()) instanceof JavaField)) continue;
                this.populateValue((JavaField)sourceField, source);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AtlasNotFoundException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new AtlasException(e.getMessage(), e.getCause());
        }
    }

    protected void populateValue(JavaField javaField, Object source) throws Exception {
        Object sourceValue = null;
        if (javaField.getPath().contains(".")) {
            Object parentObject = this.getParentObject(new JavaPath(javaField.getPath()), source);
            Method parentGet = parentObject.getClass().getDeclaredMethod(javaField.getGetMethod(), new Class[0]);
            parentGet.setAccessible(true);
            sourceValue = parentGet.invoke(parentObject, new Object[0]);
            javaField.setValue(sourceValue);
        } else {
            Method getText = source.getClass().getMethod(javaField.getGetMethod(), new Class[0]);
            getText.setAccessible(true);
            javaField.setValue(getText.invoke(source, new Object[0]));
        }
    }

    public void processOutput(AtlasSession session) throws AtlasException {
        String targetClassName = AtlasUtil.getUriParameterValue((String)session.getAtlasMapping().getTargetUri(), (String)"className");
        AtlasMapping atlasMapping = session.getAtlasMapping();
        FieldMappings fieldMappings = atlasMapping.getFieldMappings();
        List fieldMappingList = fieldMappings.getFieldMapping();
        try {
            Class<?> targetClazz = this.getClass().getClassLoader().loadClass(targetClassName);
            Object targetObject = targetClazz.newInstance();
            MappedField sourceMappedField = null;
            MappedField targetMappedField = null;
            Field sourceField = null;
            JavaField targetField = null;
            Object sourceValue = null;
            for (FieldMapping fieldMapping : fieldMappingList) {
                if (fieldMapping instanceof MapFieldMapping) {
                    sourceMappedField = ((MapFieldMapping)fieldMapping).getInputField();
                    targetMappedField = ((MapFieldMapping)fieldMapping).getOutputField();
                    sourceField = sourceMappedField.getField();
                    sourceValue = sourceField.getValue();
                    targetField = (JavaField)targetMappedField.getField();
                    Method targetMethod = targetClazz.getDeclaredMethod(targetField.getSetMethod(), AtlasModelFactory.classFromFieldType((FieldType)targetField.getType()));
                    targetMethod.setAccessible(true);
                    targetMethod.invoke(targetObject, sourceValue);
                    continue;
                }
                if (!(fieldMapping instanceof SeparateFieldMapping)) continue;
                sourceMappedField = ((SeparateFieldMapping)fieldMapping).getInputField();
                sourceField = sourceMappedField.getField();
                sourceValue = sourceField.getValue();
                if (!(sourceValue instanceof String)) {
                    // empty if block
                }
                List<String> sourceValues = this.separateValue(session, (String)sourceValue, ((SeparateFieldMapping)fieldMapping).getDelimiterValue());
                for (MappedField tmpTargetMappedField : ((SeparateFieldMapping)fieldMapping).getOutputFields().getMappedField()) {
                    targetField = (JavaField)tmpTargetMappedField.getField();
                    FieldActions fieldActions = tmpTargetMappedField.getFieldActions();
                    for (FieldAction fieldAction : fieldActions.getFieldAction()) {
                        if (!(fieldAction instanceof MapAction)) continue;
                        Method targetMethod = targetClazz.getDeclaredMethod(targetField.getSetMethod(), AtlasModelFactory.classFromFieldType((FieldType)targetField.getType()));
                        targetMethod.setAccessible(true);
                        targetMethod.invoke(targetObject, sourceValues.get(((MapAction)fieldAction).getIndex()));
                    }
                }
            }
            session.setOutput(targetObject);
        }
        catch (Exception e) {
            throw new AtlasException(e.getMessage(), e.getCause());
        }
    }

    protected Object getParentObject(JavaPath javaPath, Object sourceObject) throws Exception {
        Object tmpObject = sourceObject;
        if (javaPath.getSegments() == null || javaPath.getSegments().size() < 2) {
            return sourceObject;
        }
        Class<?> tmpClass = sourceObject.getClass();
        int limit = javaPath.getSegments().size() - 1;
        for (int i = 0; i < limit; ++i) {
            Method tmpMethod = tmpClass.getDeclaredMethod("get" + (String)javaPath.getSegments().get(i), new Class[0]);
            tmpMethod.setAccessible(true);
            tmpObject = tmpMethod.invoke(tmpObject, new Object[0]);
        }
        return tmpObject;
    }

    protected List<String> separateValue(AtlasSession session, String value, String delimiter) throws AtlasConversionException {
        AtlasContextFactory contextFactory = session.getAtlasContext().getContextFactory();
        if (contextFactory instanceof DefaultAtlasContextFactory) {
            return ((DefaultAtlasContextFactory)contextFactory).getSeparateStrategy().separateValue(value, delimiter, null);
        }
        throw new AtlasConversionException("No supported SeparateStrategy found");
    }

    public AtlasModuleMode getMode() {
        return null;
    }

    public void setMode(AtlasModuleMode atlasModuleMode) {
    }

    public List<AtlasModuleMode> listSupportedModes() {
        return null;
    }

    public Boolean isStatisticsSupported() {
        return null;
    }

    public Boolean isStatisticsEnabled() {
        return null;
    }

    public Boolean isSupportedField(Field field) {
        if (field instanceof JavaField) {
            return true;
        }
        return false;
    }
}

