/*
 * Decompiled with CFR 0.152.
 */
package com.mediadriver.atlas.java.service.v2;

import com.mediadriver.atlas.java.inspect.v2.ClassInspectionService;
import com.mediadriver.atlas.java.inspect.v2.MavenClasspathHelper;
import com.mediadriver.atlas.java.v2.ClassInspectionRequest;
import com.mediadriver.atlas.java.v2.ClassInspectionResponse;
import com.mediadriver.atlas.java.v2.JavaClass;
import com.mediadriver.atlas.java.v2.MavenClasspathRequest;
import com.mediadriver.atlas.java.v2.MavenClasspathResponse;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="/")
@Path(value="v2/atlas/java")
public class JavaService
extends Application {
    final Application javaServiceApp = new ResourceConfig().register(JacksonFeature.class);
    private static final Logger logger = LoggerFactory.getLogger(JavaService.class);

    @GET
    @Path(value="/simple")
    @Produces(value={"text/plain"})
    public String simpleHelloWorld(@QueryParam(value="from") String from) {
        return "Got it! " + from;
    }

    @OPTIONS
    @Path(value="/class")
    @Produces(value={"application/json"})
    public Response testJsonOptions() throws Exception {
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").build();
    }

    @GET
    @Path(value="/class")
    @Produces(value={"application/json"})
    public Response getClass(@QueryParam(value="className") String className) throws Exception {
        ClassInspectionService classInspectionService = new ClassInspectionService();
        JavaClass c = classInspectionService.inspectClass(className);
        classInspectionService = null;
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").entity((Object)c).build();
    }

    @OPTIONS
    @Path(value="/mavenclasspath")
    @Produces(value={"application/json"})
    public Response generateClasspathCORS() throws Exception {
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/mavenclasspath")
    public Response generateClasspath(MavenClasspathRequest request) throws Exception {
        MavenClasspathResponse response = new MavenClasspathResponse();
        MavenClasspathHelper mavenClasspathHelper = null;
        try {
            mavenClasspathHelper = new MavenClasspathHelper();
            if (request.getExecuteTimeout() != null) {
                mavenClasspathHelper.setProcessMaxExecutionTime(request.getExecuteTimeout().longValue());
            }
            long startTime = System.currentTimeMillis();
            String mavenResponse = mavenClasspathHelper.generateClasspathFromPom(request.getPomXmlData());
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
            response.setClasspath(mavenResponse);
        }
        catch (Exception e) {
            logger.error("Error generating classpath from maven: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        finally {
            mavenClasspathHelper = null;
        }
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").entity((Object)response).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/class")
    public Response inspectClass(ClassInspectionRequest request) throws Exception {
        ClassInspectionResponse response = new ClassInspectionResponse();
        ClassInspectionService classInspectionService = new ClassInspectionService();
        this.configureInspectionService(classInspectionService, request);
        long startTime = System.currentTimeMillis();
        try {
            JavaClass c = null;
            c = request.getClasspath() == null || request.getClasspath().isEmpty() ? classInspectionService.inspectClass(request.getClassName()) : classInspectionService.inspectClass(request.getClassName(), request.getClasspath());
            response.setJavaClass(c);
        }
        catch (Exception e) {
            logger.error("Error inspecting class with classpath: " + e.getMessage(), (Throwable)e);
            response.setErrorMessage(e.getMessage());
        }
        finally {
            classInspectionService = null;
            response.setExecutionTime(Long.valueOf(System.currentTimeMillis() - startTime));
        }
        return Response.ok().header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"Content-Type").header("Access-Control-Allow-Methods", (Object)"GET,PUT,POST,PATCH,DELETE").entity((Object)response).build();
    }

    protected void configureInspectionService(ClassInspectionService classInspectionService, ClassInspectionRequest request) {
        if (request.getFieldNameBlacklist() != null && request.getFieldNameBlacklist().getString() != null && !request.getFieldNameBlacklist().getString().isEmpty()) {
            classInspectionService.getFieldBlacklist().addAll(request.getFieldNameBlacklist().getString());
        }
        if (request.isDisablePrivateOnlyFields() != null) {
            classInspectionService.setDisablePrivateOnlyFields(request.isDisablePrivateOnlyFields());
        }
        if (request.isDisableProtectedOnlyFields() != null) {
            classInspectionService.setDisableProtectedOnlyFields(request.isDisableProtectedOnlyFields());
        }
        if (request.isDisablePublicOnlyFields() != null) {
            classInspectionService.setDisablePublicOnlyFields(request.isDisablePublicOnlyFields());
        }
        if (request.isDisablePublicGetterSetterFields() != null) {
            classInspectionService.setDisablePublicGetterSetterFields(request.isDisablePublicGetterSetterFields());
        }
    }
}

