/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.builder;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.spi.ActionProcessor;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.Constant;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.PropertyField;
import java.util.List;

public class AtlasField {
    private DefaultAtlasSession session;
    private DefaultAtlasConversionService conversionService;
    private DefaultAtlasFieldActionService fieldActionService;
    private Field rawField;

    public AtlasField(DefaultAtlasSession session) {
        this.session = session;
        this.conversionService = session.getAtlasContext().getContextFactory().getConversionService();
        this.fieldActionService = session.getAtlasContext().getContextFactory().getFieldActionService();
    }

    public AtlasField read(String docId, String path) throws AtlasException {
        AtlasModule module = this.session.resolveModule(docId);
        if (module == null) {
            throw new AtlasException(String.format("Source document '%s' doesn't exist", docId));
        }
        if (module.getMode() != AtlasModuleMode.SOURCE) {
            throw new AtlasException(String.format("Unable to read from %s Document '%s'", new Object[]{module.getMode(), docId}));
        }
        Field sourceField = module.createField();
        sourceField.setDocId(docId);
        sourceField.setPath(path);
        this.session.head().setSourceField(sourceField);
        module.readSourceValue(this.session);
        this.setRawField(sourceField);
        return this;
    }

    public AtlasField readConstant(String name) throws AtlasException {
        ConstantModule module = this.session.getConstantModule();
        List<Constant> constants = this.session.getMapping().getConstants().getConstant();
        for (Constant constant : constants) {
            if (constant.getName() == null || !constant.getName().equals(name)) continue;
            ConstantField sourceField = module.createField();
            sourceField.setName(constant.getName());
            sourceField.setFieldType(constant.getFieldType());
            sourceField.setValue(constant.getValue());
            this.session.head().setSourceField(sourceField);
            module.readSourceValue(this.session);
            this.setRawField(sourceField);
            return this;
        }
        throw new AtlasException(String.format("Constant '%s' not found", name));
    }

    public AtlasField readProperty(String scope, String name) throws AtlasException {
        PropertyModule module = this.session.getSourcePropertyModule();
        PropertyField sourceField = module.createField();
        sourceField.setScope(scope);
        sourceField.setName(name);
        this.session.head().setSourceField(sourceField);
        module.readSourceValue(this.session);
        this.setRawField(sourceField);
        return this;
    }

    public void write(String docId, String path) throws AtlasException {
        AtlasModule module = this.session.resolveModule(docId);
        if (module == null) {
            throw new AtlasException(String.format("Target document '%s' doesn't exist", docId));
        }
        if (module.getMode() != AtlasModuleMode.TARGET) {
            throw new AtlasException(String.format("Unable to write to %s Document '%s'", new Object[]{module.getMode(), docId}));
        }
        Field f = module.createField();
        f.setDocId(docId);
        f.setPath(path);
        this.session.head().setSourceField(this.getRawField());
        this.session.head().setTargetField(f);
        module.populateTargetField(this.session);
        module.writeTargetValue(this.session);
    }

    public void writeProperty(String scope, String name) throws AtlasException {
        PropertyModule module = this.session.getTargetPropertyModule();
        PropertyField f = module.createField();
        f.setScope(scope);
        f.setName(name);
        this.session.head().setSourceField(this.getRawField());
        this.session.head().setTargetField(f);
        module.populateTargetField(this.session);
        module.writeTargetValue(this.session);
    }

    public AtlasField action(String actionName, List<Object> parameters) {
        Object value = parameters != null && parameters.size() > 1 ? parameters.get(parameters.size() - 1) : null;
        ActionProcessor ap = this.fieldActionService.findActionProcessor(actionName, value);
        return this;
    }

    public Field getRawField() {
        return this.rawField;
    }

    public AtlasField setRawField(Field f) {
        this.rawField = f;
        return this;
    }
}

