/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasMappingBuilder;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CustomMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasCustomMappingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasCustomMappingProcessor.class);
    private static DefaultAtlasCustomMappingProcessor instance;

    public static DefaultAtlasCustomMappingProcessor getInstance() {
        if (instance == null) {
            instance = new DefaultAtlasCustomMappingProcessor();
        }
        return instance;
    }

    public void process(DefaultAtlasSession session, CustomMapping customMapping) {
        AtlasMappingBuilder builder;
        String className = customMapping.getClassName();
        if (className == null || className.isEmpty()) {
            AtlasUtil.addAudit((AtlasInternalSession)session, className, "Custom mapping class must be specified", AuditStatus.ERROR, className);
            return;
        }
        DefaultAtlasContextFactory factory = session.getAtlasContext().getContextFactory();
        try {
            Class<?> clazz = factory.getClassLoader().loadClass(className);
            builder = (AtlasMappingBuilder)AtlasMappingBuilder.class.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            builder.setAtlasSession(session);
        }
        catch (Exception e) {
            AtlasUtil.addAudit((AtlasInternalSession)session, className, String.format("Custom mapping class '%s' could not be loaded: %s", className, e.getMessage()), AuditStatus.ERROR, className);
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
        builder.process();
    }
}

