/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.PropertyField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyModule
extends BaseAtlasModule {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyModule.class);
    private AtlasPropertyStrategy defaultStrategy;

    public PropertyModule(AtlasPropertyStrategy propertyStrategy) {
        this.defaultStrategy = propertyStrategy;
    }

    @Override
    public void processPreValidation(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void readSourceValue(AtlasInternalSession session) throws AtlasException {
        AtlasPropertyStrategy strategy = session.getAtlasPropertyStrategy() != null ? session.getAtlasPropertyStrategy() : this.defaultStrategy;
        Field sourceField = session.head().getSourceField();
        if (sourceField instanceof PropertyField) {
            PropertyField sourcePropertyField = (PropertyField)sourceField;
            strategy.readProperty(session, sourcePropertyField);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed source PropertyField: Name={} Scope={} Value={} Strategy={}", new Object[]{sourcePropertyField.getName(), sourcePropertyField.getScope(), sourceField.getValue(), strategy.getClass().getName()});
            }
        }
    }

    @Override
    public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        AtlasPropertyStrategy strategy = session.getAtlasPropertyStrategy() != null ? session.getAtlasPropertyStrategy() : this.defaultStrategy;
        Field targetField = session.head().getTargetField();
        if (targetField instanceof PropertyField) {
            PropertyField targetPropertyField = (PropertyField)targetField;
            strategy.writeProperty(session, targetPropertyField);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed target PropertyField: Name={} Value={} Strategy={}", new Object[]{targetPropertyField.getName(), targetPropertyField.getValue(), strategy.getClass().getName()});
            }
        }
    }

    @Override
    public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public void processPostValidation(AtlasInternalSession session) throws AtlasException {
    }

    @Override
    public Boolean isSupportedField(Field field) {
        return field instanceof PropertyField;
    }

    @Override
    public PropertyField cloneField(Field field) throws AtlasException {
        if (field == null || !(field instanceof PropertyField)) {
            return null;
        }
        PropertyField orig = (PropertyField)field;
        PropertyField clone = new PropertyField();
        AtlasModelFactory.copyField(orig, clone, true);
        clone.setScope(orig.getScope());
        return clone;
    }

    @Override
    public void setDocName(String docName) {
    }

    @Override
    public String getDocName() {
        return "Properties";
    }

    @Override
    public PropertyField createField() {
        return new PropertyField();
    }
}

