/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.v2;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.ServiceLoader;

public class SimpleResolver
extends TypeIdResolverBase {
    protected final HashMap<Class<?>, String> typeToId = new HashMap();
    protected final HashMap<String, JavaType> idToType = new HashMap();
    private JavaType baseType;
    private ClassLoader classLoader;
    private TypeFactory typeFactory;

    public void init(JavaType baseType) {
        this.baseType = baseType;
        Class baseClass = baseType.getRawClass();
        ServiceLoader implementations = ServiceLoader.load(baseClass, this.classLoader != null ? this.classLoader : baseClass.getClassLoader());
        for (Object o : implementations) {
            Class<?> c = o.getClass();
            if (c == baseClass || !baseClass.isAssignableFrom(c)) continue;
            JsonTypeName jsonAnnoation = c.getAnnotation(JsonTypeName.class);
            String id = null;
            id = c.getPackage().getName().equals(baseClass.getPackage().getName()) ? (jsonAnnoation != null && jsonAnnoation.value() != null ? jsonAnnoation.value() : c.getSimpleName()) : c.getName();
            this.typeToId.put(c, id);
            this.idToType.put(id, this.typeFactory.constructSpecializedType(baseType, c));
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> aClass) {
        String rc = this.typeToId.get(aClass);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid type: " + aClass);
        }
        return rc;
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.baseType.getRawClass());
    }

    public JavaType typeFromId(DatabindContext databindContext, String id) throws IOException {
        JavaType rc = this.idToType.get(id);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid type id: " + id);
        }
        return rc;
    }

    public String getDescForKnownTypeIds() {
        return "valid values: " + this.idToType.keySet();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setTypeFactory(TypeFactory tf) {
        this.typeFactory = tf;
    }
}

